/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.ejb.session;

import com.clustercontrol.calendar.ejb.session.CalendarControllerLocal;
import com.clustercontrol.calendar.ejb.session.CalendarControllerUtil;
import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;
import com.clustercontrol.maintenance.bean.ScheduleInfo;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceKeepMstLocal;
import com.clustercontrol.maintenance.factory.AddMaintenance;
import com.clustercontrol.maintenance.factory.DeleteMaintenance;
import com.clustercontrol.maintenance.factory.ModifyMaintenance;
import com.clustercontrol.maintenance.factory.ModifySchedule;
import com.clustercontrol.maintenance.factory.OperationMaintenance;
import com.clustercontrol.maintenance.factory.SelectMaintenanceInfo;
import com.clustercontrol.maintenance.factory.SelectMaintenanceKeepMst;
import com.clustercontrol.maintenance.factory.SelectMaintenanceTypeMst;
import com.clustercontrol.maintenance.factory.SelectSchedule;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.util.apllog.AplLogger;
import com.clustercontrol.vm.bean.NodeOperationStatusConstant;
import java.rmi.RemoteException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class MaintenanceControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(MaintenanceControllerBean.class);
    private SessionContext m_context;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMaintenance(MaintenanceInfoDataImp data, ScheduleInfo schedule) throws CreateException, NamingException, IllegalStateException, SystemException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SchedulerException, ParseException, RemoteException {
        m_log.debug((Object)"addMaintenance");
        Principal pri = this.m_context.getCallerPrincipal();
        TransactionManager tm = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            try {
                if (tm.getTransaction() != null) {
                    oldTx = tm.suspend();
                }
                if (tm.getTransaction() == null) {
                    tm.begin();
                }
                AddMaintenance add = new AddMaintenance();
                add.addMaintenance(data, pri.getName());
                this.addSchedule(schedule);
                result = true;
                if (result) {
                    tm.commit();
                }
            }
            catch (SecurityException e) {
                m_log.debug((Object)("addMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (SystemException e) {
                m_log.debug((Object)("addMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (NotSupportedException e) {
                m_log.debug((Object)("addMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (RollbackException e) {
                m_log.debug((Object)("addMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (HeuristicMixedException e) {
                m_log.debug((Object)("addMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (HeuristicRollbackException e) {
                m_log.debug((Object)("addMaintenance() : " + e.getMessage()));
                throw e;
            }
            finally {
                if (tm.getTransaction() != null && !result) {
                    tm.rollback();
                }
            }
            if (oldTx == null) return;
        }
        catch (CreateException e) {
            try {
                m_log.debug((Object)("addMaintenance() : " + e.getMessage()));
                throw e;
                catch (NamingException e2) {
                    m_log.debug((Object)("addMaintenance() : " + e2.getMessage()));
                    throw e2;
                }
                catch (SchedulerException e3) {
                    m_log.debug((Object)("addMaintenance() : " + e3.getMessage()));
                    throw e3;
                }
                catch (ParseException e4) {
                    m_log.debug((Object)("addMaintenance() : " + e4.getMessage()));
                    throw e4;
                }
                catch (RemoteException e5) {
                    m_log.debug((Object)("addMaintenance() : " + e5.getMessage()));
                    throw e5;
                }
            }
            catch (Throwable throwable) {
                if (oldTx == null) throw throwable;
                try {
                    tm.resume(oldTx);
                    throw throwable;
                }
                catch (InvalidTransactionException e6) {
                    throw e6;
                }
                catch (IllegalStateException e7) {
                    throw e7;
                }
                catch (SystemException e8) {
                    throw e8;
                }
            }
        }
        try {
            tm.resume(oldTx);
            return;
        }
        catch (InvalidTransactionException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (SystemException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyMaintenance(MaintenanceInfoDataImp data, ScheduleInfo schedule) throws FinderException, NamingException, SystemException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SchedulerException, ParseException, RemoteException {
        m_log.debug((Object)"modifyMaintenance");
        Principal pri = this.m_context.getCallerPrincipal();
        TransactionManager tm = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            try {
                if (tm.getTransaction() != null) {
                    oldTx = tm.suspend();
                }
                if (tm.getTransaction() == null) {
                    tm.begin();
                }
                ModifyMaintenance modify = new ModifyMaintenance();
                modify.modifyMaintenance(data, pri.getName());
                this.modifySchedule(schedule);
                result = true;
                if (result) {
                    tm.commit();
                }
            }
            catch (SecurityException e) {
                m_log.debug((Object)("modifyMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (SystemException e) {
                m_log.debug((Object)("modifyMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (NotSupportedException e) {
                m_log.debug((Object)("modifyMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (RollbackException e) {
                m_log.debug((Object)("modifyMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (HeuristicMixedException e) {
                m_log.debug((Object)("modifyMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (HeuristicRollbackException e) {
                m_log.debug((Object)("modifyMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (CreateException e) {
                m_log.debug((Object)("modifyMaintenance() : " + e.getMessage()));
                e.printStackTrace();
            }
            catch (RemoveException e) {
                m_log.debug((Object)("modifyMaintenance() : " + e.getMessage()));
                e.printStackTrace();
            }
            finally {
                if (tm.getTransaction() != null && !result) {
                    tm.rollback();
                }
            }
            if (oldTx == null) return;
        }
        catch (NamingException e) {
            try {
                m_log.debug((Object)("modifyMaintenance() : " + e.getMessage()));
                throw e;
                catch (SchedulerException e2) {
                    m_log.debug((Object)("modifyMaintenance() : " + e2.getMessage()));
                    throw e2;
                }
                catch (ParseException e3) {
                    m_log.debug((Object)("modifyMaintenance() : " + e3.getMessage()));
                    throw e3;
                }
                catch (RemoteException e4) {
                    m_log.debug((Object)("modifyMaintenance() : " + e4.getMessage()));
                    throw e4;
                }
            }
            catch (Throwable throwable) {
                if (oldTx == null) throw throwable;
                try {
                    tm.resume(oldTx);
                    throw throwable;
                }
                catch (InvalidTransactionException e5) {
                    throw e5;
                }
                catch (IllegalStateException e6) {
                    throw e6;
                }
                catch (SystemException e7) {
                    throw e7;
                }
            }
        }
        try {
            tm.resume(oldTx);
            return;
        }
        catch (InvalidTransactionException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (SystemException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteMaintenance(String maintenanceId) throws RemoveException, NamingException, SystemException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SchedulerException, RemoteException, EJBException {
        m_log.debug((Object)"deleteMaintenance");
        TransactionManager tm = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            try {
                if (tm.getTransaction() != null) {
                    oldTx = tm.suspend();
                }
                if (tm.getTransaction() == null) {
                    tm.begin();
                }
                DeleteMaintenance delete = new DeleteMaintenance();
                delete.deleteMaintenance(maintenanceId);
                this.deleteSchedule(maintenanceId);
                result = true;
                if (result) {
                    tm.commit();
                }
            }
            catch (SecurityException e) {
                m_log.debug((Object)("deleteMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (SystemException e) {
                m_log.debug((Object)("deleteMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (NotSupportedException e) {
                m_log.debug((Object)("deleteMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (RollbackException e) {
                m_log.debug((Object)("deleteMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (HeuristicMixedException e) {
                m_log.debug((Object)("deleteMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (HeuristicRollbackException e) {
                m_log.debug((Object)("deleteMaintenance() : " + e.getMessage()));
                throw e;
            }
            catch (FinderException e) {
                m_log.debug((Object)("deleteMaintenance() : " + e.getMessage()));
                e.printStackTrace();
            }
            catch (CreateException e) {
                m_log.debug((Object)("deleteMaintenance() : " + e.getMessage()));
                e.printStackTrace();
            }
            finally {
                if (tm.getTransaction() != null && !result) {
                    tm.rollback();
                }
            }
            if (oldTx == null) return;
        }
        catch (NamingException e) {
            try {
                m_log.debug((Object)("deleteMaintenance() : " + e.getMessage()));
                throw e;
                catch (SchedulerException e2) {
                    m_log.debug((Object)("deleteMaintenance() : " + e2.getMessage()));
                    throw e2;
                }
                catch (RemoteException e3) {
                    m_log.debug((Object)("deleteMaintenance() : " + e3.getMessage()));
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                if (oldTx == null) throw throwable;
                try {
                    tm.resume(oldTx);
                    throw throwable;
                }
                catch (InvalidTransactionException e4) {
                    throw e4;
                }
                catch (IllegalStateException e5) {
                    throw e5;
                }
                catch (SystemException e6) {
                    throw e6;
                }
            }
        }
        try {
            tm.resume(oldTx);
            return;
        }
        catch (InvalidTransactionException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (SystemException e) {
            throw e;
        }
    }

    public int deleteEventLog(String keep_id) throws FinderException, NamingException, CreateException, SQLException {
        m_log.debug((Object)"deleteEventLog()");
        int ret = -1;
        Connection conn = null;
        Statement stmt = null;
        Timestamp timestamp = this.getTimestamp(keep_id);
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            stmt = conn.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM cc_event_log WHERE output_date < '" + timestamp.toString() + "' AND confirm_flg='1';");
            ret = stmt.executeUpdate(sql.toString());
            m_log.debug((Object)("execute : " + sql.toString()));
            m_log.debug((Object)("delete count : " + ret));
            int n = ret;
            return n;
        }
        catch (SQLException e) {
            m_log.error((Object)("removeAll() error : SQLException " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e) {}
        }
    }

    public int deleteJobHistory(String keep_id) throws FinderException, NamingException, CreateException, SQLException, RemoveException {
        m_log.debug((Object)"deleteJobHistory()");
        int ret = 0;
        Connection conn = null;
        Statement stmt = null;
        Timestamp timestamp = this.getTimestamp(keep_id);
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            stmt = conn.createStatement();
            String select_sessionId = "SELECT session_id from cc_job_session_job where (status='300' OR status='301') and end_date < '" + timestamp.toString() + "'";
            String sql_select_list = "select session_id, job_id from cc_job_session_job WHERE session_id IN (" + select_sessionId + ");";
            ResultSet res = stmt.executeQuery(sql_select_list);
            ArrayList<String> notifyGroupIdList = new ArrayList<String>();
            HashSet<String> sessionIds = new HashSet<String>();
            while (res.next()) {
                sessionIds.add(res.getString(1));
                notifyGroupIdList.add(NotifyRelationInfo.createNotifyGroupIdJobInfo((String)res.getString(1), (String)res.getString(2), (Integer)0));
            }
            if (sessionIds.size() == 0) {
                ret = 0;
            } else {
                m_log.debug((Object)"delete start");
                m_log.debug((Object)("DELETE FROM cc_job_session WHERE session_id IN (" + select_sessionId + ");"));
                ret = stmt.executeUpdate("DELETE FROM cc_job_session WHERE session_id IN (" + select_sessionId + ");");
            }
            m_log.debug((Object)("delete count : " + ret));
            NotifyControllerLocal notifyController = NotifyControllerUtil.getLocalHome().create();
            Iterator itr = notifyGroupIdList.iterator();
            String deleteNotifyGroupId = null;
            while (itr.hasNext()) {
                deleteNotifyGroupId = (String)itr.next();
                notifyController.deleteNotifyRelation(deleteNotifyGroupId);
                notifyController.deleteNotifyInhibition(deleteNotifyGroupId);
            }
            int n = ret;
            return n;
        }
        catch (SQLException e) {
            m_log.error((Object)("removeAll() error : SQLException " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            m_log.error((Object)("removeAll() error : RemoveException " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e) {}
        }
    }

    public int deleteCollectiveRunHistory(String keep_id) throws FinderException, NamingException, CreateException, SQLException {
        m_log.debug((Object)"deleteCollectiveRunHistory()");
        int ret = -1;
        Connection conn = null;
        Statement stmt = null;
        Timestamp timestamp = this.getTimestamp(keep_id);
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            stmt = conn.createStatement();
            String select_sessionId = "SELECT session_id from cc_crun_session WHERE end_date < '" + timestamp.toString() + "' AND status='300'";
            ret = stmt.executeUpdate("DELETE FROM cc_crun_session WHERE session_id IN(" + select_sessionId + ");");
            m_log.debug((Object)("delete count : " + ret));
            int n = ret;
            return n;
        }
        catch (SQLException e) {
            m_log.error((Object)("removeAll() error : SQLException " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e) {}
        }
    }

    public int deleteVmLog(String keep_id) throws FinderException, NamingException, CreateException, SQLException {
        m_log.debug((Object)"deleteVmLog()");
        int ret = -1;
        Connection conn = null;
        Statement stmt = null;
        Timestamp timestamp = this.getTimestamp(keep_id);
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            stmt = conn.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM cc_vm_operation_detail WHERE end_date < '" + timestamp.toString() + "' AND (status = " + NodeOperationStatusConstant.STOP + " OR status = " + NodeOperationStatusConstant.FAIL + ");");
            ret = stmt.executeUpdate(sql.toString());
            m_log.debug((Object)("execute : " + sql.toString()));
            m_log.debug((Object)("delete count : " + ret));
            int n = ret;
            return n;
        }
        catch (SQLException e) {
            m_log.error((Object)("removeAll() error : SQLException " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e) {}
        }
    }

    public void addSchedule(ScheduleInfo info) throws NamingException, SchedulerException, ParseException, RemoteException {
        m_log.debug((Object)("addSchedule() : scheduleId=" + info.getId()));
        Principal pri = this.m_context.getCallerPrincipal();
        ModifySchedule modify = new ModifySchedule();
        try {
            modify.addSchedule(info, pri.getName());
        }
        catch (ParseException e) {
            AplLogger apllog = new AplLogger("MAINTENANCE", "maintenance");
            Object[] args = new String[]{info.getId()};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("addSchedule() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MAINTENANCE", "maintenance");
            Object[] args = new String[]{info.getId()};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("addSchedule() : " + e.getMessage()));
            throw e;
        }
        catch (SchedulerException e) {
            AplLogger apllog = new AplLogger("MAINTENANCE", "maintenance");
            Object[] args = new String[]{info.getId()};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("addSchedule() : " + e.getMessage()));
            throw e;
        }
    }

    public void modifySchedule(ScheduleInfo info) throws NamingException, SchedulerException, ParseException, RemoteException {
        m_log.debug((Object)("modifySchedule() : scheduleId=" + info.getId()));
        Principal pri = this.m_context.getCallerPrincipal();
        ModifySchedule modify = new ModifySchedule();
        try {
            modify.modifySchedule(info, pri.getName());
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MAINTENANCE", "maintenance");
            Object[] args = new String[]{info.getId()};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("modifySchedule() : " + e.getMessage()));
            throw e;
        }
        catch (SchedulerException e) {
            AplLogger apllog = new AplLogger("MAINTENANCE", "maintenance");
            Object[] args = new String[]{info.getId()};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("modifySchedule() : " + e.getMessage()));
            throw e;
        }
        catch (ParseException e) {
            AplLogger apllog = new AplLogger("MAINTENANCE", "maintenance");
            Object[] args = new String[]{info.getId()};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("modifySchedule() : " + e.getMessage()));
            throw e;
        }
    }

    public void deleteSchedule(String scheduleId) throws NamingException, SchedulerException, RemoteException {
        m_log.debug((Object)("deleteSchedule() : scheduleId=" + scheduleId));
        ModifySchedule modify = new ModifySchedule();
        try {
            modify.deleteSchedule(scheduleId);
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MAINTENANCE", "maintenance");
            Object[] args = new String[]{scheduleId};
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("deleteSchedule() : " + e.getMessage()));
            throw e;
        }
        catch (SchedulerException e) {
            AplLogger apllog = new AplLogger("MAINTENANCE", "maintenance");
            Object[] args = new String[]{scheduleId};
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("deleteSchedule() : " + e.getMessage()));
            throw e;
        }
    }

    public MaintenanceInfoDataImp getMaintenanceInfo(String maintenanceId) throws FinderException, NamingException, CreateException {
        m_log.debug((Object)"getMaintenanceInfoData()");
        SelectMaintenanceInfo select = new SelectMaintenanceInfo();
        MaintenanceInfoDataImp info = select.getMaintenanceInfo(maintenanceId);
        return info;
    }

    public ArrayList getMaintenanceList() throws FinderException, NamingException, CreateException, SchedulerException {
        m_log.debug((Object)"getMaintenanceList()");
        SelectMaintenanceInfo select = new SelectMaintenanceInfo();
        ArrayList list = select.getMaintenanceList();
        return list;
    }

    public ArrayList getMaintenanceTypeList() throws FinderException, NamingException, CreateException {
        m_log.debug((Object)"getMaintenanceTypeList()");
        SelectMaintenanceTypeMst select = new SelectMaintenanceTypeMst();
        ArrayList list = select.getMaintenanceTypeMst();
        return list;
    }

    public ArrayList getMaintenanceTypeNameIdList() throws FinderException, NamingException, CreateException {
        m_log.debug((Object)"getMaintenanceTypeNameIdList()");
        SelectMaintenanceTypeMst select = new SelectMaintenanceTypeMst();
        ArrayList list = select.getMaintenanceTypeNameIdList();
        return list;
    }

    public ArrayList getMaintenanceKeepNameIdList() throws FinderException, NamingException, CreateException {
        m_log.debug((Object)"getMaintenanceKeepList()");
        SelectMaintenanceKeepMst select = new SelectMaintenanceKeepMst();
        ArrayList list = select.getMaintenanceKeepNameIdList();
        return list;
    }

    public ArrayList getMaintenanceListTableDefine(Locale local) {
        SelectMaintenanceInfo maintenance = new SelectMaintenanceInfo();
        ArrayList tableDefine = maintenance.getMaintenanceListTableDefine(local);
        return tableDefine;
    }

    public ArrayList getSchedule(String maintenanceId) throws NamingException, SchedulerException {
        m_log.debug((Object)"getSchedule()");
        SelectSchedule select = new SelectSchedule();
        ArrayList info = select.getSchedule(maintenanceId);
        return info;
    }

    public ArrayList getScheduleList() throws NamingException, SchedulerException {
        m_log.debug((Object)"getScheduleList()");
        SelectSchedule select = new SelectSchedule();
        ArrayList list = select.getScheduleList();
        return list;
    }

    public void scheduleRunMaintenance(String maintenanceId, String calendarId) {
        m_log.debug((Object)("scheduleRunMaintenance() : maintenanceId=" + maintenanceId + ", calendarId=" + calendarId));
        try {
            boolean check = false;
            if (calendarId != null && calendarId.length() > 0) {
                CalendarControllerLocal calendar = CalendarControllerUtil.getLocalHome().create();
                if (calendar.isRun(calendarId, new Date()).booleanValue()) {
                    check = true;
                }
            } else {
                check = true;
            }
            if (!check) {
                return;
            }
            this.runMaintenance(maintenanceId);
        }
        catch (CreateException e) {
        }
        catch (NamingException e) {
        }
        catch (FinderException e) {
            m_log.debug((Object)("scheduleRunJob() -> " + e.getMessage()));
        }
    }

    public void runMaintenance(String maintenanceId) {
        m_log.debug((Object)("runMaintenance() : maintenanceId=" + maintenanceId));
        OperationMaintenance operation = new OperationMaintenance();
        operation.runMaintenance(maintenanceId);
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    private Timestamp getTimestamp(String keep_id) throws FinderException, NamingException, CreateException {
        int order_no = 0;
        if (keep_id != null && !keep_id.equals("")) {
            SelectMaintenanceKeepMst select = new SelectMaintenanceKeepMst();
            MaintenanceKeepMstLocal mst = select.getMaintenanceKeepMst(keep_id);
            order_no = mst.getOrder_no();
        }
        Calendar calendar = GregorianCalendar.getInstance();
        switch (order_no) {
            case 1: {
                calendar.add(4, -1);
                break;
            }
            case 2: {
                calendar.add(4, -2);
                break;
            }
            case 3: {
                calendar.add(2, -1);
                break;
            }
            case 4: {
                calendar.add(2, -2);
                break;
            }
            case 5: {
                calendar.add(2, -3);
                break;
            }
            case 6: {
                calendar.add(2, -6);
                break;
            }
            case 7: {
                calendar.add(1, -1);
            }
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }
}

