/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.soap;

import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingConstants;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.AttributedURI;
import javax.xml.ws.addressing.ReferenceParameters;
import javax.xml.ws.addressing.Relationship;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.AddressingPropertiesImpl;
import org.jboss.ws.extensions.addressing.EndpointReferenceImpl;
import org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPAddressingPropertiesImpl
extends AddressingPropertiesImpl
implements SOAPAddressingProperties {
    private static AddressingConstants ADDR = new AddressingConstantsImpl();
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private boolean mustunderstand;

    private String getRequiredHeaderContent(SOAPHeader soapHeader, QName qname) {
        Element element = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)qname);
        if (null == element) {
            throw new AddressingException("Required element " + qname + " is missing");
        }
        String value = DOMUtils.getTextContent((Node)element);
        if (null == value || value.equals("")) {
            throw new AddressingException("Required element " + qname + " is missing");
        }
        return value;
    }

    private String getOptionalHeaderContent(SOAPHeader soapHeader, QName qname) {
        Element element = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)qname);
        if (element != null) {
            return DOMUtils.getTextContent((Node)element);
        }
        return null;
    }

    public void readHeaders(SOAPMessage message) throws AddressingException {
        try {
            Element wsaFaultTo;
            Element wsaReplyTo;
            Element wsaFrom;
            SOAPHeader soapHeader = message.getSOAPHeader();
            SOAPAddressingBuilderImpl builder = new SOAPAddressingBuilderImpl();
            AddressingConstants ADDR = builder.newAddressingConstants();
            this.registerNamespaces(ADDR, soapHeader);
            String to = this.getOptionalHeaderContent(soapHeader, ADDR.getToQName());
            if (to != null) {
                this.setTo(builder.newURI(to));
            }
            if ((wsaFrom = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)ADDR.getFromQName())) != null) {
                EndpointReferenceImpl ref = new EndpointReferenceImpl(wsaFrom);
                this.setReplyTo(ref);
            }
            if ((wsaReplyTo = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)ADDR.getReplyToQName())) != null) {
                EndpointReferenceImpl ref = new EndpointReferenceImpl(wsaReplyTo);
                this.setReplyTo(ref);
            }
            if ((wsaFaultTo = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)ADDR.getFaultToQName())) != null) {
                EndpointReferenceImpl ref = new EndpointReferenceImpl(wsaFaultTo);
                this.setFaultTo(ref);
            }
            String action = this.getRequiredHeaderContent(soapHeader, ADDR.getActionQName());
            this.setAction(builder.newURI(action));
            String messageID = this.getOptionalHeaderContent(soapHeader, ADDR.getMessageIDQName());
            if (messageID != null) {
                this.setMessageID(builder.newURI(messageID));
            }
            Iterator itRelatesTo = DOMUtils.getChildElements((Node)soapHeader, (QName)ADDR.getRelatesToQName());
            ArrayList<Relationship> relList = new ArrayList<Relationship>();
            while (itRelatesTo.hasNext()) {
                Element wsaRelatesTo = (Element)itRelatesTo.next();
                QName type = DOMUtils.getAttributeValueAsQName((Element)wsaRelatesTo, (String)ADDR.getRelationshipTypeName());
                String uri = DOMUtils.getTextContent((Node)wsaRelatesTo);
                Relationship rel = builder.newRelationship(new URI(uri));
                rel.setType(type);
                relList.add(rel);
            }
            Relationship[] relArr = (Relationship[])Array.newInstance(Relationship.class, relList.size());
            relList.toArray(relArr);
            this.setRelatesTo(relArr);
            QName refQName = new QName(this.getNamespaceURI(), "IsReferenceParameter");
            ReferenceParameters refParams = this.getReferenceParameters();
            Iterator it = soapHeader.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                if (!"true".equals(DOMUtils.getAttributeValue((Element)headerElement, (QName)refQName))) continue;
                refParams.addElement((Object)headerElement);
            }
        }
        catch (SOAPException ex) {
            throw new AddressingException("Cannot read headers", (Throwable)ex);
        }
        catch (URISyntaxException ex) {
            throw new AddressingException("Cannot read headers", (Throwable)ex);
        }
    }

    private void registerNamespaces(AddressingConstants ADDR, SOAPHeader soapHeader) {
        this.nsRegistry.registerURI(ADDR.getNamespaceURI(), ADDR.getNamespacePrefix());
        NamedNodeMap attribs = soapHeader.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr attr = (Attr)attribs.item(i);
            String attrName = attr.getName();
            String attrValue = attr.getValue();
            if (!attrName.startsWith("xmlns:")) continue;
            String prefix = attrName.substring(6);
            this.nsRegistry.registerURI(attrValue, prefix);
        }
    }

    public void writeHeaders(SOAPMessage message) throws AddressingException {
        try {
            ReferenceParameters refParams;
            SOAPElement soapElement;
            EndpointReferenceImpl epr;
            SOAPFactoryImpl factory = (SOAPFactoryImpl)SOAPFactory.newInstance();
            SOAPHeader soapHeader = message.getSOAPHeader();
            soapHeader.addNamespaceDeclaration(ADDR.getNamespacePrefix(), ADDR.getNamespaceURI());
            if (this.getTo() != null) {
                SOAPElement element = soapHeader.addChildElement((Name)new NameImpl(ADDR.getToQName()));
                element.addTextNode(this.getTo().getURI().toString());
            }
            if (this.getFrom() != null) {
                epr = (EndpointReferenceImpl)this.getFrom();
                epr.setRootQName(ADDR.getFromQName());
                soapElement = factory.createElement(epr.toElement());
                soapElement.removeNamespaceDeclaration(ADDR.getNamespacePrefix());
                soapHeader.addChildElement(soapElement);
            }
            if (this.getReplyTo() != null) {
                epr = (EndpointReferenceImpl)this.getReplyTo();
                epr.setRootQName(ADDR.getReplyToQName());
                soapElement = factory.createElement(epr.toElement());
                soapElement.removeNamespaceDeclaration(ADDR.getNamespacePrefix());
                soapHeader.addChildElement(soapElement);
            }
            if (this.getFaultTo() != null) {
                epr = (EndpointReferenceImpl)this.getFaultTo();
                epr.setRootQName(ADDR.getFaultToQName());
                soapElement = factory.createElement(epr.toElement());
                soapElement.removeNamespaceDeclaration(ADDR.getNamespacePrefix());
                soapHeader.addChildElement(soapElement);
            }
            this.appendRequiredHeader(soapHeader, ADDR.getActionQName(), this.getAction());
            if ((this.getReplyTo() != null || this.getFaultTo() != null) && null == this.getMessageID()) {
                throw new AddressingException("Required addressing header missing:" + ADDR.getMessageIDQName());
            }
            if (this.getMessageID() != null) {
                SOAPElement wsaMessageId = soapHeader.addChildElement((Name)new NameImpl(ADDR.getMessageIDQName()));
                wsaMessageId.addTextNode(this.getMessageID().getURI().toString());
            }
            if (this.getRelatesTo() != null) {
                for (Relationship rel : this.getRelatesTo()) {
                    SOAPElement wsaRelatesTo = soapHeader.addChildElement((Name)new NameImpl(ADDR.getRelatesToQName()));
                    if (rel.getType() != null) {
                        wsaRelatesTo.setAttribute(ADDR.getRelationshipTypeName(), this.getPrefixedName(rel.getType()));
                    }
                    wsaRelatesTo.addTextNode(rel.getID().toString());
                }
            }
            if ((refParams = this.getReferenceParameters()).getElements().size() > 0 || refParams.getAttributes().size() > 0) {
                SOAPElement wsaRefParams = soapHeader.addChildElement((Name)new NameImpl(ADDR.getReferenceParametersQName()));
                this.appendAttributes(wsaRefParams, refParams.getAttributes());
                this.appendElements(wsaRefParams, refParams.getElements());
            }
            this.appendElements((SOAPElement)soapHeader, this.getElements());
        }
        catch (SOAPException ex) {
            throw new AddressingException("Cannot read ws-addressing headers", (Throwable)ex);
        }
    }

    private void appendRequiredHeader(SOAPHeader soapHeader, QName name, AttributedURI value) throws SOAPException {
        if (null == value) {
            throw new AddressingException("Required addressing property missing: " + name);
        }
        SOAPElement element = soapHeader.addChildElement((Name)new NameImpl(name));
        element.addTextNode(value.getURI().toString());
        if (this.mustunderstand) {
            String envNS = soapHeader.getParentElement().getNamespaceURI();
            element.addNamespaceDeclaration("soap", envNS);
            element.addAttribute(new QName(envNS, "mustUnderstand", "soap"), "1");
        }
    }

    public void setMu(boolean mu) {
        this.mustunderstand = mu;
    }

    private void appendAttributes(SOAPElement soapElement, Map<QName, String> attributes) {
        for (QName qname : attributes.keySet()) {
            String qualname = this.getPrefixedName(qname);
            String value = attributes.get(qname);
            soapElement.setAttribute(qualname, value);
        }
    }

    private void appendElements(SOAPElement soapElement, List<Object> elements) {
        try {
            SOAPFactoryImpl factory = (SOAPFactoryImpl)SOAPFactory.newInstance();
            for (Object obj : elements) {
                if (obj instanceof Element) {
                    SOAPElement child = factory.createElement((Element)obj);
                    soapElement.addChildElement(child);
                    continue;
                }
                if (obj instanceof String) {
                    Element el = DOMUtils.parse((String)((String)obj));
                    SOAPElement child = factory.createElement(el);
                    soapElement.addChildElement(child);
                    continue;
                }
                throw new AddressingException("Unsupported element: " + obj.getClass().getName());
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new AddressingException("Cannot append elements", (Throwable)ex);
        }
    }

    private String getPrefixedName(QName qname) {
        String prefix = qname.getPrefix();
        String localPart = qname.getLocalPart();
        String qualname = prefix != null && prefix.length() > 0 ? prefix + ":" + localPart : localPart;
        return qualname;
    }
}

