/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.snmptrap.dao.SnmpTrapInfoDAO;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoBean;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SnmpTrapInfoDAOImpl
implements SnmpTrapInfoDAO {
    protected static Log m_log = LogFactory.getLog(SnmpTrapInfoDAOImpl.class);

    public void init() {
    }

    public void load(SnmpTrapInfoPK pk, SnmpTrapInfoBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_snmp_trap_info WHERE monitor_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.monitorId);
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setMonitorId(res.getString("monitor_id"));
                    ejb.setDescription(res.getString("description"));
                    ejb.setFacilityId(res.getString("facility_id"));
                    ejb.setCommunityName(res.getString("community_name"));
                    ejb.setNotifyGroupId(res.getString("notify_group_id"));
                    ejb.setApplication(res.getString("application"));
                    ejb.setValidFlg(res.getInt("valid_flg"));
                    ejb.setCalendarId(res.getString("calendar_id"));
                    ejb.setRegDate(res.getTimestamp("reg_date"));
                    ejb.setUpdateDate(res.getTimestamp("update_date"));
                    ejb.setRegUser(res.getString("reg_user"));
                    ejb.setUpdateUser(res.getString("update_user"));
                    ejb.setCheckMode(res.getInt("check_mode"));
                    break block13;
                }
                String msg = "SnmpTrapInfo data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(SnmpTrapInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getMonitorId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_snmp_trap_info SET ");
            sql.append("description = ?, ");
            sql.append("facility_id = ?, ");
            sql.append("community_name = ?, ");
            sql.append("notify_group_id = ?, ");
            sql.append("application = ?, ");
            sql.append("valid_flg = ?, ");
            sql.append("calendar_id = ?, ");
            sql.append("reg_date = ?, ");
            sql.append("update_date = ?, ");
            sql.append("reg_user = ?, ");
            sql.append("update_user = ?, ");
            sql.append("check_mode = ?");
            sql.append("WHERE monitor_id = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getDescription());
            stmt.setString(2, ejb.getFacilityId());
            stmt.setString(3, ejb.getCommunityName());
            stmt.setString(4, ejb.getNotifyGroupId());
            stmt.setString(5, ejb.getApplication());
            stmt.setInt(6, ejb.getValidFlg());
            stmt.setString(7, ejb.getCalendarId());
            stmt.setTimestamp(8, ejb.getRegDate());
            stmt.setTimestamp(9, ejb.getUpdateDate());
            stmt.setString(10, ejb.getRegUser());
            stmt.setString(11, ejb.getUpdateUser());
            stmt.setInt(12, ejb.getCheckMode());
            stmt.setString(13, ejb.getMonitorId());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getMonitorId() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getMonitorId() + " SQLException"));
            e.printStackTrace();
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getMonitorId() + " SQLException"));
                e1.printStackTrace();
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getMonitorId()));
    }

    public void remove(SnmpTrapInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_snmp_trap_info WHERE monitor_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.monitorId);
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public SnmpTrapInfoPK create(SnmpTrapInfoBean ejb) throws CreateException, EJBException {
        SnmpTrapInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getMonitorId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_snmp_trap_info (");
            sql.append("monitor_id, ");
            sql.append("description, ");
            sql.append("facility_id, ");
            sql.append("community_name, ");
            sql.append("notify_group_id, ");
            sql.append("application, ");
            sql.append("valid_flg, ");
            sql.append("calendar_id, ");
            sql.append("reg_date, ");
            sql.append("update_date, ");
            sql.append("reg_user, ");
            sql.append("update_user, ");
            sql.append("check_mode ) ");
            sql.append("values (?,?,?,?,?,?,?,?,?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getMonitorId());
            stmt.setString(2, ejb.getDescription());
            stmt.setString(3, ejb.getFacilityId());
            stmt.setString(4, ejb.getCommunityName());
            stmt.setString(5, ejb.getNotifyGroupId());
            stmt.setString(6, ejb.getApplication());
            stmt.setInt(7, ejb.getValidFlg());
            stmt.setString(8, ejb.getCalendarId());
            stmt.setTimestamp(9, ejb.getRegDate());
            stmt.setTimestamp(10, ejb.getUpdateDate());
            stmt.setString(11, ejb.getRegUser());
            stmt.setString(12, ejb.getUpdateUser());
            stmt.setInt(13, ejb.getCheckMode());
            int row = stmt.executeUpdate();
            pk = new SnmpTrapInfoPK(ejb.getMonitorId());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getMonitorId() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getMonitorId() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getMonitorId() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getMonitorId()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<SnmpTrapInfoPK> ret = new ArrayList<SnmpTrapInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT monitor_id FROM cc_snmp_trap_info";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                SnmpTrapInfoPK pk = new SnmpTrapInfoPK(res.getString("monitor_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public SnmpTrapInfoPK findByPrimaryKey(SnmpTrapInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT monitor_id FROM cc_snmp_trap_info WHERE monitor_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.monitorId);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            SnmpTrapInfoPK snmpTrapInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return snmpTrapInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        m_log.debug((Object)("findByFacilityId() start : " + facilityId));
        ArrayList<SnmpTrapInfoPK> ret = new ArrayList<SnmpTrapInfoPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT monitor_id FROM cc_snmp_trap_info WHERE facility_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, facilityId);
                res = stmt.executeQuery();
                while (res.next()) {
                    SnmpTrapInfoPK pk = new SnmpTrapInfoPK(res.getString("monitor_id"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("findByFacilityId() error : " + facilityId + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByFacilityId() error : " + facilityId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("findByFacilityId() error : " + facilityId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findByFacilityId() end : " + facilityId));
        return ret;
    }
}

