/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.tools.cmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.wsf.spi.tools.WSContractConsumer;

public class WSConsume {
    private List<File> bindingFiles = new ArrayList<File>();
    private boolean generateSource = false;
    private File catalog = null;
    private String targetPackage = null;
    private String wsdlLocation = null;
    private boolean quiet = false;
    private boolean verbose = false;
    private boolean loadConsumer = false;
    private File outputDir = new File("output");
    private File sourceDir = null;
    private String target = null;
    public static String PROGRAM_NAME = System.getProperty("program.name", WSConsume.class.getName());

    public static void main(String[] args) {
        WSConsume importer = new WSConsume();
        URL wsdl = importer.parseArguments(args);
        System.exit(importer.importServices(wsdl));
    }

    private URL parseArguments(String[] args) {
        int wsdlPos;
        int c;
        String shortOpts = "b:c:p:w:o:s:t:khqvl";
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("binding", 1, null, 98), new LongOpt("catalog", 1, null, 99), new LongOpt("package", 1, null, 112), new LongOpt("wsdlLocation", 1, null, 119), new LongOpt("output", 1, null, 111), new LongOpt("source", 1, null, 115), new LongOpt("target", 1, null, 116), new LongOpt("keep", 0, null, 107), new LongOpt("help", 0, null, 104), new LongOpt("quiet", 0, null, 113), new LongOpt("verbose", 0, null, 118), new LongOpt("load-consumer", 0, null, 108)};
        Getopt getopt = new Getopt(PROGRAM_NAME, args, shortOpts, longOpts);
        while ((c = getopt.getopt()) != -1) {
            switch (c) {
                case 98: {
                    this.bindingFiles.add(new File(getopt.getOptarg()));
                    break;
                }
                case 107: {
                    this.generateSource = true;
                    break;
                }
                case 99: {
                    this.catalog = new File(getopt.getOptarg());
                    break;
                }
                case 112: {
                    this.targetPackage = getopt.getOptarg();
                    break;
                }
                case 119: {
                    this.wsdlLocation = getopt.getOptarg();
                    break;
                }
                case 111: {
                    this.outputDir = new File(getopt.getOptarg());
                    break;
                }
                case 115: {
                    this.sourceDir = new File(getopt.getOptarg());
                    break;
                }
                case 116: {
                    this.target = getopt.getOptarg();
                    break;
                }
                case 113: {
                    this.quiet = true;
                    break;
                }
                case 118: {
                    this.verbose = true;
                    break;
                }
                case 108: {
                    this.loadConsumer = true;
                    break;
                }
                case 104: {
                    WSConsume.printHelp();
                    System.exit(0);
                }
                case 63: {
                    System.exit(1);
                }
            }
        }
        if (this.loadConsumer) {
            WSContractConsumer importer = WSContractConsumer.newInstance();
            System.out.println("WSContractConsumer instance: " + importer.getClass().getCanonicalName());
            System.exit(0);
        }
        if ((wsdlPos = getopt.getOptind()) >= args.length) {
            System.err.println("Error: WSDL URL was not specified!");
            WSConsume.printHelp();
            System.exit(1);
        }
        URL url = null;
        try {
            try {
                url = new URL(args[wsdlPos]);
            }
            catch (MalformedURLException e) {
                File file = new File(args[wsdlPos]);
                url = file.toURL();
            }
        }
        catch (MalformedURLException e) {
            System.err.println("Error: Invalid URI: " + args[wsdlPos]);
            System.exit(1);
        }
        return url;
    }

    private int importServices(URL wsdl) {
        WSContractConsumer importer = WSContractConsumer.newInstance();
        importer.setGenerateSource(this.generateSource);
        importer.setOutputDirectory(this.outputDir);
        if (this.sourceDir != null) {
            importer.setSourceDirectory(this.sourceDir);
        }
        if (!this.quiet) {
            importer.setMessageStream(System.out);
        }
        if (this.catalog != null) {
            importer.setCatalog(this.catalog);
        }
        if (this.targetPackage != null) {
            importer.setTargetPackage(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            importer.setWsdlLocation(this.wsdlLocation);
        }
        if (this.bindingFiles != null && this.bindingFiles.size() > 0) {
            importer.setBindingFiles(this.bindingFiles);
        }
        if (this.target != null) {
            importer.setTarget(this.target);
        }
        try {
            importer.consume(wsdl);
            return 0;
        }
        catch (Throwable t) {
            System.err.println("Error: Could not import. (use --verbose to see full traces)");
            if (!this.verbose) {
                String message = t.getMessage();
                if (message == null) {
                    message = t.getClass().getSimpleName();
                }
                System.err.println("Error: " + message);
            } else {
                t.printStackTrace(System.err);
            }
            return 1;
        }
    }

    private static void printHelp() {
        PrintStream out = System.out;
        out.println("WSConsumeTask is a cmd line tool that generates portable JAX-WS artifacts from a WSDL file.\n");
        out.println("usage: " + PROGRAM_NAME + " [options] <wsdl-url>\n");
        out.println("options: ");
        out.println("    -h, --help                  Show this help message");
        out.println("    -b, --binding=<file>        One or more JAX-WS or JAXB binding files ");
        out.println("    -k, --keep                  Keep/Generate Java source");
        out.println("    -c  --catalog=<file>        Oasis XML Catalog file for entity resolution");
        out.println("    -p  --package=<name>        The target package for generated source");
        out.println("    -w  --wsdlLocation=<loc>    Value to use for @WebService.wsdlLocation");
        out.println("    -o, --output=<directory>    The directory to put generated artifacts");
        out.println("    -s, --source=<directory>    The directory to put Java source");
        out.println("    -t, --target=<2.0|2.1>      The JAX-WS specification target");
        out.println("    -q, --quiet                 Be somewhat more quiet");
        out.println("    -v, --verbose               Show full exception stack traces");
        out.println("    -l, --load-consumer         Load the consumer and exit (debug utility)");
        out.flush();
    }
}

