/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.monitor.factory;

import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.ejb.bmp.CollectorUtil;
import com.clustercontrol.performance.monitor.bean.MonitorPerfCheckInfo;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.performance.monitor.factory.ModifySchedule;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public class AddMonitorPerformance
extends AddMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(AddMonitorPerformance.class);

    public boolean addCheckInfo() throws CreateException, NamingException {
        String collectorId = CollectorUtil.generateGUID((Object)this);
        MonitorPerfCheckInfo mpInfo = (MonitorPerfCheckInfo)this.m_monitorInfo.getCheckInfo();
        MonitorPerfInfoUtil.getLocalHome().create(this.m_monitorInfo.getMonitorTypeId(), this.m_monitorInfo.getMonitorId(), collectorId, mpInfo.getItemCode(), mpInfo.getDeviceIndex(), mpInfo.getDeviceName(), mpInfo.getDisplayName());
        ArrayList<CollectorItemInfo> itemList = new ArrayList<CollectorItemInfo>();
        CollectorItemInfo itemInfo = new CollectorItemInfo(mpInfo.getCollectorId(), mpInfo.getItemCode(), mpInfo.getDisplayName());
        itemList.add(itemInfo);
        ModifySchedule scheduler = new ModifySchedule();
        boolean result = scheduler.addSchedule(this.m_monitorInfo.getMonitorId(), collectorId, this.m_monitorInfo.getFacilityId(), this.m_monitorInfo.getRunInterval(), itemList, this.m_monitorInfo.getValid());
        return result;
    }

    public boolean addMonitorInfo(String user) throws CreateException, FinderException, SchedulerException, ParseException, NamingException {
        try {
            Timestamp now = new Timestamp(new Date().getTime());
            this.m_monitor = MonitorInfoUtil.getLocalHome().create(this.m_monitorInfo.getMonitorTypeId(), this.m_monitorInfo.getMonitorId(), Integer.valueOf(this.m_monitorInfo.getMonitorType()), this.m_monitorInfo.getDescription(), this.m_monitorInfo.getFacilityId(), Integer.valueOf(this.m_monitorInfo.getRunInterval()), Integer.valueOf(this.m_monitorInfo.getTimeout()), this.m_monitorInfo.getCalendarId(), Integer.valueOf(this.m_monitorInfo.getMonitorBlock()), this.m_monitorInfo.getDeterminationId(), Integer.valueOf(this.m_monitorInfo.getFailurePriority()), this.m_monitorInfo.getApplication(), this.m_monitorInfo.getFailureMessageId(), this.m_monitorInfo.getFailureMessage(), this.m_monitorInfo.getNotifyGroupId(), now, now, user, user);
            if (this.m_monitorInfo.getNotifyId() != null) {
                NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
                nc.addNotifyRelation(this.m_monitorInfo.getNotifyId());
            }
            return this.addJudgementInfo() && this.addCheckInfo();
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "addMonitorInfo()");
            e.printStackTrace();
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "addMonitorInfo()");
            e.printStackTrace();
            throw e;
        }
    }

    public String getJndiName() {
        return "MonitorPerfRunManagement";
    }

    private void outputLog(Exception e, String method) {
        AplLogger apllog = new AplLogger("PERF", "perf");
        Object[] args = new String[]{this.m_monitorInfo.getMonitorTypeId(), this.m_monitorInfo.getMonitorId()};
        apllog.put("SYS", "007", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

