/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.util;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParameterUtil {
    protected static Log m_log = LogFactory.getLog(ParameterUtil.class);
    public static final int TYPE_JOB = 1;
    public static final int TYPE_MONITOR = 2;

    public static String getParameterValue(String paramId, OutputNotifyGroupInfo info) {
        String value = null;
        if (info == null) {
            return value;
        }
        if (paramId.equals("FACILITY_ID")) {
            value = info.getFacilityId();
        } else if (paramId.equals("PLUGIN_ID")) {
            value = info.getPluginId();
        } else if (paramId.equals("MONITOR_ID")) {
            value = info.getMonitorId();
        } else if (paramId.equals("MESSAGE_ID")) {
            value = info.getMessageId();
        } else if (paramId.equals("APPLICATION")) {
            value = info.getApplication();
        } else if (paramId.equals("PRIORITY")) {
            value = String.valueOf(info.getPriority());
        } else if (paramId.equals("MESSAGE")) {
            value = info.getMessage();
        } else if (paramId.equals("ORG_MESSAGE")) {
            value = info.getMessageOrg();
        }
        return value;
    }

    public static String getJobParameterValue(String sessionId, String paramId) throws FinderException, NamingException {
        String ret = null;
        if (paramId.equals("START_DATE")) {
            JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
            ret = DateFormat.getDateTimeInstance().format(session.getSchedule_date());
        } else if (paramId.equals("SESSION_ID")) {
            ret = sessionId;
        } else if (paramId.equals("TRIGGER_TYPE")) {
            JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
            ret = JobTriggerTypeConstant.typeToString(session.getTrigger_type());
        } else if (paramId.equals("TRIGGER_INFO")) {
            JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
            ret = session.getTrigger_info();
        }
        return ret;
    }

    public static String getSessionParameterValue(String sessionId, String paramId) {
        String value;
        block3: {
            Iterator itr;
            value = null;
            Collection collection = null;
            try {
                collection = JobParamInfoUtil.getLocalHome().findBySessionIdAndParamId(sessionId, paramId);
            }
            catch (FinderException e) {
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (collection == null || collection.size() <= 0 || !(itr = collection.iterator()).hasNext()) break block3;
            JobParamInfoLocal param = (JobParamInfoLocal)itr.next();
            value = param.getValue();
        }
        return value;
    }

    public static String replaceSessionParameterValue(String sessionId, String source) {
        String result = source;
        StringReader fr = new StringReader(source);
        StreamTokenizer tokenizer = new StreamTokenizer(fr);
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(32, 32);
        tokenizer.eolIsSignificant(true);
        int token = -1;
        try {
            while ((token = tokenizer.nextToken()) != -1) {
                if (token != -3) continue;
                String tmpSval = tokenizer.sval;
                int start = tmpSval.indexOf("${");
                int end = tmpSval.indexOf("}");
                if (start == -1 || end == -1) continue;
                String paramId = tmpSval.substring(start + 2, end);
                String value = ParameterUtil.getSessionParameterValue(sessionId, paramId);
                if (value == null) {
                    return null;
                }
                result = result.replaceAll("\\$\\{" + paramId + "\\}", value);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        int start = result.indexOf("${");
        int end = result.indexOf("}");
        if (start != -1 && end != -1) {
            return null;
        }
        return result;
    }

    public static int checkFunctionType(String paramId) {
        int ret = 0;
        if (paramId.equals("SESSION_ID") || paramId.equals("TRIGGER_TYPE") || paramId.equals("TRIGGER_INFO")) {
            ret = 1;
        } else if (paramId.equals("FACILITY_ID") || paramId.equals("PLUGIN_ID") || paramId.equals("MONITOR_ID") || paramId.equals("MESSAGE_ID") || paramId.equals("APPLICATION") || paramId.equals("PRIORITY") || paramId.equals("MESSAGE") || paramId.equals("ORG_MESSAGE")) {
            ret = 2;
        }
        return ret;
    }
}

