/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.ejb.mdb;

import com.clustercontrol.bean.NotifyTypeConstant;
import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyInfoContext;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;
import com.clustercontrol.notify.factory.SelectNotify;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifyControlBean
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = -4596765959814807231L;
    protected static Log m_log = LogFactory.getLog(NotifyControlBean.class);
    private static HashMap<String, NotifyInfo> m_notifyMap = null;
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    public void onMessage(Message message) {
        block18: {
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("onMessage start : Message Driven Bean got message " + message));
            }
            if (m_notifyMap == null) {
                try {
                    m_notifyMap = new SelectNotify().getNotifyMap();
                }
                catch (Exception e) {
                    m_log.error((Object)("onMessage(): \u901a\u77e5\u60c5\u5831\u30ad\u30e3\u30c3\u30b7\u30e5\u53d6\u5f97\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 " + e.getMessage()));
                }
            }
            if (message instanceof ObjectMessage) {
                ObjectMessage msg = (ObjectMessage)message;
                try {
                    Serializable objMsg = msg.getObject();
                    if (objMsg instanceof OutputNotifyGroupInfo) {
                        String notifyGroupId;
                        OutputNotifyGroupInfo info = (OutputNotifyGroupInfo)objMsg;
                        if (info != null && (notifyGroupId = info.getNotifyGroupId()) != null && !"".equals(notifyGroupId.trim())) {
                            this.notifyAction(info);
                        }
                        break block18;
                    }
                    if (objMsg instanceof NotifyInfoContext) {
                        try {
                            NotifyInfoContext notifyInfoContext = (NotifyInfoContext)objMsg;
                            if (0 == notifyInfoContext.getType() || 1 == notifyInfoContext.getType()) {
                                m_notifyMap.put(notifyInfoContext.getNotifyId(), notifyInfoContext.getNotifyInfo());
                            } else if (2 == notifyInfoContext.getType()) {
                                m_notifyMap.remove(notifyInfoContext.getNotifyId());
                            }
                            break block18;
                        }
                        catch (Exception e) {
                            m_log.error((Object)("onMessage(): \u901a\u77e5\u60c5\u5831\u30ad\u30e3\u30c3\u30b7\u30e5\u66f4\u65b0\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + e.getMessage()));
                        }
                        break block18;
                    }
                    m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + objMsg.toString()));
                }
                catch (JMSException e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
                }
                catch (EJBException e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
                }
                catch (Exception e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
                }
            }
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("onMessage end   : Message Driven Bean got message " + message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void notifyAction(OutputNotifyGroupInfo info) {
        block26: {
            now = new Date();
            outputDate = new Timestamp(now.getTime());
            info.setOutputDate(outputDate);
            notifyGroupId = info.getNotifyGroupId();
            try {
                ct = NotifyRelationInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
                if (ct == null || ct.size() <= 0) break block26;
lbl8:
                // 13 sources

                block25: for (NotifyRelationInfoLocal notifyRelation : ct) {
                    notifyId = notifyRelation.getNotifyId();
                    notifyInfo = NotifyControlBean.m_notifyMap.get(notifyId);
                    NotifyControlBean.m_log.debug((Object)("notifyAction() notifyGroupId : " + notifyGroupId + ", notifyId : " + notifyId));
                    notifyType = notifyRelation.getNotifyType();
                    notifyFlg = notifyInfo.getValidFlg();
                    queue = null;
                    message = "";
                    try {
                        if (notifyFlg != 1) continue;
                        switch (notifyType) {
                            case 1: {
                                message = NotifyTypeConstant.STRING_EVENT;
                                queue = new SendQueue("queue/clustercontrolNotifyEvent");
                                info.setNotifyId(notifyId);
                                queue.put((Serializable)info);
                                ** break;
                            }
                            case 0: {
                                message = NotifyTypeConstant.STRING_STATUS;
                                queue = new SendQueue("queue/clustercontrolNotifyStatus");
                                info.setNotifyId(notifyId);
                                queue.put((Serializable)info);
                                ** break;
                            }
                            case 2: {
                                message = NotifyTypeConstant.STRING_MAIL;
                                queue = new SendQueue("queue/clustercontrolNotifyMail");
                                info.setNotifyId(notifyId);
                                queue.put((Serializable)info);
                                ** break;
                            }
                            case 3: {
                                message = NotifyTypeConstant.STRING_JOB;
                                queue = new SendQueue("queue/clustercontrolNotifyJob");
                                info.setNotifyId(notifyId);
                                queue.put((Serializable)info);
                                ** break;
                            }
                            case 4: {
                                message = NotifyTypeConstant.STRING_LOG_ESCALATE;
                                queue = new SendQueue("queue/clustercontrolNotifyLogEscalation");
                                info.setNotifyId(notifyId);
                                queue.put((Serializable)info);
                                ** break;
                            }
                            ** default:
lbl50:
                            // 1 sources

                            continue block25;
                        }
                    }
                    catch (JMSException e) {
                        NotifyControlBean.m_log.warn((Object)("notifyAction() : notifyId = " + notifyId + ", " + message + " : " + e.getMessage()));
                    }
                    catch (NamingException e) {
                        NotifyControlBean.m_log.warn((Object)("notifyAction() : notifyId = " + notifyId + ", " + message + " : " + e.getMessage()));
                    }
                    finally {
                        if (queue == null) continue;
                        try {
                            queue.terminate();
                        }
                        catch (JMSException e) {
                            NotifyControlBean.m_log.debug((Object)e, (Throwable)e);
                        }
                    }
                }
            }
            catch (FinderException e) {
                NotifyControlBean.m_log.warn((Object)("notifyAction() : notifyGroupId = " + notifyGroupId + " not found."), (Throwable)e);
            }
            catch (NamingException e) {
                NotifyControlBean.m_log.warn((Object)("notifyAction() : catch NamingExcepiton" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

