/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.poller.job;

import com.clustercontrol.poller.PollerManager;
import com.clustercontrol.poller.PollingController;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class PollingJob
implements Job {
    private static Log m_log = LogFactory.getLog(PollingJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        m_log.debug((Object)"execute start : ");
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String jndiName = dataMap.getString("jndiName");
        String pollerGroup = dataMap.getString("pollerGroup");
        String pollerName = dataMap.getString("pollerName");
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup(jndiName);
            PollerManager manager = (PollerManager)PortableRemoteObject.narrow((Object)obj, PollerManager.class);
            PollingController poller = manager.getPoller(pollerGroup, pollerName);
            poller.run();
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        m_log.debug((Object)("execute end   : " + jndiName));
    }
}

