/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.poller;

import com.clustercontrol.poller.cfg.PollerConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollingControllerConfig {
    private static Log m_log = LogFactory.getLog(PollingControllerConfig.class);
    private Object modifyLock = new Object();
    private PollerConfig m_pollerConfig;
    private boolean m_indexCheckFlg;
    private ConcurrentHashMap<String, IntervalAndValues> m_targetValueMap;
    private ConcurrentHashMap<PollingTargetAndCollectMethod, IntervalAndNextTime> m_scheduleMap;
    private ConcurrentHashMap<Integer, Long> m_refreshTableTimes;
    private int m_minPollingInterval = -1;

    public PollingControllerConfig(PollerConfig config, boolean indexCheckFlg) {
        this.m_pollerConfig = config;
        this.m_targetValueMap = new ConcurrentHashMap();
        this.m_scheduleMap = new ConcurrentHashMap();
        this.m_refreshTableTimes = new ConcurrentHashMap();
        this.m_indexCheckFlg = indexCheckFlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPollingTargets(String collectorName, int interval, HashMap<String, List<String>> pollingMap) {
        Object object = this.modifyLock;
        synchronized (object) {
            this.m_targetValueMap.put(collectorName, new IntervalAndValues(interval, pollingMap));
        }
        this.rescheduling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePollingTargets(String collectorName) {
        Object object = this.modifyLock;
        synchronized (object) {
            this.m_targetValueMap.remove(collectorName);
        }
        return this.rescheduling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePollingAllTargets() {
        Object object = this.modifyLock;
        synchronized (object) {
            this.m_targetValueMap.clear();
        }
        return this.rescheduling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rescheduling() {
        Object object = this.modifyLock;
        synchronized (object) {
            boolean modifyFlg = false;
            this.m_scheduleMap.clear();
            this.m_minPollingInterval = Integer.MAX_VALUE;
            for (String collectorName : this.m_targetValueMap.keySet()) {
                m_log.debug((Object)("collectorName : " + collectorName));
                IntervalAndValues setting = this.m_targetValueMap.get(collectorName);
                HashMap<String, List<String>> pollingMap = setting.getPoliingMap();
                int interval = setting.getPollingInterval();
                if (this.m_minPollingInterval > interval) {
                    m_log.debug((Object)("Set Min Polling Intreval : " + interval));
                    this.m_minPollingInterval = interval;
                    modifyFlg = true;
                }
                for (String protocol : pollingMap.keySet()) {
                    m_log.debug((Object)("protocol : " + protocol));
                    for (String pollingTarget : pollingMap.get(protocol)) {
                        if (pollingTarget == null || pollingTarget.equals("")) continue;
                        PollingTargetAndCollectMethod target = new PollingTargetAndCollectMethod(pollingTarget, protocol);
                        if (this.m_scheduleMap.get(target) != null) {
                            if (this.m_scheduleMap.get(target).getPollingInterval() <= interval) continue;
                            this.m_scheduleMap.get(target).setPollingInterval(interval);
                            continue;
                        }
                        this.m_scheduleMap.put(target, new IntervalAndNextTime(interval));
                        m_log.debug((Object)("m_scheduleMap put PollingTarget : " + target.getPollingTarget() + ", Protocol : " + target.getProtocol()));
                    }
                }
                if (this.m_refreshTableTimes.get(interval) != null) continue;
                this.m_refreshTableTimes.put(interval, 0L);
            }
            if (this.m_minPollingInterval == Integer.MAX_VALUE) {
                this.m_minPollingInterval = -1;
                modifyFlg = true;
            }
            return modifyFlg;
        }
    }

    public HashMap<String, List<String>> getCurrentTargetMap(long currentTime) {
        HashMap<String, List<String>> currentTarget = new HashMap<String, List<String>>();
        m_log.debug((Object)"getCurrentTargetMap start");
        Iterator itr = this.m_scheduleMap.keySet().iterator();
        m_log.debug((Object)("m_scheduleMap size : " + this.m_scheduleMap.keySet().size()));
        while (itr.hasNext()) {
            PollingTargetAndCollectMethod target = (PollingTargetAndCollectMethod)itr.next();
            if (this.m_scheduleMap.get(target) == null) continue;
            long nextPollingTime = this.m_scheduleMap.get(target).getNextPollingTime();
            int interval = this.m_scheduleMap.get(target).getPollingInterval();
            if (nextPollingTime > currentTime) continue;
            String pollingTarget = target.getPollingTarget();
            String protocol = target.getProtocol();
            List<String> targetList = currentTarget.get(protocol);
            if (targetList == null) {
                targetList = new ArrayList<String>();
                targetList.add(pollingTarget);
                currentTarget.put(protocol, targetList);
            } else {
                targetList.add(pollingTarget);
            }
            long intervalMillis = (long)interval * 1000L;
            long count = (currentTime - nextPollingTime) / intervalMillis;
            this.m_scheduleMap.get(target).setNextPollingTime(nextPollingTime += intervalMillis * (count + 1L));
        }
        return currentTarget;
    }

    public List<Integer> getCurrentRefreshIntervals(long currentTime) {
        m_log.debug((Object)("current time : " + currentTime));
        ArrayList<Integer> currentTarget = new ArrayList<Integer>();
        Iterator itr = this.m_refreshTableTimes.keySet().iterator();
        while (itr.hasNext()) {
            int interval = (Integer)itr.next();
            long nextTime = this.m_refreshTableTimes.get(interval);
            if (nextTime > currentTime) continue;
            currentTarget.add(interval);
            long intervalMillis = (long)interval * 1000L;
            long count = (currentTime - nextTime) / intervalMillis;
            m_log.debug((Object)("put nexttime : " + interval + ", " + (nextTime += intervalMillis * (count + 1L))));
            this.m_refreshTableTimes.put(interval, nextTime);
        }
        return currentTarget;
    }

    public Set<String> getCollectorNames() {
        return this.m_targetValueMap.keySet();
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig config) {
        this.m_pollerConfig = config;
    }

    public int getMinPollingInterval() {
        return this.m_minPollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsCollectorName(String collectorName) {
        Object object = this.modifyLock;
        synchronized (object) {
            return this.m_targetValueMap.containsKey(collectorName);
        }
    }

    public boolean isIndexCheckFlg() {
        return this.m_indexCheckFlg;
    }

    public String getDebugInfo() {
        String debugStr = "";
        for (String collectorName : this.m_targetValueMap.keySet()) {
            HashMap<String, List<String>> pollingMap = this.m_targetValueMap.get(collectorName).getPoliingMap();
            int interval = this.m_targetValueMap.get(collectorName).getPollingInterval();
            String str = "\t" + collectorName + "  interval : " + interval + "\n";
            for (String collectMethod : pollingMap.keySet()) {
                for (String pollingTarget : pollingMap.get(collectMethod)) {
                    IntervalAndNextTime ian = this.m_scheduleMap.get(new PollingTargetAndCollectMethod(pollingTarget, collectMethod));
                    str = str + "\t" + collectMethod + "\t" + pollingTarget + "\t" + ian.getPollingInterval() + "\t" + new Date(ian.getNextPollingTime()) + "\n";
                }
            }
            debugStr = debugStr + str;
        }
        return debugStr;
    }

    private class PollingTargetAndCollectMethod {
        private String m_protocol;
        private String m_pollingTarget;

        public PollingTargetAndCollectMethod(String pollingTarget, String protocol) {
            this.m_pollingTarget = pollingTarget;
            this.m_protocol = protocol;
        }

        public String getProtocol() {
            return this.m_protocol;
        }

        public void setProtocol(String protocol) {
            this.m_protocol = protocol;
        }

        public String getPollingTarget() {
            return this.m_pollingTarget;
        }

        public void setPollingTarget(String pollingTarget) {
            this.m_pollingTarget = pollingTarget;
        }

        public boolean equals(Object other) {
            if (other instanceof PollingTargetAndCollectMethod) {
                PollingTargetAndCollectMethod info = (PollingTargetAndCollectMethod)other;
                if (this.m_pollingTarget == null && this.m_protocol == null) {
                    if (info.m_pollingTarget == null && info.m_protocol == null) {
                        return true;
                    }
                } else if (this.m_pollingTarget == null && this.m_protocol != null) {
                    if (info.m_pollingTarget == null && this.m_protocol.equals(info.m_protocol)) {
                        return true;
                    }
                } else if (this.m_pollingTarget != null && this.m_protocol == null) {
                    if (this.m_pollingTarget.equals(info.m_pollingTarget) && info.m_protocol == null) {
                        return true;
                    }
                } else if (this.m_pollingTarget.equals(info.m_pollingTarget)) {
                    return this.m_protocol.equals(info.m_protocol);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.m_pollingTarget != null ? this.m_pollingTarget.hashCode() : 0);
            result = 37 * result + (this.m_protocol != null ? this.m_protocol.hashCode() : 0);
            return result;
        }
    }

    private class IntervalAndNextTime {
        private int m_pollingInterval;
        private long m_nextPollingTime;

        public IntervalAndNextTime(int pollingInterval) {
            this.m_pollingInterval = pollingInterval;
            this.m_nextPollingTime = 0L;
        }

        public int getPollingInterval() {
            return this.m_pollingInterval;
        }

        public void setPollingInterval(int interval) {
            this.m_pollingInterval = interval;
        }

        public long getNextPollingTime() {
            return this.m_nextPollingTime;
        }

        public void setNextPollingTime(long nextPollingTime) {
            this.m_nextPollingTime = nextPollingTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntervalAndValues {
        private int m_pollingInterval;
        private HashMap<String, List<String>> m_pollingMap;

        public IntervalAndValues(int pollingInterval, HashMap<String, List<String>> pollingMap) {
            this.m_pollingInterval = pollingInterval;
            this.m_pollingMap = pollingMap;
        }

        public int getPollingInterval() {
            return this.m_pollingInterval;
        }

        public HashMap<String, List<String>> getPoliingMap() {
            return this.m_pollingMap;
        }
    }
}

