/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.factory;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandExecutor {
    protected String m_resultMsg = "";
    protected String m_errMsg = "";
    protected int m_exitValue;
    private static Log log = LogFactory.getLog(CommandExecutor.class);

    public static void main(String[] args) {
        new CommandExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exec(String[] cmd, String inputData, String endValueStr) {
        Process process;
        Runtime runtime = Runtime.getRuntime();
        try {
            if (log.isDebugEnabled()) {
                for (int i = 0; i < cmd.length; ++i) {
                    log.info((Object)("Command Execute:" + cmd[i]));
                }
            }
            process = runtime.exec(cmd);
        }
        catch (IOException e) {
            log.error((Object)e);
            this.m_errMsg = e.getMessage();
            return false;
        }
        try {
            BufferedReader inbr = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader erbr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            BufferedWriter outbw = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            StringBuffer inbuff = new StringBuffer();
            StringBuffer errbuff = new StringBuffer();
            if (inputData != null) {
                try {
                    outbw.write(inputData);
                    outbw.flush();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            while (true) {
                try {
                    this.m_exitValue = process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e2) {
                        break;
                    }
                    this.readBuff(inbr, inbuff);
                    this.readBuff(erbr, errbuff);
                    int idx = inbuff.lastIndexOf(endValueStr);
                    if (idx == -1) continue;
                    try {
                        outbw.write("\n");
                        outbw.flush();
                    }
                    catch (IOException e1) {}
                    continue;
                }
                break;
            }
            this.readBuff(inbr, inbuff);
            this.readBuff(erbr, errbuff);
            this.m_resultMsg = inbuff.toString();
            this.m_errMsg = errbuff.toString();
            boolean bl = true;
            return bl;
        }
        finally {
            process.destroy();
        }
    }

    public void readBuff(BufferedReader br, StringBuffer result) {
        char[] buff = new char[256];
        try {
            int length;
            while (br.ready() && (length = br.read(buff)) != -1) {
                result.append(buff, 0, length);
                log.debug((Object)new String(buff, 0, length));
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public String getErrMsg() {
        return this.m_errMsg;
    }

    public int getExitValue() {
        return this.m_exitValue;
    }

    public String getResultMsg() {
        return this.m_resultMsg;
    }
}

