/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ServerAddress
implements Serializable {
    private static final long serialVersionUID = -7206359745950445445L;
    public String address;
    public int port;
    public boolean enableTcpNoDelay = false;
    public int timeout = 60000;
    public int maxPoolSize;
    private transient int hashCode;

    public ServerAddress(String address, int port, boolean enableTcpNoDelay, int timeout, int maxPoolSize) {
        this.address = address;
        this.port = port;
        this.enableTcpNoDelay = enableTcpNoDelay;
        this.hashCode = address.hashCode() + port;
        if (enableTcpNoDelay) {
            ++this.hashCode;
        }
        if (timeout >= 0) {
            this.timeout = timeout;
        }
        this.hashCode = 7 * this.hashCode + timeout;
        this.maxPoolSize = maxPoolSize;
        this.hashCode = 11 * this.hashCode + maxPoolSize;
    }

    public String toString() {
        return "ServerAddress[" + this.address + ":" + this.port + (this.enableTcpNoDelay ? ", enableTcpNoDelay" : ", NO enableTcpNoDelay") + " timeout " + this.timeout + " ms" + ", maxPoolSize=" + this.maxPoolSize + "]";
    }

    public boolean equals(Object obj) {
        try {
            ServerAddress o = (ServerAddress)obj;
            if (this.port != o.port) {
                return false;
            }
            if (!this.address.equals(o.address)) {
                return false;
            }
            if (this.enableTcpNoDelay != o.enableTcpNoDelay) {
                return false;
            }
            if (this.timeout != o.timeout) {
                return false;
            }
            return this.maxPoolSize == o.maxPoolSize;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.hashCode = this.address.hashCode() + this.port;
        if (this.enableTcpNoDelay) {
            ++this.hashCode;
        }
        this.hashCode = 7 * this.hashCode + this.timeout;
    }
}

