/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.util;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoUtil;
import com.clustercontrol.notify.util.InhibitAction;
import com.clustercontrol.notify.util.SendMail;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendSyslog
extends InhibitAction {
    protected static Log m_log = LogFactory.getLog(SendSyslog.class);
    private static int LIMIT_SIZE = 1024;
    private OutputNotifyGroupInfo m_outputInfo;

    public synchronized void sendSyslog(OutputNotifyGroupInfo outputInfo) throws FinderException, NamingException {
        block18: {
            this.m_outputInfo = outputInfo;
            NotifyInfoLocal notifyInfo = NotifyInfoUtil.getLocalHome().findByPrimaryKey(this.m_outputInfo.getNotifyId());
            NotifyLogEscalateInfoLocal logEscalateInfo = NotifyLogEscalateInfoUtil.getLocalHome().findByPrimaryKey(new NotifyLogEscalateInfoPK(this.m_outputInfo.getNotifyId(), this.m_outputInfo.getPriority()));
            if (logEscalateInfo == null) {
                m_log.debug((Object)"onMessage() : \u51fa\u529b\u3059\u308b\u91cd\u8981\u5ea6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                return;
            }
            try {
                if (logEscalateInfo.getEscalateFlg() != 1) break block18;
                boolean isRun = false;
                if (logEscalateInfo.getEscalateInhibitionFlg() == 1 && notifyInfo.getInhibitionFlg() != 0) {
                    try {
                        boolean isInhibit = super.isInhibit(this.m_outputInfo, notifyInfo);
                        if (!isInhibit) {
                            isRun = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        m_log.error((Object)("sendSyslog() : " + e.getMessage()), (Throwable)e);
                    }
                    catch (RemoteException e) {
                        m_log.error((Object)("sendSyslog() : " + e.getMessage()), (Throwable)e);
                    }
                    catch (CreateException e) {
                        m_log.error((Object)("sendSyslog() : " + e.getMessage()), (Throwable)e);
                    }
                } else {
                    isRun = true;
                }
                if (isRun) {
                    String facilityId = null;
                    InetAddress ipAddress = null;
                    FacilityLocal facility = null;
                    RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
                    if (logEscalateInfo.getEscalateFacilityFlg() == 1) {
                        facilityId = logEscalateInfo.getEscalateFacility();
                        ArrayList facilityIdList = repository.getExecTargetFacilityIdList(facilityId);
                        Iterator itr = facilityIdList.iterator();
                        while (itr.hasNext()) {
                            facility = FacilityUtil.getLocalHome().findByFacilityId((String)itr.next());
                            ipAddress = this.getInetAdress(facility);
                            this.send(logEscalateInfo, ipAddress);
                        }
                    } else {
                        facilityId = this.m_outputInfo.getFacilityId();
                        ArrayList facilityIdList = repository.getExecTargetFacilityIdList(facilityId);
                        Iterator itr = facilityIdList.iterator();
                        while (itr.hasNext()) {
                            facility = FacilityUtil.getLocalHome().findByFacilityId((String)itr.next());
                            ipAddress = this.getInetAdress(facility);
                            this.send(logEscalateInfo, ipAddress);
                        }
                    }
                }
            }
            catch (CreateException e) {
                m_log.error((Object)("sendSyslog() : " + e.getMessage()), (Throwable)e);
            }
            catch (SocketException e) {
                m_log.error((Object)("sendSyslog() : " + e.getMessage()), (Throwable)e);
            }
            catch (UnknownHostException e) {
                m_log.error((Object)("sendSyslog() : " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                m_log.error((Object)("sendSyslog() : " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private InetAddress getInetAdress(FacilityLocal facility) throws UnknownHostException {
        InetAddress ret = null;
        int version = 4;
        version = facility.getIpProtocolNumber() != null ? facility.getIpProtocolNumber() : 4;
        ret = version == 4 ? InetAddress.getByName(facility.getIpNetworkNumber()) : InetAddress.getByName(facility.getIpNetworkNumberV6());
        return ret;
    }

    private void send(NotifyLogEscalateInfoLocal logEscalateInfo, InetAddress ipAddress) throws FinderException, NamingException, IOException {
        byte[] buf = new byte[LIMIT_SIZE];
        int port = logEscalateInfo.getEscalatePort();
        String message = logEscalateInfo.getEscalateMessage();
        int syslogPriority = logEscalateInfo.getSyslogPriority() + logEscalateInfo.getSyslogFacility();
        DatagramSocket soc = new DatagramSocket();
        DatagramPacket sendPacket = null;
        message = SendMail.substitution(message, this.m_outputInfo);
        String sendMessage = "<" + syslogPriority + ">" + message;
        if (sendMessage.getBytes().length > LIMIT_SIZE) {
            buf = sendMessage.getBytes();
            sendMessage = new String(buf, 0, LIMIT_SIZE);
        }
        buf = sendMessage.getBytes();
        int len = buf.length;
        sendPacket = new DatagramPacket(buf, len, ipAddress, port);
        soc.send(sendPacket);
        soc.close();
    }
}

