/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.collection.BatchingCollectionInitializer;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.SubselectOneToManyLoader;
import org.hibernate.loader.entity.CollectionElementLoader;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Update;
import org.hibernate.util.ArrayHelper;

public class OneToManyPersister
extends AbstractCollectionPersister {
    private final boolean cascadeDeleteEnabled;
    private final boolean keyIsNullable;
    private final boolean keyIsUpdateable;

    protected boolean isRowDeleteEnabled() {
        return this.keyIsUpdateable && this.keyIsNullable;
    }

    protected boolean isRowInsertEnabled() {
        return this.keyIsUpdateable;
    }

    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public OneToManyPersister(org.hibernate.mapping.Collection collection, CacheConcurrencyStrategy cache, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        super(collection, cache, cfg, factory);
        this.cascadeDeleteEnabled = collection.getKey().isCascadeDeleteEnabled() && factory.getDialect().supportsCascadeDelete();
        this.keyIsNullable = collection.getKey().isNullable();
        this.keyIsUpdateable = collection.getKey().isUpdateable();
    }

    protected String generateDeleteString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null").setPrimaryKeyColumnNames(this.keyColumnNames);
        if (this.hasIndex && !this.indexContainsFormula) {
            update.addColumns(this.indexColumnNames, "null");
        }
        if (this.hasWhere) {
            update.setWhere(this.sqlWhereString);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("delete one-to-many " + this.getRole());
        }
        return update.toStatementString();
    }

    protected String generateInsertRowString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIndex && !this.indexContainsFormula) {
            update.addColumns(this.indexColumnNames);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("create one-to-many row " + this.getRole());
        }
        return update.setPrimaryKeyColumnNames(this.elementColumnNames).toStatementString();
    }

    protected String generateUpdateRowString() {
        return null;
    }

    protected String generateDeleteRowString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null");
        if (this.hasIndex && !this.indexContainsFormula) {
            update.addColumns(this.indexColumnNames, "null");
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("delete one-to-many row " + this.getRole());
        }
        String[] rowSelectColumnNames = ArrayHelper.join(this.keyColumnNames, this.elementColumnNames);
        return update.setPrimaryKeyColumnNames(rowSelectColumnNames).toStatementString();
    }

    public boolean consumesEntityAlias() {
        return true;
    }

    public boolean consumesCollectionAlias() {
        return true;
    }

    public boolean isOneToMany() {
        return true;
    }

    public boolean isManyToMany() {
        return false;
    }

    protected int doUpdateRows(Serializable id, PersistentCollection collection, SessionImplementor session) throws HibernateException {
        try {
            int count = 0;
            if (this.isRowDeleteEnabled()) {
                boolean useBatch = true;
                PreparedStatement st = null;
                try {
                    int i = 0;
                    Iterator entries = collection.entries(this);
                    int offset = 1;
                    Expectation expectation = Expectations.NONE;
                    while (entries.hasNext()) {
                        Object entry = entries.next();
                        if (collection.needsUpdating(entry, i, this.elementType)) {
                            if (st == null) {
                                String sql = this.getSQLDeleteRowString();
                                if (this.isDeleteCallable()) {
                                    expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.getDeleteCheckStyle());
                                    useBatch = expectation.canBeBatched();
                                    st = useBatch ? session.getBatcher().prepareBatchCallableStatement(sql) : session.getBatcher().prepareCallableStatement(sql);
                                    offset += expectation.prepare(st);
                                } else {
                                    st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteRowString());
                                }
                            }
                            int loc = this.writeKey(st, id, offset, session);
                            this.writeElementToWhere(st, collection.getSnapshotElement(entry, i), loc, session);
                            if (useBatch) {
                                session.getBatcher().addToBatch(expectation);
                            } else {
                                expectation.verifyOutcome(st.executeUpdate(), st, -1);
                            }
                            ++count;
                        }
                        ++i;
                    }
                }
                catch (SQLException sqle) {
                    if (useBatch) {
                        session.getBatcher().abortBatch(sqle);
                    }
                    throw sqle;
                }
                finally {
                    if (!useBatch) {
                        session.getBatcher().closeStatement(st);
                    }
                }
            }
            if (this.isRowInsertEnabled()) {
                Expectation expectation = Expectations.appropriateExpectation((ExecuteUpdateResultCheckStyle)this.getInsertCheckStyle());
                boolean callable = this.isInsertCallable();
                boolean useBatch = expectation.canBeBatched();
                String sql = this.getSQLInsertRowString();
                PreparedStatement st = null;
                try {
                    int i = 0;
                    Iterator entries = collection.entries(this);
                    while (entries.hasNext()) {
                        Object entry = entries.next();
                        int offset = 1;
                        if (collection.needsUpdating(entry, i, this.elementType)) {
                            if (useBatch) {
                                if (st == null) {
                                    st = callable ? session.getBatcher().prepareBatchCallableStatement(sql) : session.getBatcher().prepareBatchStatement(sql);
                                }
                            } else {
                                st = callable ? session.getBatcher().prepareCallableStatement(sql) : session.getBatcher().prepareStatement(sql);
                            }
                            int loc = this.writeKey(st, id, offset += expectation.prepare(st), session);
                            if (this.hasIndex && !this.indexContainsFormula) {
                                loc = this.writeIndexToWhere(st, collection.getIndex(entry, i, this), loc, session);
                            }
                            this.writeElementToWhere(st, collection.getElement(entry), loc, session);
                            if (useBatch) {
                                session.getBatcher().addToBatch(expectation);
                            } else {
                                expectation.verifyOutcome(st.executeUpdate(), st, -1);
                            }
                            ++count;
                        }
                        ++i;
                    }
                }
                catch (SQLException sqle) {
                    if (useBatch) {
                        session.getBatcher().abortBatch(sqle);
                    }
                    throw sqle;
                }
                finally {
                    if (!useBatch) {
                        session.getBatcher().closeStatement(st);
                    }
                }
            }
            return count;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert((SQLExceptionConverter)this.getSQLExceptionConverter(), (SQLException)sqle, (String)("could not update collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory())), (String)this.getSQLInsertRowString());
        }
    }

    public String selectFragment(Joinable rhs, String rhsAlias, String lhsAlias, String entitySuffix, String collectionSuffix, boolean includeCollectionColumns) {
        StringBuffer buf = new StringBuffer();
        if (includeCollectionColumns) {
            buf.append(this.selectFragment(lhsAlias, collectionSuffix)).append(", ");
        }
        OuterJoinLoadable ojl = (OuterJoinLoadable)this.getElementPersister();
        return buf.append(ojl.selectFragment(lhsAlias, entitySuffix)).toString();
    }

    protected CollectionInitializer createCollectionInitializer(Map enabledFilters) throws MappingException {
        return BatchingCollectionInitializer.createBatchingOneToManyInitializer((QueryableCollection)this, (int)this.batchSize, (SessionFactoryImplementor)this.getFactory(), (Map)enabledFilters);
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return ((Joinable)this.getElementPersister()).fromJoinFragment(alias, innerJoin, includeSubclasses);
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return ((Joinable)this.getElementPersister()).whereJoinFragment(alias, innerJoin, includeSubclasses);
    }

    public String getTableName() {
        return ((Joinable)this.getElementPersister()).getTableName();
    }

    public String filterFragment(String alias) throws MappingException {
        String result = super.filterFragment(alias);
        if (this.getElementPersister() instanceof Joinable) {
            result = result + ((Joinable)this.getElementPersister()).oneToManyFilterFragment(alias);
        }
        return result;
    }

    protected CollectionInitializer createSubselectInitializer(SubselectFetch subselect, SessionImplementor session) {
        return new SubselectOneToManyLoader((QueryableCollection)this, subselect.toSubselectString(this.getCollectionType().getLHSPropertyName()), (Collection)subselect.getResult(), subselect.getQueryParameters(), subselect.getNamedParameterLocMap(), session.getFactory(), session.getEnabledFilters());
    }

    public Object getElementByIndex(Serializable key, Object index, SessionImplementor session, Object owner) {
        return new CollectionElementLoader((QueryableCollection)this, this.getFactory(), session.getEnabledFilters()).loadElement(session, (Object)key, this.incrementIndexByBase(index));
    }
}

