/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.ejb.mdb;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.notify.util.SendMail;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.mail.MessagingException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifyMailBean
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = -2723077721653645273L;
    protected static Log m_log = LogFactory.getLog(NotifyMailBean.class);
    private static SendMail m_sender = new SendMail();
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    public void onMessage(Message message) {
        m_log.debug((Object)("Message Driven Bean got message " + message));
        if (message instanceof ObjectMessage) {
            ObjectMessage msg = (ObjectMessage)message;
            try {
                Serializable objMsg = msg.getObject();
                if (objMsg instanceof OutputNotifyGroupInfo) {
                    OutputNotifyGroupInfo outputInfo = (OutputNotifyGroupInfo)objMsg;
                    m_sender.sendMail(outputInfo);
                } else {
                    m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + objMsg.toString()));
                }
            }
            catch (JMSException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
            }
            catch (EJBException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
            }
            catch (RemoteException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
            }
            catch (NamingException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
            }
            catch (MessagingException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
            }
            catch (CreateException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
            }
            catch (FinderException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

