#!/bin/sh

#Copyright (C) 2006 - 2008 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み 
export EXEC_PATH=${0%/*}

. ${EXEC_PATH}/install.cfg

echo ""
																				
echo "###################################################################"
echo "###                                                             ###"
echo "### Operation Management Software Hinemos Agent                 ###"
echo "###                                        Installer Ver 2.4.2  ###"
echo "###                                                             ###"
echo "###  Copyright (C) 2006-2008 NTT DATA Corporation.              ###"
echo "###################################################################"


EXEC_USER=`/usr/bin/whoami`
HOSTS_FILE=/etc/hosts
HOST=`hostname`

# Net-SNMPをインストールするかを確認するフラグ
# 0:SNMPがインストールされていない
# 1:SNMPがインストールされている
SNMP_INSTALL_FLG=0

# check for incorrect user

if [ $EXEC_USER != "root" ]; then
		echo ""
		echo "ERROR  Set up Hinemos Agent at a root user."
		echo ""
		exit 1
fi


##
## hostsファイルのチェック(syslog-ng.confで自身のIPアドレスを動的に取得するため)
##
hosts_check() {
	echo ""
	echo "${HOSTS_FILE} is checked before the agent installation."

	#ホスト名にIPアドレスの重複がないかチェックを行う
	check_flg=`grep ${HOST} ${HOSTS_FILE} | grep -v "^\s*\#" | awk '{print $1}' | wc -l`

	if [ ${check_flg} != 1 ]; then
		echo "NG"
		echo "WARNING: Correct IP address of the ${HOST} is not being set to the ${HOSTS_FILE} or two or more IP addresses are set."
 	    echo "Please check the ${HOSTS_FILE} and change the setting to fit the correct IP address which has one to one relation between the IP address and ${HOST}. "
		echo ""

		while [ 1 ]; 
		do
			echo "Do you continue this installation?（Y/N）"
			read ANS
			case ${ANS} in
				y|Y)
					break
					;;
				n|N)
					echo "The installation is canceled."
					echo ""
					exit 1
					;;
				*)
					;;
			esac
		done
	else
		echo "OK"
	fi
}


##
## rpmのチェック
##
rpm_check(){

	# パッケージチェッカー
	package_checker() {
			rpm -qi $1 >/dev/null 2>&1
			check_flg=$?
	}

	echo ""
	echo "Necessary packages are checked before the agent installation."


	## インストールマニュアルに記述されているパッケージの有無をチェックする
	##
	for p_name in ${RPM_MANUAL[@]}
	do
		package_checker ${p_name}
		if [ ${check_flg} = 1 ]; then
			echo ${p_name} >> ${EXEC_PATH}/tmp.txt
		fi
	done

	# 結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
		echo ""
		echo "NG"
		echo "Warning：The following packages are insufficient to install the Hinemos agent."
		cat ${EXEC_PATH}/tmp.txt
		echo ""
		echo "Please refer to the installation manual for details."
		echo ""
		rm -f ${EXEC_PATH}/tmp.txt
		exit 1
	else
		rm -f ${EXEC_PATH}/tmp.txt
	fi


	## Net-SNMPパッケージがインストールされているかをチェックする
	##
	for p_name in "${RPM_SNMP[@]}"
	do
	   	rpm -q "${p_name}" >/dev/null 
	   	if [ "${?}" -eq "1" ] ; then
	   		echo ${p_name} >> ${EXEC_PATH}/tmp.txt
	   	fi
	done

	# 結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
		echo ""
		echo "NG"
		echo "Warning：NetSNMP installation is needed to use the following functions of Hinemos."
		echo ""
		echo "Unavailable Functions of Hinemos"
		echo "	・Resource monitoring"
		echo "	・Process monitoring"
		echo "	・SNMP monitoring"
		echo "	・Performance management"
		echo ""
		echo "Please install the following packages."
		cat ${EXEC_PATH}/tmp.txt
		echo ""
		echo "Please refer to the installation manual for details concerning the version, etc."
		echo ""
		rm -rf ${EXEC_PATH}/tmp.txt
		
		while [ 1 ] ;
		do
			echo "Do you continue this installation?（Y/N）"
			read ANS
			case ${ANS} in
				y|Y)
					SNMP_INSTALL_FLG=0
					break
					;;
				n|N)
					echo "The installation is canceled."
					exit 1
					;;
				*)
					;;
			esac
		done
	else
		CURRENT_SNMP_VERSION=`rpm -q net-snmp`
		CURRENT_SNMP_LIBS_VERSION=`rpm -q net-snmp-libs | uniq`
		SNMP_CHECK_FLG=0

		#net-snmpのバージョンチェック
		echo ""
		if [ "${CURRENT_SNMP_VERSION}" != "${SNMP_VERSION}" ] ; then
        	echo "There is a possibility that the installed net-snmp package is different from the recommended version."
        	echo "Present version ： ${CURRENT_SNMP_VERSION}"
        	echo "Recommended version ： ${SNMP_VERSION} or later"
        	echo ""
        	SNMP_CHECK_FLG=1
		fi
		
		#net-snmp-libsのバージョンチェック
		if [ "${CURRENT_SNMP_LIBS_VERSION}" != "${SNMP_LIBS_VERSION}" ] ; then
        	echo "There is a possibility that the installed net-snmp-libs package is different from the recommended version."
        	echo "Present version ： ${CURRENT_SNMP_LIBS_VERSION}"
        	echo "Recommended version ： ${SNMP_LIBS_VERSION} or later"
        	echo ""
        	SNMP_CHECK_FLG=1
		fi
	
		if [ "${SNMP_CHECK_FLG}" = "0" ] ; then 
			echo "OK"
		else
			echo "There is no problem when  recommended version or later is installed."
        	echo "Please refer to the installation manual for details."
        	echo ""
        	echo "Before instaling recommended version, please cancel the agent's installation."
        	echo "Afterwards, please execute the agent installation again."
        	while [ 1 ] ;
			do
				echo ""
				echo "Do you continue installation?（Y/N）"
				read ANS
				case ${ANS} in
					y|Y)
						break
						;;
					n|N)
						echo "The installation is canceled."
						exit 1
						;;
					*)
						;;
				esac
			done
		fi
		
		echo ""
		rm -rf ${EXEC_PATH}/tmp.txt
		SNMP_INSTALL_FLG=1
	fi

	## 一括制御機能で使用しているコマンドのパッケージの有無をチェックする
	##
	for p_name in ${RPM_CRUN[@]}
	do
		package_checker ${p_name}
		if [ ${check_flg} = 1 ]; then
			echo ${p_name} >> ${EXEC_PATH}/tmp.txt
		fi
	done

	# 結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
		echo ""
		echo "Warning：It is necessary to install the following packages to use all of the functions provided by the "Collective control function"".
		cat ${EXEC_PATH}/tmp.txt
		echo ""
		echo "Please refer to the installation manual for details."
		echo ""
		sleep 2
		rm -rf ${EXEC_PATH}/tmp.txt
	fi

	rm -rf ${EXEC_PATH}/tmp.txt
}


##
## インストールディレクトリの確認
##
installdir_check() {
	echo "Installation directory ${HINEMOS_AGENT_HOME} is confirmed."
	if [ -d ${HINEMOS_AGENT_HOME} ]; then
		echo "Warning : Installation directory ${HINEMOS_AGENT_HOME} already exists."
	  	echo "Please change the directory name or delete it."
		echo ""
	   	echo "The installation is canceled."
		exit 1
	else
	 	echo "Installation directory ${HINEMOS_AGENT_HOME} doesn't exist. It is created."
		echo "mkdir -p ${HINEMOS_AGENT_HOME}"
	 	echo ""
  	fi
}


##
## Net-SNMPの設定
##
snmp_setting() {
	if [ "${SNMP_INSTALL_FLG}" -eq "1" ] ; then
		echo "Net-SNMP is set up."
		# snmpd.confのバックアップを取得
		mkdir -p ${HINEMOS_AGENT_HOME}/var/backup
		cp -p /etc/snmp/snmpd.conf ${HINEMOS_AGENT_HOME}/var/backup/snmpd.conf_bk
		# 設定を追加
	  	echo "view	systemview	included	.1.3.6.1 " >> /etc/snmp/snmpd.conf
		echo "/etc/init.d/snmpd restart"
		/etc/init.d/snmpd restart
	else
		echo "Warning : Because Net-SNMP is not installed, this set up was canceled."
		echo "Please set it up referring to the installation manual."
		sleep 3
	fi
}


##
## syslog-ngのインストール
##
syslogng_install() {
	HINEMOS_VERSION=`cat ${HINEMOS_AGENT_HOME}/_version`
	#syslog-ngインストール
	echo "Syslog-ng is installed."
	
	#インストールチェック
	rpm -q syslog-ng > /dev/null
	
	if [ "${?}" -eq "1" ] ; then		
		# rpmインストール
		rpm -ivh --force ${SYSLOG_NG_RPM}
		
		# syslog-ng.conf の編集
		LOCAL_ADDR=`grep ${HOST} ${HOSTS_FILE} | grep -v "^\s*\#" | gawk '{print $1}'`
		echo "#add for Hinemos Agent ${HINEMOS_VERSION}" >> /etc/syslog-ng/syslog-ng.conf
		echo "filter f_hinemos_log { facility(user);  };" >> /etc/syslog-ng/syslog-ng.conf
		echo "source s_netudp { udp(ip(${LOCAL_ADDR}) port(514)); };" >>/etc/syslog-ng/syslog-ng.conf
		echo "log { source(s_netudp); filter(f_hinemos_log); destination(d_hinemos);};" >>/etc/syslog-ng/syslog-ng.conf
		echo "destination d_hinemos { tcp(\"${IPADDR}\" port(514));};" >> /etc/syslog-ng/syslog-ng.conf
		echo "log { source(s_local);filter(f_mesg);destination(d_hinemos);};" >> /etc/syslog-ng/syslog-ng.conf
		
		# syslogの停止、syslog-ng の起動
		/etc/init.d/syslog stop
		/etc/init.d/syslog-ng start
		/sbin/chkconfig --level 2345 syslog off
		/sbin/chkconfig --level 2345 syslog-ng on
	else
		echo "Warning : Syslog-ng has already been installed."
		echo "Please change the setting referring to the installation manual."
		sleep 2
	fi
}


##
## syslog-ngのアンインストール
##
syslogng_uninstall() {
	while [ 1 ] ;
	do
		echo ""
		echo "Syslog-ng is uninstalled. Is it all right?(Y/N)"
		read ANS_SYS
		case ${ANS_SYS} in
			y|Y)
  				#syslog-ngアンインストール
				/etc/init.d/syslog-ng stop
				/etc/init.d/syslog start
    			/sbin/chkconfig --level 2345 syslog-ng off
				/sbin/chkconfig --level 2345 syslog on
				rpm -e syslog-ng libol
				echo "Syslog-ng was uninstalled."
				echo ""
				echo "The backup file of syslog-ng.conf was created."
				echo "	/etc/syslog-ng/syslog-ng.conf.rpmsave"	
				echo "Please confirm it after completing uninstallation."
				break
				;;
			n|N)
				echo "Syslog-ng was not uninstalled."
				break
				;;
			*)
				;;
		esac
	done
}

##
## Net-SNMPの設定を戻す
##
snmp_setting_remove() {
	# バックアップファイルが存在する場合のみ実行
	if [ -f ${HINEMOS_AGENT_HOME}/var/backup/snmpd.conf_bk ] ; then
		echo "The setting of net-snmp is changed."
		echo "Do you want to return the net-snmp setting to the setting of Hinemos agent pre-installation.？(Y/N)"
		while [ 1 ];
		do
			read ANS
			case ${ANS} in
				y|Y)
					/etc/init.d/snmpd stop
					cp /etc/snmp/snmpd.conf /etc/snmp/snmpd.conf_bk
					cp ${HINEMOS_AGENT_HOME}/var/backup/snmpd.conf_bk /etc/snmp/snmpd.conf
					/etc/init.d/snmpd start
					echo "The setting was returned."
					break
					;;
				n|N)
					echo "The setting of net-snmp was not changed."
					break
					;;
				*)
					;;
			esac
		done
	fi
}




##
## インストーラ本編(始)
##
while [ 1 ];
do
	echo "Hinemos Agent's"
	echo "	 1) Installation"
	echo "	 2) Uninstallation"
	echo "	 9) Quit this installer"
	echo ""
	echo -n "===> "

	read CHOSEN_NUMBER

	case ${CHOSEN_NUMBER} in
		##
		## インストール
		##
		1)
			echo ""
			echo "Setup Hinemos agent."
			echo ""
			echo ""

			while [ 1 ];
			do
				echo "Installation will be start.  Is it all right? (Y/N)"
				read ANS
				case ${ANS} in
					y|Y)
						# インストール準備部分		  
						# hostsファイルのチェック
						hosts_check

						# パッケージのチェック
						rpm_check

						# インストールディレクトリの確認
						installdir_check

						while [ ! "${IPADDR}" ] ;
						do
							echo -n "Please input the manager's IP Address --:"
							read IPADDR
							echo "Is it ${IPADDRESS}? (Y/N default:Y)"
							read IP_ANS
							IP_ANS=${IP_ANS:-Y}
							echo ""
							case ${IP_ANS} in
								y|Y)
									break
									;;
								n|N)
									;;
								*)
									echo "Please input Y or N."
									;;
							esac
						done

						# コピー開始
						echo "Start copying required files."
						cp -pr $EXEC_PATH/hinemos_agent /opt
						
						#install.cfgの内容を反映してhinemos_agent.cfgをコピー
						REPLACE_PATH=`echo ${JRE_NAME} | sed 's/\//\\\\\//g'`
						sed "s/%%jre_name%%/${REPLACE_PATH}/" ${EXEC_PATH}/hinemos_agent.cfg > ${HINEMOS_AGENT_HOME}/bin/hinemos_agent.cfg						

						echo "Copying required files was completed."
						echo ""

						# JREのインストール
						echo "Installing  JRE"
						sleep 2
						echo ""
						cp ${EXEC_PATH}/${JRE_VERSION}-linux-i586.bin ${HINEMOS_AGENT_HOME}
						CURRENT_DIR=`pwd`
						cd ${HINEMOS_AGENT_HOME}
						${HINEMOS_AGENT_HOME}/${JRE_VERSION}-linux-i586.bin
						rm ${HINEMOS_AGENT_HOME}/${JRE_VERSION}-linux-i586.bin
						cd ${CURRENT_DIR}
						echo ""

						# ジョブエージェントへのマネージャIPアドレスの反映
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties
						echo "### Hinemos Manager ###" >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties
						echo java.naming.provider.url=jnp://$IPADDR:1099 >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties

						# ジョブエージェントのログ出力先設定
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties
						echo "### log directory setting ###" >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties
						echo log4j.appender.file.File=${HINEMOS_AGENT_HOME}/var/log/agents.log >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties		

						# ログ転送エージェントへのマネージャIPアドレスの反映
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						echo "### Hinemos Manager ###" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						echo java.naming.provider.url=jnp://$IPADDR:1099 >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						
						# ログへのホスト名の反映のための設定
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "### syslog host setting ###" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo log4j.appender.syslog.SyslogHost=$HOST >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						
						# ログ出力先設定
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "### log directory setting ###" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo log4j.appender.file.File=${HINEMOS_AGENT_HOME}/var/log/logagent.log >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
			  
						#Net-SNMPのセットアップ
						snmp_setting
						echo ""

						#syslog-ngのセットアップ
						syslogng_install
						echo ""

						echo "The Hinemos agent was installed."
						echo ""
						break
						;;
					n|N)
						echo "Installation is canceled and return to the menu."
						echo ""
						sleep 1
						break
						;;
					*)
						;;
				esac
			done
			;;
		##
		## アンインストール
		##
		2)	  
			echo "The Hinemos agent will be uninstalled. Is it all right (Y/N)?"
			read ANS
			case ${ANS} in
				y|Y)
					#プロセス終了の確認
					ps axu | grep /agent/ | grep -v grep | grep hinemos > /dev/null
	  				RET1=$?  

	  				ps axu | grep /log_agent/ | grep -v grep | grep hinemos > /dev/null 
	  				RET2=$?  
				
					if [ ${RET1} -eq 0 -o ${RET2} -eq 0 ]; then
						echo "Hinemos agent is running. "
						echo "Please execute uninstallation after stopping Hinemos agent."
						echo "The Hinemos agent's uninstallation is canceled."
						exit 1
			  		fi
				
				
					#syslog-ngのアンインストール
					rpm -q syslog-ng > /dev/null
					if [ "${?}" = "0" ] ; then
						syslogng_uninstall
					fi
					echo ""

					#net-snmpの設定変更
					snmp_setting_remove
					echo ""

					#Hinemosエージェントファイルの削除
					echo "${HINEMOS_AGENT_HOME} is deleted."
					if [ -d ${HINEMOS_AGENT_HOME} ] ; then
						rm -fr ${HINEMOS_AGENT_HOME}
						echo "${HINEMOS_AGENT_HOME} was deleted."
					else
						echo "${HINEMOS_AGENT_HOME} doesn't exist."
					fi
					;;
				*)
					;;
			esac
			echo ""
			;;
		##
		## 終了
		##
		9)  
			echo "Hinemos agent installer is finished."
			exit 0
			;;
		*)
			echo ""
			;;
  	esac
done
##
## インストーラ本編(終)
##
