/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.util.Date;
import java.util.StringTokenizer;
import org.jboss.util.Classes;
import org.xml.sax.Attributes;

public final class Util {
    public static final char HYPHEN_MINUS = '-';
    public static final char FULL_STOP = '.';
    public static final char COLLON = ':';
    public static final char LOW_LINE = '_';
    public static final char MIDDLE_DOT = '\u00b7';
    public static final char GREEK_ANO_TELEIA = '\u0387';
    public static final char ARABIC_END_OF_AYAH = '\u06dd';
    public static final char ARABIC_START_OF_RUB_EL_HIZB = '\u06de';

    public static String xmlNameToClassName(String name, boolean ignoreLowLine) {
        return XMLNameToJavaIdentifierConverter.PARSER.parse(XMLNameToJavaIdentifierConverter.CLASS_NAME, name, ignoreLowLine);
    }

    public static String xmlNameToFieldName(String name, boolean ignoreLowLine) {
        return XMLNameToJavaIdentifierConverter.PARSER.parse(XMLNameToJavaIdentifierConverter.FIELD_NAME, name, ignoreLowLine);
    }

    public static String xmlNameToGetMethodName(String name, boolean ignoreLowLine) {
        return "get" + Util.xmlNameToClassName(name, ignoreLowLine);
    }

    public static String xmlNameToSetMethodName(String name, boolean ignoreLowLine) {
        return "set" + Util.xmlNameToClassName(name, ignoreLowLine);
    }

    public static String xmlNameToConstantName(String name) {
        return XMLNameToJavaIdentifierConverter.PARSER.parse(XMLNameToJavaIdentifierConverter.CONSTANT_NAME, name, true);
    }

    public static String xmlNamespaceToJavaPackage(String namespace) {
        if (namespace.length() == 0) {
            return namespace;
        }
        char[] src = namespace.toLowerCase().toCharArray();
        char[] dst = new char[namespace.length()];
        int srcInd = 0;
        while (src[srcInd++] != ':') {
        }
        while (src[srcInd] == '/') {
            ++srcInd;
        }
        if (src[srcInd] == 'w' && src[srcInd + 1] == 'w' && src[srcInd + 2] == 'w') {
            srcInd += 4;
        }
        int domainStart = srcInd;
        while (srcInd < src.length && src[srcInd] != '/') {
            ++srcInd;
        }
        int dstInd = 0;
        int start = srcInd - 1;
        int end = srcInd;
        while (true) {
            if (start == domainStart) {
                System.arraycopy(src, start, dst, dstInd, end - start);
                dstInd += end - start;
                break;
            }
            if (src[start] == '.') {
                System.arraycopy(src, start + 1, dst, dstInd, end - start - 1);
                dst[(dstInd += end - start) - 1] = 46;
                end = start;
            }
            --start;
        }
        while (srcInd < src.length) {
            char c;
            if ((c = src[srcInd++]) == '/') {
                if (srcInd >= src.length) continue;
                dst = Util.append(dst, dstInd++, '.');
                if (Character.isJavaIdentifierStart(src[srcInd])) continue;
                dst = Util.append(dst, dstInd++, '_');
                continue;
            }
            if (c == '.') break;
            dst = Util.append(dst, dstInd++, Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        return String.valueOf(dst, 0, dstInd);
    }

    public static String xmlNameToClassName(String namespaceUri, String localName, boolean ignoreLowLine) {
        return namespaceUri == null || namespaceUri.length() == 0 ? Util.xmlNameToClassName(localName, ignoreLowLine) : Util.xmlNamespaceToJavaPackage(namespaceUri) + '.' + Util.xmlNameToClassName(localName, ignoreLowLine);
    }

    public static boolean isAttributeType(Class type) {
        return Classes.isPrimitive(type) || type == String.class || type == Date.class;
    }

    public static String getSchemaLocation(Attributes attrs, String nsUri) {
        String location = null;
        String schemaLocation = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (schemaLocation != null) {
            StringTokenizer tokenizer = new StringTokenizer(schemaLocation, " \t\n\r");
            String ns = tokenizer.nextToken();
            while (ns != null) {
                location = tokenizer.nextToken();
                if (ns.equals(nsUri)) break;
                ns = tokenizer.nextToken();
            }
        }
        return location;
    }

    private static char[] append(char[] buf, int index, char ch) {
        if (index >= buf.length) {
            char[] tmp = buf;
            buf = new char[index + 4];
            System.arraycopy(tmp, 0, buf, 0, tmp.length);
        }
        buf[index] = ch;
        return buf;
    }

    static interface XMLNameToJavaIdentifierConverter {
        public static final byte IGNORE = 0;
        public static final byte APPEND = 1;
        public static final byte APPEND_WITH_LOW_LINE = 2;
        public static final byte APPEND_UPPER_CASED = 3;
        public static final byte APPEND_UPPER_CASED_WITH_LOW_LINE = 4;
        public static final XMLNameToJavaIdentifierConverter CLASS_NAME = new XMLNameToJavaIdentifierConverter(){

            public char firstCharacter(char ch, String str, int secondCharIndex) {
                return Character.toUpperCase(ch);
            }

            public byte commandForNext(char prev, char next, boolean ignoreLowLine) {
                int command = Character.isDigit(next) ? 1 : (next == '_' ? (ignoreLowLine ? 0 : 1) : (Character.isJavaIdentifierPart(next) ? (Character.isJavaIdentifierPart(prev) && !Character.isDigit(prev) ? (prev == '_' ? 3 : 1) : 3) : 0));
                return (byte)command;
            }
        };
        public static final XMLNameToJavaIdentifierConverter FIELD_NAME = new XMLNameToJavaIdentifierConverter(){

            public char firstCharacter(char ch, String str, int secondCharIndex) {
                return str.length() > secondCharIndex && Character.isJavaIdentifierPart(str.charAt(secondCharIndex)) && Character.isUpperCase(str.charAt(secondCharIndex)) ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
            }

            public byte commandForNext(char prev, char next, boolean ignoreLowLine) {
                return CLASS_NAME.commandForNext(prev, next, ignoreLowLine);
            }
        };
        public static final XMLNameToJavaIdentifierConverter CONSTANT_NAME = new XMLNameToJavaIdentifierConverter(){

            public char firstCharacter(char ch, String str, int secondCharIndex) {
                return Character.toUpperCase(ch);
            }

            public byte commandForNext(char prev, char next, boolean ignoreLowLine) {
                int command = Character.isDigit(next) ? (Character.isDigit(prev) ? 1 : 4) : (Character.isJavaIdentifierPart(next) ? (Character.isDigit(prev) ? 4 : (Character.isJavaIdentifierPart(prev) ? (Character.isUpperCase(next) ? (Character.isUpperCase(prev) ? 3 : 2) : 3) : 4)) : 0);
                return (byte)command;
            }
        };

        public byte commandForNext(char var1, char var2, boolean var3);

        public char firstCharacter(char var1, String var2, int var3);

        public static final class PARSER {
            static String parse(XMLNameToJavaIdentifierConverter converter, String xmlName, boolean ignoreLowLine) {
                if (xmlName == null || xmlName.length() == 0) {
                    throw new IllegalArgumentException("Bad XML name: " + xmlName);
                }
                char c = xmlName.charAt(0);
                int i = 1;
                if (!Character.isJavaIdentifierStart(c) || c == '_' && ignoreLowLine) {
                    while (i < xmlName.length() && (!Character.isJavaIdentifierStart(c = xmlName.charAt(i++)) || c == '_' && ignoreLowLine)) {
                    }
                    if (i == xmlName.length()) {
                        throw new IllegalArgumentException("XML name contains no valid character to start Java identifier: " + xmlName);
                    }
                }
                char[] buf = new char[xmlName.length() - i + 1];
                buf[0] = converter.firstCharacter(c, xmlName, i);
                int bufInd = 1;
                block8: while (i < xmlName.length()) {
                    char prev = c;
                    c = xmlName.charAt(i++);
                    byte command = converter.commandForNext(prev, c, ignoreLowLine);
                    switch (command) {
                        case 0: {
                            continue block8;
                        }
                        case 1: {
                            buf = Util.append(buf, bufInd++, c);
                            continue block8;
                        }
                        case 2: {
                            buf = Util.append(buf, bufInd++, '_');
                            buf = Util.append(buf, bufInd++, c);
                            continue block8;
                        }
                        case 3: {
                            buf = Util.append(buf, bufInd++, Character.toUpperCase(c));
                            continue block8;
                        }
                        case 4: {
                            buf = Util.append(buf, bufInd++, '_');
                            buf = Util.append(buf, bufInd++, Character.toUpperCase(c));
                            continue block8;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected command: " + command);
                }
                return new String(buf, 0, bufInd);
            }
        }
    }
}

