/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.AgentThread;
import com.clustercontrol.agent.SendQueue;
import com.clustercontrol.agent.util.RunHistoryUtil;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSumThread
extends AgentThread {
    protected static final String ALGORITHM = "MD5";
    private static Log log = LogFactory.getLog(CheckSumThread.class);

    public CheckSumThread(RunInstructionInfo info, SendQueue sendQueue, Hashtable<String, Date> runHistory, Properties props) {
        super(info, sendQueue, runHistory, props);
    }

    @Override
    public void run() {
        log.debug((Object)"run start");
        Date startDate = new Date();
        RunHistoryUtil.addRunHistory(this.m_info, this.m_runHistory, startDate);
        RunResultInfo info = new RunResultInfo();
        info.setSessionId(this.m_info.getSessionId());
        info.setJobId(this.m_info.getJobId());
        info.setFacilityId(this.m_info.getFacilityId());
        info.setCommand(this.m_info.getCommand());
        info.setCommandType(this.m_info.getCommandType());
        info.setStatus(0);
        info.setTime(startDate);
        log.info((Object)("run SessionID=" + this.m_info.getSessionId() + ", JobID=" + this.m_info.getJobId()));
        this.m_sendQueue.put(info);
        if (this.m_info.getCommand().equals("getCheckSum")) {
            String checksum = this.getCheckSum(this.m_info.getFilePath());
            if (checksum != null) {
                info.setStatus(1);
                info.setCheckSum(checksum);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(0);
            } else {
                info.setStatus(2);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(-1);
            }
        } else if (this.m_info.getCommand().equals("checkCheckSum")) {
            String checksum = this.getCheckSum(this.m_info.getFilePath());
            if (checksum.equals(this.m_info.getCheckSum())) {
                info.setStatus(1);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(0);
            } else {
                info.setStatus(2);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(-1);
            }
        }
        this.m_sendQueue.put(info);
        this.sendDeleteHistory(info);
        log.debug((Object)"run end");
    }

    protected String getCheckSum(String path) {
        log.debug((Object)"get checksum start");
        String checksum = null;
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            FileInputStream inputStream = new FileInputStream(path);
            byte[] readData = new byte[256];
            while ((len = inputStream.read(readData)) >= 0) {
                md.update(readData, 0, len);
            }
            inputStream.close();
            checksum = this.changeString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        log.debug((Object)"get checksum end");
        return checksum;
    }

    protected String changeString(byte[] digest) {
        StringBuilder hashString = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            int d = digest[i];
            if (d < 0) {
                d += 256;
            }
            if (d < 16) {
                hashString.append("0");
            }
            hashString.append(Integer.toString(d, 16));
        }
        return hashString.toString();
    }
}

