/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jboss.util.Classes;
import org.jboss.util.Coercible;
import org.jboss.util.CoercionException;
import org.jboss.util.NotCoercibleException;
import org.jboss.util.coerce.CoercionHandler;
import org.jboss.util.stream.Streams;

public final class Objects {
    public static Constructor getCompatibleConstructor(Class type, Class valueType) {
        try {
            return type.getConstructor(valueType);
        }
        catch (Exception ignore) {
            Class<?>[] types = type.getClasses();
            for (int i = 0; i < types.length; ++i) {
                try {
                    return type.getConstructor(types[i]);
                }
                catch (Exception ignore2) {
                    continue;
                }
            }
            return null;
        }
    }

    public static Object coerce(Object value, Class type) throws CoercionException {
        Class<?> valueType = value.getClass();
        if (type.isAssignableFrom(valueType)) {
            return value;
        }
        if (value instanceof Coercible) {
            return ((Coercible)value).coerce(type);
        }
        if (CoercionHandler.isInstalled((Class)type)) {
            CoercionHandler handler = CoercionHandler.create((Class)type);
            return handler.coerce(value, type);
        }
        Constructor c = Objects.getCompatibleConstructor(type, valueType);
        if (c != null) {
            try {
                return c.newInstance(value);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof CoercionException) {
                    throw (CoercionException)t;
                }
                throw new CoercionException(t);
            }
            catch (Exception e) {
                if (e instanceof CoercionException) {
                    throw (CoercionException)e;
                }
                throw new CoercionException(e);
            }
        }
        if (type.isPrimitive()) {
            return Objects.coerce(value, Classes.getPrimitiveWrapper(type));
        }
        throw new NotCoercibleException(value);
    }

    public static Object coerce(Object[] values, Class type) throws CoercionException {
        if (!type.isArray()) {
            return Objects.coerce(values[0], type);
        }
        type = type.getComponentType();
        Object array = Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("values[" + i + "] is null");
            }
            Object coerced = Objects.coerce(values[i], type);
            Array.set(array, i, coerced);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object copy(Serializable obj) throws IOException, ClassNotFoundException {
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object copy = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            out.flush();
            byte[] data = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            in = new ObjectInputStream(bais);
            copy = in.readObject();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            Streams.close(in);
            throw throwable;
        }
        Streams.close((OutputStream)out);
        Streams.close((InputStream)in);
        return copy;
    }

    public static Object deref(Object obj) {
        if (obj != null && obj instanceof Reference) {
            Reference ref = (Reference)obj;
            return ref.get();
        }
        return obj;
    }

    public static boolean isArray(Object obj) {
        if (obj != null) {
            return obj.getClass().isArray();
        }
        return false;
    }

    public static Object[] toArray(Object obj) {
        Object array;
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        Class<?> type = obj.getClass();
        if (type.isArray()) {
            int length = Array.getLength(obj);
            Class<?> componentType = type.getComponentType();
            array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, Array.get(obj, i));
            }
        } else {
            array = Array.newInstance(type, 1);
            Array.set(array, 0, obj);
        }
        return (Object[])array;
    }

    public static boolean equals(Object[] a, Object[] b, boolean deep) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            Object x = a[i];
            Object y = b[i];
            if (x != y) {
                return false;
            }
            if (x == null || y == null) {
                return false;
            }
            if (deep) {
                if (x instanceof Object[] && y instanceof Object[]) {
                    if (!Objects.equals((Object[])x, (Object[])y, true)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (x.equals(y)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] a, Object[] b) {
        return Objects.equals(a, b, true);
    }
}

