/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.notification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.mx.notification.DefaultListenerRegistration;
import org.jboss.mx.notification.DefaultListenerRegistrationFactory;
import org.jboss.mx.notification.ListenerRegistration;
import org.jboss.mx.notification.ListenerRegistrationFactory;

public class ListenerRegistry {
    private HashMap listeners = new HashMap();
    private ListenerRegistrationFactory factory;

    public ListenerRegistry() {
        this(null);
    }

    public ListenerRegistry(ListenerRegistrationFactory factory) {
        this.factory = factory == null ? new DefaultListenerRegistrationFactory() : factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NotificationListener listener, NotificationFilter filter, Object handback) throws JMException {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            HashMap newListeners = (HashMap)this.listeners.clone();
            ArrayList registrations = (ArrayList)newListeners.get(listener);
            if (registrations == null) {
                registrations = new ArrayList();
                newListeners.put(listener, registrations);
            } else {
                registrations = (ArrayList)registrations.clone();
                newListeners.put(listener, registrations);
            }
            registrations.add(this.factory.create(listener, filter, handback));
            this.listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(NotificationListener listener) throws ListenerNotFoundException {
        ArrayList registrations = null;
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            if (!this.listeners.containsKey(listener)) {
                throw new ListenerNotFoundException("Listener not found " + listener);
            }
            HashMap newListeners = (HashMap)this.listeners.clone();
            registrations = (ArrayList)newListeners.remove(listener);
            this.listeners = newListeners;
        }
        Iterator iterator = registrations.iterator();
        while (iterator.hasNext()) {
            ListenerRegistration registration = (ListenerRegistration)iterator.next();
            registration.removed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        ListenerRegistration registration = null;
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            ArrayList registrations = (ArrayList)this.listeners.get(listener);
            if (registrations == null) {
                throw new ListenerNotFoundException("No registristrations for listener not listener=" + listener + " filter=" + filter + " handback=" + handback);
            }
            registration = new DefaultListenerRegistration(listener, filter, handback);
            int index = registrations.indexOf(registration);
            if (index == -1) {
                throw new ListenerNotFoundException("Listener not found listener=" + listener + " filter=" + filter + " handback=" + handback);
            }
            HashMap newListeners = (HashMap)this.listeners.clone();
            registrations = (ArrayList)registrations.clone();
            registration = (ListenerRegistration)registrations.remove(index);
            if (registrations.isEmpty()) {
                newListeners.remove(listener);
            } else {
                newListeners.put(listener, registrations);
            }
            this.listeners = newListeners;
        }
        registration.removed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            this.listeners.clear();
        }
    }

    public ListenerRegistrationIterator iterator() {
        return new ListenerRegistrationIterator();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public class ListenerRegistrationIterator
    implements Iterator {
        private Iterator listenerIterator;
        private Iterator registrationIterator;

        public ListenerRegistrationIterator() {
            this.listenerIterator = ListenerRegistry.this.listeners.values().iterator();
        }

        public boolean hasNext() {
            if (this.registrationIterator == null || !this.registrationIterator.hasNext()) {
                do {
                    if (!this.listenerIterator.hasNext()) {
                        return false;
                    }
                    this.registrationIterator = ((ArrayList)this.listenerIterator.next()).iterator();
                } while (!this.registrationIterator.hasNext());
            }
            return true;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Use hasNext before next");
            }
            return this.registrationIterator.next();
        }

        public ListenerRegistration nextRegistration() {
            return (ListenerRegistration)this.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }
}

