/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNode;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;
import org.jboss.monitor.services.ActiveAlarmTableMBean;
import org.jboss.mx.util.InstanceOfQueryExp;

public class MonitorLister
extends AbstractPluginWrapper {
    private static final long serialVersionUID = 1625760520837838058L;

    private TreeNode[] createMonitorSubNodes() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        InstanceOfQueryExp queryExp = null;
        queryExp = new InstanceOfQueryExp("org.jboss.monitor.JBossMonitorMBean");
        Set monitors = mbeanServer.queryNames(null, queryExp);
        Iterator mbeans = monitors.iterator();
        TreeNode[] result = null;
        ArrayList<SimpleTreeNode> monitorNodes = new ArrayList<SimpleTreeNode>();
        String[] emptySig = new String[]{};
        Object[] emptyArgs = new Object[]{};
        while (mbeans.hasNext()) {
            ObjectName mbean = (ObjectName)mbeans.next();
            String monitorName = (String)mbeanServer.getAttribute(mbean, "MonitorName");
            boolean alerted = (Boolean)mbeanServer.invoke(mbean, "alerted", emptyArgs, emptySig);
            String image = "images/service.gif";
            Object[] args = new Object[]{"monitors", monitorName, "-service.xml"};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            Object rtn = mbeanServer.invoke(new ObjectName("jboss.admin:service=DeploymentFileRepository"), "isStored", args, signature);
            boolean persisted = (Boolean)rtn;
            String url = "";
            url = persisted ? "manageThresholdMonitor.jsp?monitorObjectName=" + this.encode(mbean.toString()) : "/jmx-console/HtmlAdaptor?action=inspectMBean&name=" + this.encode(mbean.toString());
            monitorNodes.add(this.createTreeNode(monitorName, "Alert Monitor " + monitorName, image, url, null, null, null));
        }
        result = monitorNodes.size() == 0 ? null : monitorNodes.toArray(new TreeNode[monitorNodes.size()]);
        return result;
    }

    private TreeNode[] createSnapshotSubNodes() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        InstanceOfQueryExp queryExp = null;
        queryExp = new InstanceOfQueryExp("org.jboss.monitor.SnapshotRecordingMonitorMBean");
        Set monitors = mbeanServer.queryNames(null, queryExp);
        Iterator mbeans = monitors.iterator();
        TreeNode[] result = null;
        ArrayList<SimpleTreeNode> monitorNodes = new ArrayList<SimpleTreeNode>();
        while (mbeans.hasNext()) {
            ObjectName mbean = (ObjectName)mbeans.next();
            String monitorName = (String)mbeanServer.getAttribute(mbean, "MonitorName");
            String url = "manageSnapshot.jsp?monitorObjectName=" + this.encode(mbean.toString());
            String image = "images/service.gif";
            monitorNodes.add(this.createTreeNode(monitorName, "Snapshot " + monitorName, image, url, null, null, null));
        }
        result = monitorNodes.size() == 0 ? null : monitorNodes.toArray(new TreeNode[monitorNodes.size()]);
        return result;
    }

    private TreeNode[] createWebSubNodes() throws Exception {
        TreeNode[] webSubNodes = new TreeNode[]{this.createTreeNode("Connector scoreboard", "JBossWeb Connectors status scoreboard", "images/smallnet.gif", "status", null, null, null), this.createTreeNode("Full status", "JBossWeb complete status", "images/smallnet.gif", "status?full=true", null, null, null)};
        return webSubNodes;
    }

    protected TreeNode getTreeForResource(String profile, ManageableResource resource) {
        try {
            ArrayList<SimpleTreeNode> subNodeList = new ArrayList<SimpleTreeNode>();
            if (this.isActiveAlarmTablePresent()) {
                subNodeList.add(this.createTreeNode("Alarm Table", "Alarm Table", "images/smallnet.gif", "listActiveAlarmTable.jsp", null, null, null));
            }
            subNodeList.add(this.createTreeNode("Monitor Alerts", "Monitor Alerts", "images/smallnet.gif", "listMonitors.jsp", null, this.createMonitorSubNodes(), null));
            subNodeList.add(this.createTreeNode("Snapshots", "Snapshot Monitors", "images/smallnet.gif", null, null, this.createSnapshotSubNodes(), null));
            subNodeList.add(this.createTreeNode("Web Status", "JBossWeb Connectors status", "images/smallnet.gif", null, null, this.createWebSubNodes(), null));
            TreeNode[] subnodes = subNodeList.toArray(new TreeNode[subNodeList.size()]);
            return this.createTreeNode("Monitoring", "Monitoring", "images/smallnet.gif", null, null, subnodes, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isActiveAlarmTablePresent() {
        MBeanServer server = this.getMBeanServer();
        return server.isRegistered(ActiveAlarmTableMBean.OBJECT_NAME);
    }
}

