/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.message;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.encoding.Callback;
import org.jboss.axis.encoding.CallbackTarget;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.Deserializer;
import org.jboss.axis.message.SOAPElementAxisImpl;
import org.jboss.axis.message.SOAPFaultCodeBuilder;
import org.jboss.axis.message.SOAPFaultDetailsBuilder;
import org.jboss.axis.message.SOAPFaultImpl;
import org.jboss.axis.message.SOAPFaultReasonBuilder;
import org.jboss.axis.message.SOAPHandler;
import org.jboss.axis.message.SOAPHeaderElementAxisImpl;
import org.jboss.axis.soap.SOAP11Constants;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.ClassUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPFaultBuilder
extends SOAPHandler
implements Callback {
    boolean waiting = false;
    boolean passedEnd = false;
    protected SOAPFaultImpl element;
    protected DeserializationContext context;
    static HashMap fields_soap11 = new HashMap();
    static HashMap fields_soap12 = new HashMap();
    protected QName faultCode = null;
    protected QName[] faultSubCode = null;
    protected String faultString = null;
    protected String faultActor = null;
    protected Element[] faultDetails;
    protected String faultNode = null;
    protected SOAPFaultCodeBuilder code;
    protected Class faultClass = null;
    protected Object faultData = null;
    private static Logger log = Logger.getLogger((String)SOAPFaultBuilder.class.getName());
    private static HashMap TYPES;

    public SOAPFaultBuilder(SOAPFaultImpl element, DeserializationContext context) {
        this.element = element;
        this.context = context;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
        if (context.getMessageContext() != null) {
            soapConstants = context.getMessageContext().getSOAPConstants();
        }
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2002/12/soap-envelope", "encodingStyle") != null) {
            AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Fault"), null, null, null);
            throw new SAXException(fault);
        }
        super.startElement(namespace, localName, prefix, attributes, context);
    }

    void setFaultData(Object data) {
        this.faultData = data;
        if (this.waiting && this.passedEnd) {
            this.createFault();
        }
        this.waiting = false;
    }

    public void setFaultClass(Class faultClass) {
        this.faultClass = faultClass;
    }

    public void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        super.endElement(namespace, localName, context);
        if (!this.waiting) {
            this.createFault();
        } else {
            this.passedEnd = true;
        }
    }

    void setWaiting(boolean waiting) {
        this.waiting = waiting;
    }

    private void createFault() {
        SOAP11Constants soapConstants;
        AxisFault f = null;
        SOAPConstants sOAPConstants = soapConstants = this.context.getMessageContext() == null ? SOAPConstants.SOAP11_CONSTANTS : this.context.getMessageContext().getSOAPConstants();
        if (this.faultClass != null) {
            try {
                if (this.faultData != null) {
                    Constructor ctor;
                    if (this.faultData instanceof AxisFault) {
                        f = (AxisFault)this.faultData;
                    } else if (this.faultClass.isAssignableFrom(this.faultData.getClass())) {
                        f = AxisFault.makeFault((Exception)this.faultData);
                    }
                    if (f == null) {
                        try {
                            ctor = this.faultClass.getConstructor(this.faultData.getClass());
                            f = (AxisFault)ctor.newInstance(this.faultData);
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    if (f == null && Exception.class.isAssignableFrom(this.faultData.getClass())) {
                        try {
                            ctor = this.faultClass.getConstructor(String.class);
                            Exception custEx = (Exception)ctor.newInstance(((Exception)this.faultData).getMessage());
                            f = AxisFault.makeFault(custEx);
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                }
                if (AxisFault.class.isAssignableFrom(this.faultClass)) {
                    if (f == null) {
                        f = (AxisFault)this.faultClass.newInstance();
                    }
                    if (soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                        f.setFaultCode(this.code.getFaultCode());
                        SOAPFaultCodeBuilder c = this.code;
                        while ((c = c.getNext()) != null) {
                            f.addFaultSubCode(c.getFaultCode());
                        }
                    } else {
                        f.setFaultCode(this.faultCode);
                    }
                    f.setFaultString(this.faultString);
                    f.setFaultActor(this.faultActor);
                    f.setFaultNode(this.faultNode);
                    f.setFaultDetail(this.faultDetails);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.faultClass == null && this.faultString != null && this.faultString.indexOf(32) < 0) {
            try {
                Class argClass = ClassUtils.forName(this.faultString);
                Constructor<?>[] constructs = argClass.getConstructors();
                for (int x = 0; x < constructs.length; ++x) {
                    Constructor<?> construct = constructs[x];
                    Class<?>[] params = construct.getParameterTypes();
                    if (params.length != 1 || !params[0].isAssignableFrom(class$java$lang$String == null ? SOAPFaultBuilder.class$("java.lang.String") : class$java$lang$String)) continue;
                    Exception custEx = (Exception)construct.newInstance("");
                    f = AxisFault.makeFault(custEx);
                    break;
                }
            }
            catch (Exception e) {
                log.debug((Object)("Cannot create a fault instance of class:  " + this.faultString));
            }
        }
        if (f == null) {
            if (soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                this.faultCode = this.code.getFaultCode();
                if (this.code.getNext() != null) {
                    Vector<QName> v = new Vector<QName>();
                    SOAPFaultCodeBuilder c = this.code;
                    while ((c = c.getNext()) != null) {
                        v.add(c.getFaultCode());
                    }
                    this.faultSubCode = v.toArray(new QName[v.size()]);
                }
            }
            f = new AxisFault(this.faultCode, this.faultSubCode, this.faultString, this.faultActor, this.faultNode, this.faultDetails);
            try {
                Vector headers = this.element.getEnvelope().getHeaders();
                for (int i = 0; i < headers.size(); ++i) {
                    SOAPHeaderElementAxisImpl header = (SOAPHeaderElementAxisImpl)headers.elementAt(i);
                    f.addHeader(header);
                }
            }
            catch (AxisFault axisFault) {
                // empty catch block
            }
        }
        this.element.setFault(f);
    }

    public SOAPHandler onStartChild(String namespace, String name, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPHandler retHandler = null;
        SOAP11Constants soapConstants = context.getMessageContext() == null ? SOAPConstants.SOAP11_CONSTANTS : context.getMessageContext().getSOAPConstants();
        QName qName = null;
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
            qName = (QName)fields_soap12.get(name);
            if (qName == null) {
                QName thisQName = new QName(namespace, name);
                if (thisQName.equals(Constants.QNAME_FAULTCODE_SOAP12)) {
                    this.code = new SOAPFaultCodeBuilder();
                    return this.code;
                }
                if (thisQName.equals(Constants.QNAME_FAULTREASON_SOAP12)) {
                    return new SOAPFaultReasonBuilder(this);
                }
                if (thisQName.equals(Constants.QNAME_FAULTDETAIL_SOAP12)) {
                    return new SOAPFaultDetailsBuilder(this);
                }
            }
        } else {
            qName = (QName)fields_soap11.get(name);
            if (qName == null && name.equals("detail")) {
                return new SOAPFaultDetailsBuilder(this);
            }
        }
        if (qName != null) {
            Deserializer currentDeser = context.getDeserializerForType(qName);
            if (currentDeser != null) {
                currentDeser.registerValueTarget(new CallbackTarget(this, new QName(namespace, name)));
            }
            retHandler = (SOAPHandler)((Object)currentDeser);
        }
        return retHandler;
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) throws SAXException {
        SOAPElementAxisImpl el;
        List children;
        if ("detail".equals(localName) && (children = (el = context.getCurElement()).getChildren()) != null) {
            Element[] elements = new Element[children.size()];
            for (int i = 0; i < elements.length; ++i) {
                try {
                    elements[i] = ((SOAPElementAxisImpl)children.get(i)).getAsDOM();
                    continue;
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            this.faultDetails = elements;
        }
    }

    public void setValue(Object value, Object hint) {
        String local = ((QName)hint).getLocalPart();
        if (((QName)hint).getNamespaceURI().equals("http://www.w3.org/2002/12/soap-envelope")) {
            if (local.equals("Role")) {
                this.faultActor = (String)value;
            } else if (local.equals("Text")) {
                this.faultString = (String)value;
            } else if (local.equals("Node")) {
                this.faultNode = (String)value;
            }
        } else if (local.equals("faultcode")) {
            this.faultCode = (QName)value;
        } else if (local.equals("faultstring")) {
            this.faultString = (String)value;
        } else if (local.equals("faultactor")) {
            this.faultActor = (String)value;
        }
    }

    private Class ConvertWrapper(Class cls) {
        Class ret = (Class)TYPES.get(cls);
        if (ret != null) {
            return ret;
        }
        return cls;
    }

    static {
        fields_soap11.put("faultcode", Constants.XSD_QNAME);
        fields_soap11.put("faultstring", Constants.XSD_STRING);
        fields_soap11.put("faultactor", Constants.XSD_STRING);
        fields_soap11.put("detail", null);
        fields_soap12.put("Reason", null);
        fields_soap12.put("Role", Constants.XSD_STRING);
        fields_soap12.put("Node", Constants.XSD_STRING);
        fields_soap12.put("Detail", null);
        TYPES = new HashMap(7);
        TYPES.put(Integer.class, Integer.TYPE);
        TYPES.put(Float.class, Float.TYPE);
        TYPES.put(Boolean.class, Boolean.TYPE);
        TYPES.put(Double.class, Double.TYPE);
        TYPES.put(Byte.class, Byte.TYPE);
        TYPES.put(Short.class, Short.TYPE);
        TYPES.put(Long.class, Long.TYPE);
    }
}

