/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.rpc.server.ServiceLifecycle;
import org.jboss.axis.AxisFault;
import org.jboss.axis.AxisProperties;
import org.jboss.axis.ConfigurationException;
import org.jboss.axis.EngineConfiguration;
import org.jboss.axis.Handler;
import org.jboss.axis.InternalException;
import org.jboss.axis.MessageContext;
import org.jboss.axis.encoding.TypeMappingRegistry;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.axis.session.Session;
import org.jboss.axis.session.SimpleSession;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.axis.utils.cache.ClassCache;
import org.jboss.logging.Logger;

public abstract class AxisEngine
extends BasicHandler {
    private static Logger log = Logger.getLogger((String)AxisEngine.class.getName());
    public static final String PROP_XML_DECL = "sendXMLDeclaration";
    public static final String PROP_DEBUG_LEVEL = "debugLevel";
    public static final String PROP_DEBUG_FILE = "debugFile";
    public static final String PROP_DOMULTIREFS = "sendMultiRefs";
    public static final String PROP_PASSWORD = "adminPassword";
    public static final String PROP_SYNC_CONFIG = "syncConfiguration";
    public static final String PROP_SEND_XSI = "sendXsiTypes";
    public static final String PROP_ATTACHMENT_DIR = "attachments.Directory";
    public static final String PROP_ATTACHMENT_IMPLEMENTATION = "attachments.implementation";
    public static final String PROP_ATTACHMENT_CLEANUP = "attachment.DirectoryCleanUp";
    public static final String PROP_DEFAULT_CONFIG_CLASS = "axis.engineConfigClass";
    public static final String PROP_SOAP_VERSION = "defaultSOAPVersion";
    public static final String PROP_SOAP_ALLOWED_VERSION = "singleSOAPVersion";
    public static final String PROP_TWOD_ARRAY_ENCODING = "enable2DArrayEncoding";
    public static final String PROP_SEND_MINIMIZED_ELEMENTS = "axis.sendMinimizedElements";
    public static final String PROP_XML_ENCODING = "axis.xmlEncoding";
    public static final String DEFAULT_ATTACHMENT_IMPL = "org.jboss.axis.attachments.AttachmentsImpl";
    public static final String ENV_ATTACHMENT_DIR = "axis.attachments.Directory";
    public static final String ENV_SERVLET_REALPATH = "servlet.realpath";
    public static final String ENV_SERVLET_CONTEXT = "servletContext";
    private static final String DEFAULT_ADMIN_PASSWORD = "admin";
    protected EngineConfiguration config;
    protected boolean _hasSafePassword = false;
    protected boolean shouldSaveConfig = false;
    private Session session = new SimpleSession();
    private ArrayList actorURIs = new ArrayList();
    private static ThreadLocal currentMessageContext = new ThreadLocal();
    private static final String[] BOOLEAN_OPTIONS = new String[]{"sendMultiRefs", "sendXsiTypes", "sendXMLDeclaration", "axis.sendMinimizedElements"};

    public static void setCurrentMessageContext(MessageContext mc) {
        currentMessageContext.set(mc);
    }

    public static MessageContext getCurrentMessageContext() {
        return (MessageContext)currentMessageContext.get();
    }

    public AxisEngine(EngineConfiguration config) {
        this.config = config;
        this.init();
    }

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: AxisEngine::init");
        }
        try {
            this.config.configureEngine(this);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
        this.setOptionDefault(PROP_ATTACHMENT_IMPLEMENTATION, AxisProperties.getProperty("axis.attachments.implementation"));
        this.setOptionDefault(PROP_ATTACHMENT_IMPLEMENTATION, DEFAULT_ATTACHMENT_IMPL);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AxisEngine::init");
        }
    }

    public void cleanup() {
        super.cleanup();
        Enumeration keys = this.session.getKeys();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object obj = this.session.get(key);
                if (obj != null && obj instanceof ServiceLifecycle) {
                    ((ServiceLifecycle)obj).destroy();
                }
                this.session.remove(key);
            }
        }
    }

    public void saveConfiguration() {
        if (!this.shouldSaveConfig) {
            return;
        }
        try {
            this.config.writeEngineConfig(this);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("saveConfigFail00"), (Throwable)e);
        }
    }

    public EngineConfiguration getConfig() {
        return this.config;
    }

    public boolean hasSafePassword() {
        return this._hasSafePassword;
    }

    public void setAdminPassword(String pw) {
        this.setOption(PROP_PASSWORD, pw);
        this._hasSafePassword = true;
        this.saveConfiguration();
    }

    public void setShouldSaveConfig(boolean shouldSaveConfig) {
        this.shouldSaveConfig = shouldSaveConfig;
    }

    public Handler getHandler(String name) throws AxisFault {
        try {
            return this.config.getHandler(new QName(null, name));
        }
        catch (ConfigurationException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public SOAPService getService(String name) throws AxisFault {
        try {
            return this.config.getService(new QName(null, name));
        }
        catch (ConfigurationException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public Handler getTransport(String name) throws AxisFault {
        try {
            return this.config.getTransport(new QName(null, name));
        }
        catch (ConfigurationException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        TypeMappingRegistry tmr = null;
        try {
            tmr = this.config.getTypeMappingRegistry();
        }
        catch (ConfigurationException e) {
            log.error((Object)Messages.getMessage("axisConfigurationException00"), (Throwable)e);
        }
        return tmr;
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        return this.config.getGlobalRequest();
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        return this.config.getGlobalResponse();
    }

    public ArrayList getActorURIs() {
        return this.actorURIs;
    }

    public void addActorURI(String uri) {
        this.actorURIs.add(uri);
    }

    public void removeActorURI(String uri) {
        this.actorURIs.remove(uri);
    }

    public abstract AxisEngine getClientEngine();

    public static void normaliseOptions(Handler handler) {
        AxisEngine engine;
        for (int i = 0; i < BOOLEAN_OPTIONS.length; ++i) {
            Object val = handler.getOption(BOOLEAN_OPTIONS[i]);
            if (val != null) {
                if (val instanceof Boolean) continue;
                if (JavaUtils.isFalse(val)) {
                    handler.setOption(BOOLEAN_OPTIONS[i], Boolean.FALSE);
                    continue;
                }
            } else if (!(handler instanceof AxisEngine)) continue;
            handler.setOption(BOOLEAN_OPTIONS[i], Boolean.TRUE);
        }
        if (handler instanceof AxisEngine && !(engine = (AxisEngine)handler).setOptionDefault(PROP_PASSWORD, DEFAULT_ADMIN_PASSWORD)) {
            engine.setAdminPassword((String)engine.getOption(PROP_PASSWORD));
        }
    }

    public void refreshGlobalOptions() throws ConfigurationException {
        Hashtable globalOptions = this.config.getGlobalOptions();
        if (globalOptions != null) {
            this.setOptions(globalOptions);
        }
        AxisEngine.normaliseOptions(this);
    }

    public Session getApplicationSession() {
        return this.session;
    }

    public ClassCache getClassCache() {
        return null;
    }
}

