/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxr.juddi.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.proxy.Transport;
import org.apache.juddi.util.xml.XMLUtils;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SaajTransport
implements Transport {
    private static Log log = LogFactory.getLog((Class)(class$org$jboss$jaxr$juddi$transport$SaajTransport == null ? (class$org$jboss$jaxr$juddi$transport$SaajTransport = SaajTransport.class$("org.jboss.jaxr.juddi.transport.SaajTransport")) : class$org$jboss$jaxr$juddi$transport$SaajTransport));
    private String debugProp = System.getProperty("jaxr.debug", "false");
    static /* synthetic */ Class class$org$jboss$jaxr$juddi$transport$SaajTransport;

    public Element send(Element request, URL endpointURL) throws RegistryException {
        log.debug((Object)("Request message:" + XMLUtils.toString((Element)request)));
        if ("true".equalsIgnoreCase(this.debugProp)) {
            System.out.println("Request Element:" + XMLUtils.toString((Element)request));
        }
        Element response = null;
        try {
            boolean hasFault;
            MessageFactory msgFactory = MessageFactory.newInstance();
            SOAPMessage message = msgFactory.createMessage();
            message.getSOAPHeader().detachNode();
            SOAPPart soapPart = message.getSOAPPart();
            SOAPBody soapBody = soapPart.getEnvelope().getBody();
            soapBody.addChildElement(this.getSOAPElement(soapBody, request));
            ByteArrayOutputStream by = new ByteArrayOutputStream();
            message.writeTo((OutputStream)by);
            by.close();
            if ("true".equalsIgnoreCase(this.debugProp)) {
                message.writeTo((OutputStream)System.out);
            }
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = soapConnectionFactory.createConnection();
            SOAPMessage soapResponse = connection.call(message, (Object)endpointURL);
            if ("true".equalsIgnoreCase(this.debugProp)) {
                System.out.println("Response is:");
                soapResponse.writeTo((OutputStream)System.out);
            }
            if (hasFault = (soapBody = soapResponse.getSOAPBody()).hasFault()) {
                SOAPFault soapFault = soapBody.getFault();
                String faultStr = soapFault.getFaultCode() + "::" + soapFault.getFaultString();
                throw new RegistryException(faultStr);
            }
            response = this.getFirstChildElement((Element)soapBody);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        log.debug((Object)("Response message:" + XMLUtils.getText((Element)response)));
        return response;
    }

    public String send(String request, URL endpointURL) throws RegistryException {
        Element reqEl = SaajTransport.getElement(request);
        Element respEl = this.send(reqEl, endpointURL);
        StringWriter sw = new StringWriter();
        DOMWriter dw = new DOMWriter((Writer)sw);
        dw.print((Node)respEl);
        return sw.toString();
    }

    private SOAPElement getSOAPElement(SOAPBody soapBody, Element elem) {
        String xmlns = "urn:uddi-org:api_v2";
        SOAPElement soapElement = null;
        SOAPFactory factory = null;
        try {
            int i;
            int len;
            factory = SOAPFactory.newInstance();
            String name = elem.getNodeName();
            String nsuri = elem.getNamespaceURI();
            if (nsuri == null) {
                nsuri = xmlns;
            }
            soapElement = factory.createElement(name, "ns1", nsuri);
            if (elem.hasAttributes()) {
                NamedNodeMap nnm = elem.getAttributes();
                len = nnm != null ? nnm.getLength() : 0;
                for (i = 0; i < len; ++i) {
                    Node n = nnm.item(i);
                    String nodename = n.getNodeName();
                    String nodevalue = n.getNodeValue();
                    soapElement.addAttribute(factory.createName(nodename), nodevalue);
                }
            } else {
                soapElement.addAttribute(factory.createName("xmlns:ns1"), nsuri);
            }
            NodeList nlist = elem.getChildNodes();
            len = nlist != null ? nlist.getLength() : 0;
            for (i = 0; i < len; ++i) {
                int nodeType;
                Node node = nlist.item(i);
                int n = nodeType = node != null ? (int)node.getNodeType() : -100;
                if (1 == nodeType) {
                    soapElement.addChildElement(this.getSOAPElement(soapBody, (Element)node));
                    continue;
                }
                if (nodeType != 3) continue;
                soapElement.addTextNode(node.getNodeValue());
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return soapElement;
    }

    public static Element getElement(String xmlFrag) {
        Document doc = null;
        Element reqElement = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xmlFrag)));
            reqElement = doc.getDocumentElement();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return reqElement;
    }

    public Element getFirstChildElement(Element el) {
        return this.getFirstChildElement(el, null);
    }

    public Element getFirstChildElement(Element el, String tagName) {
        Element childEl = null;
        NodeList nlist = el != null ? el.getChildNodes() : null;
        int len = nlist != null ? nlist.getLength() : 0;
        for (int i = 0; childEl == null && i < len; ++i) {
            Node node = nlist.item(i);
            if (node.getNodeType() != 1 || tagName != null && !tagName.equals(node.getLocalName())) continue;
            childEl = (Element)node;
        }
        return childEl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

