/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.services;

import java.util.Date;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.timer.TimerMBean;
import org.jboss.monitor.services.TimerServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.Strings;

public class TimerService
extends ServiceMBeanSupport
implements TimerServiceMBean {
    private String notificationType;
    private String notificationMessage;
    private String timerPeriodString;
    private long repeatitions;
    private ObjectName timerObjectName;
    private long timerPeriod;
    private TimerMBean timerProxy;
    private Integer id;
    static /* synthetic */ Class class$javax$management$timer$TimerMBean;

    public void setNotificationType(String type) {
        this.notificationType = type;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationMessage(String message) {
        this.notificationMessage = message;
    }

    public String getNotificationMessage() {
        return this.notificationMessage;
    }

    public void setTimerPeriod(String timerPeriod) {
        this.timerPeriod = Strings.parsePositiveTimePeriod((String)timerPeriod);
        this.timerPeriodString = timerPeriod;
    }

    public String getTimerPeriod() {
        return this.timerPeriodString;
    }

    public void setRepeatitions(long repeatitions) {
        this.repeatitions = repeatitions;
    }

    public long getRepeatitions() {
        return this.repeatitions;
    }

    public void setTimerMBean(ObjectName timerMBean) {
        this.timerProxy = (TimerMBean)MBeanServerInvocationHandler.newProxyInstance(this.getServer(), timerMBean, class$javax$management$timer$TimerMBean == null ? (class$javax$management$timer$TimerMBean = TimerService.class$("javax.management.timer.TimerMBean")) : class$javax$management$timer$TimerMBean, false);
        this.timerObjectName = timerMBean;
    }

    public ObjectName getTimerMBean() {
        return this.timerObjectName;
    }

    public void startService() throws Exception {
        if (this.timerProxy != null) {
            this.id = this.timerProxy.addNotification(this.notificationType, this.notificationMessage, null, new Date(), this.timerPeriod, this.repeatitions);
            this.log.debug((Object)("Added timer notification(" + this.id + ") : type=" + this.notificationType + ", message=" + this.notificationMessage + ", period=" + this.timerPeriodString + ", repeatitions=" + this.repeatitions + ", to timer '" + this.timerObjectName + "'"));
        } else {
            this.log.warn((Object)"TimerMBean not set");
        }
    }

    public void stopService() {
        if (this.id != null) {
            try {
                this.timerProxy.removeNotification(this.id);
                this.log.debug((Object)("Removed timer notification(" + this.id + ") from timer '" + this.timerObjectName + "'"));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
            this.id = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

