/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.jboss.axis.Constants;
import org.jboss.axis.client.AxisClientProxy;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ParameterDesc;
import org.jboss.axis.description.ParameterWrapping;
import org.jboss.axis.enums.Style;
import org.jboss.axis.enums.Use;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.logging.Logger;
import org.jboss.webservice.client.CallImpl;
import org.jboss.webservice.client.Stub;
import org.jboss.webservice.deployment.BeanXMLMetaData;
import org.jboss.webservice.deployment.ServiceDescription;
import org.jboss.webservice.deployment.TypeMappingDescription;

public class PortProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger((Class)PortProxy.class);
    private Remote port;
    private CallImpl call;
    private List seiMethods = new ArrayList();
    private List objectMethods = new ArrayList();
    private List stubMethods = new ArrayList();
    private static List transportProps = new ArrayList();
    private Method getPropertyMethod;
    private Method setPropertyMethod;

    public PortProxy(Remote port, Class seiClass) {
        this.port = port;
        AxisClientProxy axisClientProxy = (AxisClientProxy)Proxy.getInvocationHandler(port);
        this.call = (CallImpl)axisClientProxy.getCall();
        this.objectMethods.addAll(Arrays.asList(Object.class.getMethods()));
        this.seiMethods.addAll(Arrays.asList(seiClass.getMethods()));
        this.stubMethods.addAll(Arrays.asList(Stub.class.getMethods()));
        try {
            this.getPropertyMethod = Stub.class.getMethod("_getProperty", String.class);
            this.setPropertyMethod = Stub.class.getMethod("_setProperty", String.class, Object.class);
        }
        catch (NoSuchMethodException ignore) {
            // empty catch block
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        try {
            Object retObj = null;
            if (this.seiMethods.contains(method)) {
                log.debug((Object)("Invoke on service endpoint interface: " + methodName));
                AxisClientProxy axisProxy = (AxisClientProxy)Proxy.getInvocationHandler(this.port);
                axisProxy.setupCallOperation(method);
                OperationDesc opDesc = this.call.getOperation();
                Style style = opDesc.getStyle();
                Use use = opDesc.getUse();
                if (style == Style.DOCUMENT && use == Use.LITERAL && opDesc.getNumInParams() == 1) {
                    Object firstArg;
                    ParameterDesc paramDesc = (ParameterDesc)opDesc.getInParams().get(0);
                    QName typeQName = paramDesc.getTypeQName();
                    Class javaType = paramDesc.getJavaType();
                    Object object = firstArg = args != null ? args[0] : null;
                    if (!(Constants.isSchemaXSD((String)typeQName.getNamespaceURI()) || firstArg != null && JavaUtils.isConvertable((Object)firstArg, (Class)javaType, (boolean)false))) {
                        if (paramDesc.getWrappedVariables() == null) {
                            ServiceDescription serviceDescription = this.call.getServiceDescription();
                            TypeMappingDescription typeMapping = serviceDescription.getTypeMapping(typeQName);
                            if (typeMapping == null) {
                                throw new IllegalStateException("Cannot obtain type mapping for: " + typeQName);
                            }
                            BeanXMLMetaData tmMetaData = typeMapping.getMetaData();
                            if (tmMetaData == null) {
                                throw new IllegalStateException("Cannot obtain type mapping meta data for: " + typeQName);
                            }
                            opDesc.setWrapParameters(true);
                            paramDesc.setWrappedVariables(tmMetaData.getElementOrder());
                        }
                        ParameterDesc retParamDesc = opDesc.getReturnParamDesc();
                        QName retTypeQName = retParamDesc.getTypeQName();
                        if (retParamDesc.getWrappedVariables() == null) {
                            ServiceDescription serviceDescription = this.call.getServiceDescription();
                            TypeMappingDescription typeMapping = serviceDescription.getTypeMapping(retTypeQName);
                            BeanXMLMetaData tmMetaData = typeMapping.getMetaData();
                            if (tmMetaData == null) {
                                throw new IllegalStateException("Cannot obtain type mapping meta data for: " + retTypeQName);
                            }
                            opDesc.setWrapParameters(true);
                            retParamDesc.setWrappedVariables(tmMetaData.getElementOrder());
                        }
                        args = new Object[]{ParameterWrapping.wrapRequestParameters((OperationDesc)opDesc, (Object[])args)};
                    }
                }
                retObj = axisProxy.invokeSEIMethod(method, args);
                Class<?> returnType = method.getReturnType();
                if (retObj != null && !returnType.isAssignableFrom(retObj.getClass())) {
                    if (JavaUtils.isConvertable((Object)retObj, returnType, (boolean)false)) {
                        retObj = JavaUtils.convert((Object)retObj, returnType);
                    } else if (opDesc.isWrapParameters()) {
                        retObj = ParameterWrapping.unwrapResponseParameter((OperationDesc)opDesc, (Object)retObj);
                    }
                }
                return retObj;
            }
            if (this.stubMethods.contains(method)) {
                log.debug((Object)("Invoke on stub interface: " + methodName));
                if ("getUsername".equals(methodName)) {
                    retObj = this.getPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.security.auth.username");
                } else if ("setUsername".equals(methodName)) {
                    retObj = this.setPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.security.auth.username", args[0]);
                } else if ("getPassword".equals(methodName)) {
                    retObj = this.getPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.security.auth.password");
                } else if ("setPassword".equals(methodName)) {
                    retObj = this.setPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.security.auth.password", args[0]);
                } else if ("getEndpointAddress".equals(methodName)) {
                    retObj = this.getPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.service.endpoint.address");
                } else if ("setEndpointAddress".equals(methodName)) {
                    retObj = this.setPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.service.endpoint.address", args[0]);
                } else if ("getSessionMaintain".equals(methodName)) {
                    retObj = this.getPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.session.maintain");
                } else if ("setSessionMaintain".equals(methodName)) {
                    retObj = this.setPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.session.maintain", args[0]);
                } else if ("getTimeout".equals(methodName)) {
                    retObj = this.call.getTimeout();
                } else if ("setTimeout".equals(methodName)) {
                    this.call.setTimeout((Integer)args[0]);
                } else if (this.getPropertyMethod.equals(method) && "org.jboss.webservice.client.timeout".equals(args[0])) {
                    retObj = this.call.getTimeout();
                } else if (this.setPropertyMethod.equals(method) && "org.jboss.webservice.client.timeout".equals(args[0])) {
                    this.call.setTimeout((Integer)args[1]);
                } else if (this.getPropertyMethod.equals(method) && "org.jboss.webservice.client.timeout".equals(args[0])) {
                    retObj = this.call.getTimeout();
                } else if (this.setPropertyMethod.equals(method) && "org.jboss.webservice.client.timeout".equals(args[0])) {
                    this.call.setTimeout((Integer)args[1]);
                } else if ("getTransportOption".equals(methodName)) {
                    retObj = this.call.getTransportOption((String)args[0]);
                } else if ("setTransportOption".equals(methodName)) {
                    this.call.setTransportOption((String)args[0], args[1]);
                } else if (this.getPropertyMethod.equals(method) && transportProps.contains(args[0])) {
                    retObj = this.call.getTransportOption((String)args[0]);
                } else if (this.setPropertyMethod.equals(method) && transportProps.contains(args[0])) {
                    this.call.setTransportOption((String)args[0], args[1]);
                } else if ("addAttachment".equals(methodName)) {
                    this.call.addAttachment((String)args[0], args[1]);
                } else if ("removeAttachment".equals(methodName)) {
                    this.call.removeAttachment((String)args[0]);
                } else {
                    retObj = "getAttachments".equals(methodName) ? this.call.getAttachmentIdentifiers() : ("getAttachment".equals(methodName) ? this.call.getAttachment((String)args[0]) : method.invoke((Object)this.port, args));
                }
                return retObj;
            }
            if (this.objectMethods.contains(method)) {
                log.debug((Object)("Invoke on object: " + methodName));
                retObj = method.invoke((Object)this.port, args);
                return retObj;
            }
            throw new JAXRPCException("Don't know how to invoke: " + method);
        }
        catch (Exception e) {
            Throwable th = this.processException(e);
            if (this.seiMethods.contains(method) && (th instanceof JAXRPCException || th instanceof RuntimeException)) {
                RemoteException re = new RemoteException(th.getMessage(), th);
                th = re;
            }
            throw th;
        }
    }

    private Throwable processException(Exception ex) {
        Throwable th = ex;
        if (ex instanceof InvocationTargetException) {
            th = ((InvocationTargetException)ex).getTargetException();
        }
        log.error((Object)"Port error", th);
        return th;
    }

    static {
        transportProps.add("org.jboss.webservice.keyStore");
        transportProps.add("org.jboss.webservice.keyStorePassword");
        transportProps.add("org.jboss.webservice.keyStoreType");
        transportProps.add("org.jboss.webservice.trustStore");
        transportProps.add("org.jboss.webservice.trustStorePassword");
        transportProps.add("org.jboss.webservice.trustStoreType");
    }
}

