/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.detection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionValidator;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.detection.AbstractDetectorMBean;
import org.jboss.remoting.detection.Detection;
import org.jboss.remoting.detection.ServerInvokerMetadata;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkRegistryFinder;
import org.jboss.remoting.transport.ClientInvoker;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDetector
implements AbstractDetectorMBean {
    private long defaultTimeDelay = 5000L;
    private long heartbeatTimeDelay = 1000L;
    protected final Logger log = Logger.getLogger(this.getClass());
    protected MBeanServer mbeanserver;
    protected ObjectName objectName;
    protected ObjectName registryObjectName;
    private Identity myself;
    private Timer heartbeatTimer;
    private Timer failureTimer;
    private Map servers = new HashMap();
    private Element xml;
    private Set domains = new HashSet();
    static /* synthetic */ Class class$org$jboss$remoting$ident$Identity;
    static /* synthetic */ Class array$Lorg$jboss$remoting$detection$ServerInvokerMetadata;

    public void setHeartbeatTimeDelay(long heartbeatTimeDelay) {
        if (heartbeatTimeDelay <= 0L || heartbeatTimeDelay >= this.defaultTimeDelay) {
            throw new IllegalArgumentException("Can not set heartbeat time delay (" + heartbeatTimeDelay + ") to a negative number or " + "to a number greater than the default time delay (" + this.defaultTimeDelay + ").");
        }
        this.heartbeatTimeDelay = heartbeatTimeDelay;
    }

    public long getHeartbeatTimeDelay() {
        return this.heartbeatTimeDelay;
    }

    public void setDefaultTimeDelay(long defaultTimeDelay) {
        if (defaultTimeDelay < this.heartbeatTimeDelay) {
            throw new IllegalArgumentException("Can not set the default time delay (" + defaultTimeDelay + ") to be less" + " than that of the heartbeat time delay (" + this.heartbeatTimeDelay + ").");
        }
        this.defaultTimeDelay = defaultTimeDelay;
    }

    public long getDefaultTimeDelay() {
        return this.defaultTimeDelay;
    }

    public Detection createDetection() {
        Detection detection = null;
        ServerInvoker[] invokers = InvokerRegistry.getServerInvokers();
        if (invokers == null || invokers.length <= 0) {
            return detection;
        }
        ArrayList<ServerInvokerMetadata> l = new ArrayList<ServerInvokerMetadata>(invokers.length);
        for (int c = 0; c < invokers.length; ++c) {
            if (!invokers[c].isStarted()) continue;
            ServerInvokerMetadata serverInvoker = new ServerInvokerMetadata(invokers[c].getLocator(), invokers[c].getSupportedSubsystems());
            l.add(serverInvoker);
        }
        if (l.isEmpty()) {
            return detection;
        }
        ServerInvokerMetadata[] metadata = l.toArray(new ServerInvokerMetadata[l.size()]);
        detection = new Detection(Identity.get(this.mbeanserver), metadata);
        return detection;
    }

    public void start() throws Exception {
        this.myself = Identity.get(this.mbeanserver);
        if (this.domains.isEmpty() && this.xml == null) {
            this.domains.add(this.myself.getDomain());
        }
        this.registryObjectName = NetworkRegistryFinder.find(this.mbeanserver);
        if (this.registryObjectName == null) {
            this.log.warn((Object)("Detector: " + this.getClass().getName() + " could not be loaded because the NetworkRegistry is not registered"));
            this.log.warn((Object)"This means that only the broadcasting of detection messages will be functional and will not be able to discover other servers.");
        }
        this.startPinger(this.getPingerDelay(), this.getPingerPeriod());
        this.startHeartbeat(this.getHeartbeatDelay(), this.getHeartbeatPeriod());
    }

    protected long getPingerDelay() {
        return 5000L;
    }

    protected long getPingerPeriod() {
        return 1500L;
    }

    protected void startPinger(long delay, long period) {
        this.failureTimer = new Timer(false);
        this.failureTimer.schedule((TimerTask)new FailureDetector(), delay, period);
    }

    protected void stopPinger() {
        if (this.failureTimer != null) {
            this.failureTimer.cancel();
            this.failureTimer = null;
        }
    }

    public void stop() throws Exception {
        this.stopPinger();
        this.stopHeartbeat();
        this.stopPinger();
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean aBoolean) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.mbeanserver = mBeanServer;
        this.objectName = objectName;
        return objectName;
    }

    public void setConfiguration(Element xml) throws Exception {
        this.xml = xml;
        if (xml != null) {
            this.domains.clear();
            NodeList domainNodes = xml.getElementsByTagName("domain");
            if (domainNodes == null || domainNodes.getLength() <= 0) {
                this.log.debug((Object)"No domains specified.  Will accept all domains.");
            }
            int len = domainNodes.getLength();
            for (int c = 0; c < len; ++c) {
                Node node = domainNodes.item(c);
                String domain = node.getFirstChild().getNodeValue();
                this.domains.add(domain);
                this.log.debug((Object)("Added domain " + domain + " to detector list."));
            }
        }
    }

    public Element getConfiguration() {
        return this.xml;
    }

    protected void startHeartbeat(long delay, long period) {
        if (this.heartbeatTimer == null) {
            this.heartbeatTimer = new Timer(false);
        }
        this.heartbeatTimer.schedule((TimerTask)new Heartbeat(), delay, period);
    }

    protected void stopHeartbeat() {
        if (this.heartbeatTimer != null) {
            try {
                this.heartbeatTimer.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.heartbeatTimer = null;
        }
    }

    protected long getHeartbeatDelay() {
        return 0L;
    }

    protected long getHeartbeatPeriod() {
        return this.heartbeatTimeDelay;
    }

    protected abstract void heartbeat();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void detect(Detection detection) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Detection message received.");
            this.log.trace((Object)("Id = " + detection.getIdentity().getInstanceId()));
            this.log.trace((Object)("isRemoteDetection() = " + this.isRemoteDetection(detection)));
        }
        if (this.isRemoteDetection(detection)) {
            try {
                boolean found = false;
                Server server = null;
                Map map = this.servers;
                synchronized (map) {
                    server = (Server)this.servers.get(detection);
                    boolean bl = found = server != null;
                    if (!found) {
                        server = new Server(detection);
                        this.servers.put(detection, server);
                    } else {
                        server.lastDetection = System.currentTimeMillis();
                    }
                }
                if (!found) {
                    if (this.registryObjectName == null) return;
                    this.log.debug((Object)("detected NEW server: " + detection.getIdentity()));
                    this.mbeanserver.invoke(this.registryObjectName, "addServer", new Object[]{detection.getIdentity(), detection.getServerInvokers()}, new String[]{(class$org$jboss$remoting$ident$Identity == null ? (class$org$jboss$remoting$ident$Identity = AbstractDetector.class$("org.jboss.remoting.ident.Identity")) : class$org$jboss$remoting$ident$Identity).getName(), (array$Lorg$jboss$remoting$detection$ServerInvokerMetadata == null ? (array$Lorg$jboss$remoting$detection$ServerInvokerMetadata = AbstractDetector.class$("[Lorg.jboss.remoting.detection.ServerInvokerMetadata;")) : array$Lorg$jboss$remoting$detection$ServerInvokerMetadata).getName()});
                    return;
                }
                if (!server.changed(detection)) return;
                server.rehash(detection);
                if (this.registryObjectName == null) return;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("detected UPDATE for server: " + detection.getIdentity()));
                }
                this.mbeanserver.invoke(this.registryObjectName, "updateServer", new Object[]{detection.getIdentity(), detection.getServerInvokers()}, new String[]{(class$org$jboss$remoting$ident$Identity == null ? (class$org$jboss$remoting$ident$Identity = AbstractDetector.class$("org.jboss.remoting.ident.Identity")) : class$org$jboss$remoting$ident$Identity).getName(), (array$Lorg$jboss$remoting$detection$ServerInvokerMetadata == null ? (array$Lorg$jboss$remoting$detection$ServerInvokerMetadata = AbstractDetector.class$("[Lorg.jboss.remoting.detection.ServerInvokerMetadata;")) : array$Lorg$jboss$remoting$detection$ServerInvokerMetadata).getName()});
                return;
            }
            catch (InstanceNotFoundException inf) {
                return;
            }
            catch (Exception e) {
                this.log.error((Object)("Error during detection of: " + detection), (Throwable)e);
                return;
            }
        }
        if (!this.log.isTraceEnabled()) return;
        this.log.trace((Object)"detection from myself - ignored");
    }

    protected boolean isRemoteDetection(Detection detection) {
        String domain = detection.getIdentity().getDomain();
        return (this.domains.isEmpty() || this.domains.contains(domain)) && !this.myself.isSameJVM(detection.getIdentity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkInvokerServer(Detection detection, ClassLoader cl) {
        boolean ok = false;
        InvokerLocator[] il = detection.getLocators();
        for (int c = 0; c < il.length; ++c) {
            try {
                boolean isValid;
                ClientInvoker ci = InvokerRegistry.createClientInvoker(il[c]);
                if (!ci.isConnected()) {
                    ci.connect();
                }
                if (!(isValid = ConnectionValidator.checkConnection(ci))) continue;
                ok = true;
            }
            catch (Throwable ig) {
                this.log.debug((Object)("failed calling ping on " + detection + " due to " + ig.getMessage()));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)ig);
                }
                InvokerRegistry.destroyClientInvoker(il[c]);
            }
            break;
        }
        if (!ok) {
            try {
                if (this.registryObjectName != null) {
                    this.mbeanserver.invoke(this.registryObjectName, "removeServer", new Object[]{detection.getIdentity()}, new String[]{(class$org$jboss$remoting$ident$Identity == null ? (class$org$jboss$remoting$ident$Identity = AbstractDetector.class$("org.jboss.remoting.ident.Identity")) : class$org$jboss$remoting$ident$Identity).getName()});
                    this.log.debug((Object)("Removed detection " + detection));
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)"Error removing server", (Throwable)ex);
            }
            finally {
                this.servers.remove(detection);
            }
        }
        return ok;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class Heartbeat
    extends TimerTask {
        private Heartbeat() {
        }

        public void run() {
            InvokerLocator[] il = InvokerRegistry.getRegisteredServerLocators();
            if (il != null && il.length > 0) {
                AbstractDetector.this.heartbeat();
            }
        }
    }

    private final class Server {
        Detection detection;
        private int hashCode = 0;
        long lastDetection = System.currentTimeMillis();

        Server(Detection detection) {
            this.rehash(detection);
        }

        private void rehash(Detection d) {
            this.hashCode = this.hash(d);
        }

        private int hash(Detection d) {
            int hc = 0;
            InvokerLocator[] locators = d.getLocators();
            if (locators != null) {
                for (int c = 0; c < locators.length; ++c) {
                    hc += locators[c].hashCode();
                }
            }
            return hc;
        }

        boolean changed(Detection detection) {
            return this.hashCode != this.hash(detection);
        }

        public boolean equals(Object obj) {
            return obj instanceof Server && this.hashCode == obj.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private final class FailureDetector
    extends TimerTask {
        private FailureDetector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (AbstractDetector.this.servers.isEmpty()) {
                return;
            }
            HashMap map = null;
            Map map2 = AbstractDetector.this.servers;
            synchronized (map2) {
                map = new HashMap(AbstractDetector.this.servers);
            }
            ClassLoader cl = AbstractDetector.this.getClass().getClassLoader();
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Detection detection = (Detection)iter.next();
                long lastDetection = 0L;
                Server server = null;
                Map map3 = AbstractDetector.this.servers;
                synchronized (map3) {
                    server = (Server)map.get(detection);
                    lastDetection = server.lastDetection;
                }
                long duration = System.currentTimeMillis() - lastDetection;
                if (duration < AbstractDetector.this.defaultTimeDelay) continue;
                if (AbstractDetector.this.log.isTraceEnabled()) {
                    AbstractDetector.this.log.trace((Object)("detection for: " + detection + " has not been received in: " + AbstractDetector.this.defaultTimeDelay + " ms, contacting.."));
                }
                if (!AbstractDetector.this.checkInvokerServer(detection, cl)) continue;
                if (AbstractDetector.this.log.isTraceEnabled()) {
                    AbstractDetector.this.log.trace((Object)("detection for: " + detection + " recovered on ping"));
                }
                server.lastDetection = System.currentTimeMillis();
            }
        }
    }
}

