/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.gui.poa;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import org.jacorb.poa.gui.POAMonitorController;
import org.jacorb.poa.gui.POAMonitorView;
import org.jacorb.poa.gui.beans.CloseButtonPanel;
import org.jacorb.poa.gui.beans.CloseButtonPanelController;
import org.jacorb.poa.gui.beans.ConsolePanel;
import org.jacorb.poa.gui.beans.DoubleListDialog;
import org.jacorb.poa.gui.beans.FillLevelBar;
import org.jacorb.poa.gui.beans.MessageDialog;
import org.jacorb.poa.gui.poa.DetailsButtonController;
import org.jacorb.poa.gui.poa.ObjectListItem;
import org.jacorb.poa.gui.poa.ObjectListItemController;
import org.jacorb.poa.gui.poa.POAStatePanel;
import org.jacorb.poa.gui.poa.QueueListItem;
import org.jacorb.poa.gui.poa.QueueListItemController;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;

public class POAFrame
extends Frame
implements CloseButtonPanelController,
DetailsButtonController,
ObjectListItemController,
QueueListItemController,
POAMonitorView,
WindowListener {
    private POAMonitorController controller = null;
    private static Color aomBarColor = new Color(196, 196, 0);
    private static Color queueBarColor = new Color(0, 128, 128);
    private static Color activeRequestsBarColor1 = new Color(0, 128, 0);
    private static Color activeRequestsBarColor2 = new Color(128, 0, 0);
    private static Color threadPoolBarColor = new Color(0, 128, 0);
    private String poaName = "";
    private FillLevelBar aomBar = null;
    private FillLevelBar queueBar = null;
    private FillLevelBar activeRequestsBar = null;
    private FillLevelBar threadPoolBar = null;
    private Label stateLabel = null;
    private Label threadLabel = null;
    private Label lifespanLabel = null;
    private Label idUniquenessLabel = null;
    private Label idAssignmentLabel = null;
    private Label servantRetentionLabel = null;
    private Label requestProcessingLabel = null;
    private Label implicitActivationLabel = null;
    private FontMetrics fontMetrics1 = null;
    private CloseButtonPanel ivjButtonPanel = null;
    private ConsolePanel ivjConsolePanel = null;
    private Panel ivjContentsPane = null;
    private POAStatePanel ivjPOAStatePanel = null;
    static /* synthetic */ Class class$java$awt$Window;

    public void _actionCloseButtonPressed() {
        if (this.controller != null) {
            this.controller.actionCloseView();
        }
    }

    public void _actionDeactivateObject(String string) {
        if (this.controller != null) {
            this.controller.actionDeactivateObject(string);
        }
    }

    public void _actionDetailsButtonPressed(String string) {
        if (string.equals("aom")) {
            this._showAOMDialog();
        } else if (string.equals("queue")) {
            this._showQueueDialog();
        } else {
            System.err.println("details unknown source: " + string);
        }
    }

    private void connEtoC1(WindowEvent windowEvent) {
        try {
            this._actionCloseButtonPressed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public void _destroy() {
        this.dispose();
    }

    private FontMetrics _fontMetrics1() {
        if (this.fontMetrics1 == null) {
            this.fontMetrics1 = this.getPOAStatePanel()._getPolicyPanel()._getThreadLabel().getGraphics().getFontMetrics();
        }
        return this.fontMetrics1;
    }

    private FillLevelBar _getActiveRequestsBar() {
        if (this.activeRequestsBar == null) {
            this.activeRequestsBar = this.getPOAStatePanel()._getTMPanel()._getActiveRequestsBar();
        }
        return this.activeRequestsBar;
    }

    private FillLevelBar _getAOMBar() {
        if (this.aomBar == null) {
            this.aomBar = this.getPOAStatePanel()._getAOMPanel()._getAOMBar();
        }
        return this.aomBar;
    }

    private CloseButtonPanel getButtonPanel() {
        if (this.ivjButtonPanel == null) {
            try {
                this.ivjButtonPanel = new CloseButtonPanel();
                this.ivjButtonPanel.setName("ButtonPanel");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjButtonPanel;
    }

    private ConsolePanel getConsolePanel() {
        if (this.ivjConsolePanel == null) {
            try {
                this.ivjConsolePanel = new ConsolePanel();
                this.ivjConsolePanel.setName("ConsolePanel");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConsolePanel;
    }

    private Panel getContentsPane() {
        if (this.ivjContentsPane == null) {
            try {
                this.ivjContentsPane = new Panel();
                this.ivjContentsPane.setName("ContentsPane");
                this.ivjContentsPane.setLayout(new BorderLayout());
                this.ivjContentsPane.setBackground(SystemColor.control);
                this.getContentsPane().add((Component)this.getButtonPanel(), "South");
                this.getContentsPane().add((Component)this.getConsolePanel(), "Center");
                this.getContentsPane().add((Component)this.getPOAStatePanel(), "North");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjContentsPane;
    }

    private Label _getIdAssignmentLabel() {
        if (this.idAssignmentLabel == null) {
            this.idAssignmentLabel = this.getPOAStatePanel()._getPolicyPanel()._getIdAssignmentLabel();
        }
        return this.idAssignmentLabel;
    }

    private Label _getIdUniquenessLabel() {
        if (this.idUniquenessLabel == null) {
            this.idUniquenessLabel = this.getPOAStatePanel()._getPolicyPanel()._getIdUniquenessLabel();
        }
        return this.idUniquenessLabel;
    }

    private Label _getImplicitActivationLabel() {
        if (this.implicitActivationLabel == null) {
            this.implicitActivationLabel = this.getPOAStatePanel()._getPolicyPanel()._getImplicitActivationLabel();
        }
        return this.implicitActivationLabel;
    }

    private Label _getLifespanLabel() {
        if (this.lifespanLabel == null) {
            this.lifespanLabel = this.getPOAStatePanel()._getPolicyPanel()._getLifespanLabel();
        }
        return this.lifespanLabel;
    }

    private POAStatePanel getPOAStatePanel() {
        if (this.ivjPOAStatePanel == null) {
            try {
                this.ivjPOAStatePanel = new POAStatePanel();
                this.ivjPOAStatePanel.setName("POAStatePanel");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjPOAStatePanel;
    }

    private FillLevelBar _getQueueBar() {
        if (this.queueBar == null) {
            this.queueBar = this.getPOAStatePanel()._getQueuePanel()._getQueueBar();
        }
        return this.queueBar;
    }

    private Label _getRequestProcessingLabel() {
        if (this.requestProcessingLabel == null) {
            this.requestProcessingLabel = this.getPOAStatePanel()._getPolicyPanel()._getRequestProcessingLabel();
        }
        return this.requestProcessingLabel;
    }

    private Label _getServantRetentionLabel() {
        if (this.servantRetentionLabel == null) {
            this.servantRetentionLabel = this.getPOAStatePanel()._getPolicyPanel()._getServantRetentionLabel();
        }
        return this.servantRetentionLabel;
    }

    private Label _getStateLabel() {
        if (this.stateLabel == null) {
            this.stateLabel = this.getPOAStatePanel()._getStatePanel()._getStateLabel();
        }
        return this.stateLabel;
    }

    private Label _getThreadLabel() {
        if (this.threadLabel == null) {
            this.threadLabel = this.getPOAStatePanel()._getPolicyPanel()._getThreadLabel();
        }
        return this.threadLabel;
    }

    private FillLevelBar _getThreadPoolBar() {
        if (this.threadPoolBar == null) {
            this.threadPoolBar = this.getPOAStatePanel()._getTMPanel()._getThreadPoolBar();
        }
        return this.threadPoolBar;
    }

    private void handleException(Throwable throwable) {
    }

    public void _initActiveRequestsBar(int n, int n2) {
        this._getActiveRequestsBar().init(0, n, n2, activeRequestsBarColor1, activeRequestsBarColor2, true, false);
    }

    public void _initAOMBar(int n, boolean bl) {
        this._getAOMBar().init(0, 0, n, aomBarColor, null, false, bl);
    }

    private void initConnections() {
        this.addWindowListener(this);
    }

    private void initialize() {
        this.setName("POAFrame");
        this.setLayout(new BorderLayout());
        this.setSize(698, 310);
        this.setTitle("POA Monitor");
        this.add((Component)this.getContentsPane(), "Center");
        this.initConnections();
        this.getButtonPanel()._init(this, "Close");
        this.getPOAStatePanel()._getAOMPanel()._init(this);
        this.getPOAStatePanel()._getQueuePanel()._init(this);
    }

    public void _initQueueBar(int n, boolean bl) {
        this._getQueueBar().init(0, 0, n, queueBarColor, null, false, bl);
    }

    public void _initThreadPoolBar(int n) {
        this._getThreadPoolBar().init(0, 0, n, threadPoolBarColor, null, false, false);
    }

    public void _inspectRequest(String string) {
        new MessageDialog((Frame)this, "Message", "This function is not yet implemented!").setVisible(true);
    }

    public void _inspectServantClass(String string) {
        new MessageDialog((Frame)this, "Message", "This function is not yet implemented!").setVisible(true);
    }

    public POAFrame(POAMonitorController pOAMonitorController) {
        this.controller = pOAMonitorController;
        this.initialize();
    }

    public POAFrame(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        try {
            POAFrame pOAFrame = new POAFrame();
            try {
                Class<?> clazz = Class.forName("com.ibm.uvm.abt.edit.WindowCloser");
                Class[] classArray = new Class[]{class$java$awt$Window == null ? (class$java$awt$Window = POAFrame.class$("java.awt.Window")) : class$java$awt$Window};
                Object[] objectArray = new Object[]{pOAFrame};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                constructor.newInstance(objectArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            pOAFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of java.awt.Frame");
            throwable.printStackTrace(System.out);
        }
    }

    public void _printMessage(String string) {
        this.getConsolePanel()._printMessage(string);
    }

    public void _removeRequest(String string) {
        if (this.controller != null) {
            this.controller.actionRemoveRequestFromQueue(string);
        }
    }

    public void _setMaxThreadPoolBar(int n) {
        this._getThreadPoolBar().setMaxValue(n);
    }

    public void _setName(String string) {
        this.poaName = string;
        this.setTitle(this.poaName + " Monitor (" + this._getStateLabel().getText() + ")");
    }

    public void _setPolicyIdAssignment(String string) {
        this._getIdAssignmentLabel().setText(" " + string);
    }

    public void _setPolicyIdUniqueness(String string) {
        this._getIdUniquenessLabel().setText(" " + string);
    }

    public void _setPolicyImplicitActivation(String string) {
        this._getImplicitActivationLabel().setText(" " + string);
    }

    public void _setPolicyLifespan(String string) {
        this._getLifespanLabel().setText(" " + string);
    }

    public void _setPolicyRequestProcessing(String string) {
        this._getRequestProcessingLabel().setText(" " + string);
    }

    public void _setPolicyServantRetention(String string) {
        this._getServantRetentionLabel().setText(" " + string);
    }

    public void _setPolicyThread(String string) {
        this._getThreadLabel().setText(" " + string);
    }

    public void _setState(String string) {
        this._getStateLabel().setText(string);
        this.setTitle(this.poaName + " Monitor (" + string + ")");
    }

    public void _setValueActiveRequestsBar(int n) {
        this._getActiveRequestsBar().setCurrentValue(n);
    }

    public void _setValueAOMBar(int n) {
        this._getAOMBar().setCurrentValue(n);
    }

    public void _setValueQueueBar(int n) {
        this._getQueueBar().setCurrentValue(n);
    }

    public void _setValueThreadPoolBar(int n) {
        this._getThreadPoolBar().setCurrentValue(n);
    }

    public void _setVisible(boolean bl) {
        this.setVisible(bl);
    }

    private void _showAOMDialog() {
        if (this.controller == null) {
            return;
        }
        StringPair[] stringPairArray = this.controller.actionRetrieveAOMContent();
        DoubleListDialog doubleListDialog = new DoubleListDialog((Frame)this, "Active Object Map Snapshot");
        doubleListDialog._setHeaderLabel1("Object ID");
        doubleListDialog._setHeaderLabel2("Servant Class");
        if (stringPairArray != null) {
            int n;
            ObjectListItem[] objectListItemArray = new ObjectListItem[stringPairArray.length];
            int n2 = 100;
            int n3 = 100;
            for (n = 0; n < stringPairArray.length; ++n) {
                objectListItemArray[n] = new ObjectListItem();
                objectListItemArray[n]._init(this, stringPairArray[n].first);
                String string = POAUtil.convert(stringPairArray[n].first.getBytes());
                objectListItemArray[n]._getFirstLabel().setText(string);
                objectListItemArray[n]._getSecondLabel().setText(stringPairArray[n].second);
                int n4 = this._fontMetrics1().stringWidth(objectListItemArray[n]._getFirstLabel().getText());
                if (n4 > n2) {
                    n2 = n4;
                }
                if ((n4 = this._fontMetrics1().stringWidth(objectListItemArray[n]._getSecondLabel().getText())) <= n3) continue;
                n3 = n4;
            }
            doubleListDialog._setSize(n2 + 20, n3 + 20);
            for (n = 0; n < stringPairArray.length; ++n) {
                objectListItemArray[n]._setWidth(n2 + 20, n3 + 20);
                doubleListDialog._addItem(objectListItemArray[n]);
            }
        }
        doubleListDialog.setVisible(true);
    }

    private void _showQueueDialog() {
        if (this.controller == null) {
            return;
        }
        StringPair[] stringPairArray = this.controller.actionRetrieveQueueContent();
        DoubleListDialog doubleListDialog = new DoubleListDialog((Frame)this, "Queue Snapshot");
        doubleListDialog._setHeaderLabel1("Request ID");
        doubleListDialog._setHeaderLabel2("Object ID");
        if (stringPairArray != null) {
            int n;
            QueueListItem[] queueListItemArray = new QueueListItem[stringPairArray.length];
            int n2 = 100;
            int n3 = 100;
            for (n = 0; n < stringPairArray.length; ++n) {
                queueListItemArray[n] = new QueueListItem();
                queueListItemArray[n]._init(this, stringPairArray[n].first);
                queueListItemArray[n]._getFirstLabel().setText(stringPairArray[n].first);
                String string = POAUtil.convert(stringPairArray[n].second.getBytes());
                queueListItemArray[n]._getSecondLabel().setText(string);
                int n4 = this._fontMetrics1().stringWidth(queueListItemArray[n]._getFirstLabel().getText());
                if (n4 > n2) {
                    n2 = n4;
                }
                if ((n4 = this._fontMetrics1().stringWidth(queueListItemArray[n]._getSecondLabel().getText())) <= n3) continue;
                n3 = n4;
            }
            doubleListDialog._setSize(n2 + 20, n3 + 20);
            for (n = 0; n < stringPairArray.length; ++n) {
                queueListItemArray[n]._setWidth(n2 + 20, n3 + 20);
                doubleListDialog._addItem(queueListItemArray[n]);
            }
        }
        doubleListDialog.setVisible(true);
    }

    public POAFrame() {
        this.initialize();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.connEtoC1(windowEvent);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

