/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.EventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;

public abstract class AbstractBoundedEventQueue
implements EventQueue {
    private Object lock_ = new Object();
    private int capacity_;
    private EventQueueOverflowStrategy overflowStrategy_;

    protected AbstractBoundedEventQueue(int n, EventQueueOverflowStrategy eventQueueOverflowStrategy) {
        this.capacity_ = n;
        this.overflowStrategy_ = eventQueueOverflowStrategy;
    }

    protected AbstractBoundedEventQueue(int n) {
        this.capacity_ = n;
    }

    void setOverflowStrategy(EventQueueOverflowStrategy eventQueueOverflowStrategy) {
        this.overflowStrategy_ = eventQueueOverflowStrategy;
    }

    protected abstract Message getEarliestTimeout();

    protected abstract Message getLeastPriority();

    protected abstract Message getNextElement();

    protected abstract Message getOldestElement();

    protected abstract Message getYoungestElement();

    protected abstract Message[] getElements(int var1);

    protected abstract void addElement(Message var1);

    protected abstract Message[] getAllElements();

    private void fireEventDiscarded(Message message) {
    }

    public Message[] getAllEvents(boolean bl) throws InterruptedException {
        if (bl) {
            return this.getAllBlocking();
        }
        return this.getAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message[] getAllBlocking() throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.isEmpty()) {
                this.lock_.wait();
            }
            return this.getAllElements();
        }
    }

    public Message getEvent(boolean bl) throws InterruptedException {
        if (bl) {
            return this.getEventBlocking();
        }
        if (this.isEmpty()) {
            return null;
        }
        return this.getNextElement();
    }

    public Message[] getEvents(int n, boolean bl) throws InterruptedException {
        if (bl) {
            return this.getEventsBlocking(n);
        }
        return this.getElements(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message[] getEventsBlocking(int n) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.isEmpty()) {
                this.lock_.wait();
            }
            return this.getElements(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getEventBlocking() throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.isEmpty()) {
                this.lock_.wait();
            }
            return this.getOldestElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Message message) {
        Object object = this.lock_;
        synchronized (object) {
            while (this.getSize() >= this.capacity_) {
                Message message2 = this.overflowStrategy_.removeElementFromQueue(this);
                this.fireEventDiscarded(message2);
            }
            this.addElement(message);
            this.lock_.notifyAll();
        }
    }
}

