/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.ConstraintEntry;
import org.jacorb.notification.EventTypeIdentifier;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.filter.DynamicEvaluator;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.FilterConstraint;
import org.jacorb.notification.filter.FilterUtils;
import org.jacorb.notification.filter.PropertyDoesNotExistException;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.CachingWildcardMap;
import org.jacorb.notification.util.WildcardMap;
import org.omg.CORBA.Any;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterPOA;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public abstract class AbstractFilter
extends FilterPOA
implements Disposable,
ManageableServant,
Configurable {
    static final RuntimeException NOT_SUPPORTED = new UnsupportedOperationException("this operation is not implemented yet");
    public static final int NO_CONSTRAINTS_MATCH = -2;
    public static final int CONSTRAINTS_EMPTY = -1;
    private static final String EMPTY_EVENT_TYPE_CONSTRAINT_KEY = FilterUtils.calcConstraintKey("*", "*");
    protected Map callbacks_;
    protected Map constraints_;
    protected WildcardMap wildcardMap_;
    protected ReadWriteLock constraintsLock_;
    private Runnable disposeHook_;
    private String constraintGrammar_;
    private SynchronizedInt constraintIdPool_ = new SynchronizedInt(0);
    protected DynamicEvaluator dynamicEvaluator_;
    protected DynAnyFactory dynAnyFactory_;
    protected MessageFactory messageFactory_;
    private long matchCalled_ = 0L;
    private long matchStructuredCalled_ = 0L;
    private POA poa_;
    private ORB orb_;
    private Filter thisRef_;
    private ApplicationContext applicationContext_;
    private static Logger logger_ = null;
    private org.jacorb.config.Configuration config_ = null;

    public AbstractFilter(ApplicationContext applicationContext, String string) {
        this.constraintGrammar_ = string;
        this.applicationContext_ = applicationContext;
        this.messageFactory_ = applicationContext.getMessageFactory();
        this.dynAnyFactory_ = applicationContext.getDynAnyFactory();
        this.dynamicEvaluator_ = applicationContext.getDynamicEvaluator();
        this.constraints_ = new HashMap();
        this.constraintsLock_ = new WriterPreferenceReadWriteLock();
        this.wildcardMap_ = new CachingWildcardMap(4);
    }

    public void configure(Configuration configuration) {
        this.config_ = (org.jacorb.config.Configuration)configuration;
        logger_ = this.config_.getNamedLogger(this.getClass().getName());
        if (logger_.isInfoEnabled()) {
            logger_.info("Created filter for Grammar: " + this.constraintGrammar_);
        }
    }

    public void setORB(ORB oRB) {
        this.orb_ = oRB;
    }

    public void setPOA(POA pOA) {
        this.poa_ = pOA;
    }

    public void preActivate() {
    }

    public Object activate() {
        if (this.thisRef_ == null) {
            this.thisRef_ = this._this(this.orb_);
        }
        return this.thisRef_;
    }

    public void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this));
        }
        catch (WrongPolicy wrongPolicy) {
            logger_.fatalError("error deactivating object", (Throwable)wrongPolicy);
        }
        catch (ObjectNotActive objectNotActive) {
            logger_.fatalError("error deactivating object", (Throwable)objectNotActive);
        }
        catch (ServantNotActive servantNotActive) {
            logger_.fatalError("error deactivating object", (Throwable)servantNotActive);
        }
    }

    protected int getConstraintId() {
        return this.constraintIdPool_.increment();
    }

    public String constraint_grammar() {
        return this.constraintGrammar_;
    }

    private void addConstraintEntryToWildcardMap(String string, ConstraintEntry constraintEntry) {
        LinkedList<ConstraintEntry> linkedList = (LinkedList<ConstraintEntry>)this.wildcardMap_.getNoExpansion(string);
        if (linkedList == null) {
            linkedList = new LinkedList<ConstraintEntry>();
            this.wildcardMap_.put(string, linkedList);
        }
        linkedList.add(constraintEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] add_constraints(ConstraintExp[] constraintExpArray) throws InvalidConstraint {
        ConstraintInfo[] constraintInfoArray;
        FilterConstraint[] filterConstraintArray = new FilterConstraint[constraintExpArray.length];
        for (int i = 0; i < constraintExpArray.length; ++i) {
            filterConstraintArray[i] = this.newFilterConstraint(constraintExpArray[i]);
        }
        ConstraintInfo[] constraintInfoArray2 = new ConstraintInfo[constraintExpArray.length];
        this.constraintsLock_.writeLock().acquire();
        try {
            for (int i = 0; i < constraintExpArray.length; ++i) {
                int n = this.getConstraintId();
                constraintInfoArray2[i] = new ConstraintInfo(constraintExpArray[i], n);
                ConstraintEntry constraintEntry = new ConstraintEntry(n, filterConstraintArray[i], constraintInfoArray2[i]);
                int n2 = constraintEntry.getEventTypeCount();
                if (n2 == 0) {
                    this.addConstraintEntryToWildcardMap(EMPTY_EVENT_TYPE_CONSTRAINT_KEY, constraintEntry);
                } else {
                    for (int j = 0; j < n2; ++j) {
                        EventTypeIdentifier eventTypeIdentifier = constraintEntry.getEventTypeIdentifier(j);
                        this.addConstraintEntryToWildcardMap(eventTypeIdentifier.getConstraintKey(), constraintEntry);
                    }
                }
                this.constraints_.put(new Integer(n), constraintEntry);
            }
            constraintInfoArray = constraintInfoArray2;
        }
        catch (Throwable throwable) {
            try {
                this.constraintsLock_.writeLock().release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        this.constraintsLock_.writeLock().release();
        return constraintInfoArray;
    }

    protected abstract FilterConstraint newFilterConstraint(ConstraintExp var1) throws InvalidConstraint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify_constraints(int[] nArray, ConstraintInfo[] constraintInfoArray) throws ConstraintNotFound, InvalidConstraint {
        try {
            this.constraintsLock_.writeLock().acquire();
            try {
                List list;
                EventTypeIdentifier eventTypeIdentifier;
                int n;
                int n2;
                int n3;
                Integer[] integerArray = new Integer[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    integerArray[i] = new Integer(nArray[i]);
                    if (this.constraints_.containsKey(integerArray[i])) continue;
                    throw new ConstraintNotFound(nArray[i]);
                }
                Integer[] integerArray2 = new Integer[constraintInfoArray.length];
                FilterConstraint[] filterConstraintArray = new FilterConstraint[constraintInfoArray.length];
                for (n3 = 0; n3 < constraintInfoArray.length; ++n3) {
                    integerArray2[n3] = new Integer(constraintInfoArray[n3].constraint_id);
                    if (!this.constraints_.containsKey(integerArray2[n3])) {
                        throw new ConstraintNotFound(constraintInfoArray[n3].constraint_id);
                    }
                    filterConstraintArray[n3] = this.newFilterConstraint(constraintInfoArray[n3].constraint_expression);
                    int n4 = constraintInfoArray[n3].constraint_expression.event_types.length;
                }
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    ConstraintEntry constraintEntry = (ConstraintEntry)this.constraints_.remove(integerArray[n3]);
                    n2 = constraintEntry.getEventTypeCount();
                    block8: for (n = 0; n < n2; ++n) {
                        eventTypeIdentifier = constraintEntry.getEventTypeIdentifier(n);
                        list = (List)this.wildcardMap_.getNoExpansion(eventTypeIdentifier.getConstraintKey());
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ConstraintEntry constraintEntry2 = (ConstraintEntry)iterator.next();
                            if (constraintEntry2.getConstraintId() != integerArray[n3].intValue()) continue;
                            iterator.remove();
                            continue block8;
                        }
                    }
                }
                for (n3 = 0; n3 < constraintInfoArray.length; ++n3) {
                    ConstraintEntry constraintEntry = new ConstraintEntry(integerArray2[n3], filterConstraintArray[n3], constraintInfoArray[n3]);
                    this.constraints_.put(integerArray2[n3], constraintEntry);
                    n2 = constraintEntry.getEventTypeCount();
                    for (n = 0; n < n2; ++n) {
                        eventTypeIdentifier = constraintEntry.getEventTypeIdentifier(n);
                        list = (List)this.wildcardMap_.getNoExpansion(eventTypeIdentifier.getConstraintKey());
                        list.add(constraintEntry);
                    }
                }
                return;
            }
            finally {
                this.constraintsLock_.writeLock().release();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] get_constraints(int[] nArray) throws ConstraintNotFound {
        ConstraintInfo[] constraintInfoArray;
        ConstraintInfo[] constraintInfoArray2 = new ConstraintInfo[nArray.length];
        Sync sync = this.constraintsLock_.readLock();
        sync.acquire();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                Integer n = new Integer(nArray[i]);
                if (!this.constraints_.containsKey(n)) {
                    throw new ConstraintNotFound(nArray[i]);
                }
                constraintInfoArray2[i] = ((ConstraintEntry)this.constraints_.get(n)).getConstraintInfo();
            }
            constraintInfoArray = constraintInfoArray2;
        }
        catch (Throwable throwable) {
            try {
                sync.release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        sync.release();
        return constraintInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] get_all_constraints() {
        ConstraintInfo[] constraintInfoArray;
        this.constraintsLock_.readLock().acquire();
        try {
            ConstraintInfo[] constraintInfoArray2 = new ConstraintInfo[this.constraints_.size()];
            Iterator iterator = this.constraints_.values().iterator();
            int n = -1;
            while (iterator.hasNext()) {
                constraintInfoArray2[++n] = ((ConstraintEntry)iterator.next()).getConstraintInfo();
            }
            constraintInfoArray = constraintInfoArray2;
        }
        catch (Throwable throwable) {
            try {
                this.constraintsLock_.readLock().release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        this.constraintsLock_.readLock().release();
        return constraintInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_all_constraints() {
        try {
            this.constraintsLock_.writeLock().acquire();
            try {
                this.constraints_.clear();
                this.wildcardMap_.clear();
                return;
            }
            finally {
                this.constraintsLock_.writeLock().release();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public void destroy() {
        this.dispose();
    }

    Iterator getConstraintsForEvent(Message message) {
        String string = message.getConstraintKey();
        return this.getIterator(string);
    }

    public Iterator getIterator(java.lang.Object object) {
        java.lang.Object[] objectArray = this.wildcardMap_.getWithExpansion(object);
        return new ConstraintIterator(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int match(EvaluationContext evaluationContext, Message message) throws UnsupportedFilterableData {
        try {
            this.constraintsLock_.readLock().acquire();
            try {
                if (this.constraints_.isEmpty()) {
                    logger_.info("Filter has no Expressions");
                    int n = -1;
                    return n;
                }
                Iterator iterator = this.getConstraintsForEvent(message);
                while (iterator.hasNext()) {
                    ConstraintEntry constraintEntry = (ConstraintEntry)iterator.next();
                    try {
                        boolean bl = constraintEntry.getFilterConstraint().evaluate(evaluationContext, message).getBool();
                        if (!bl) continue;
                        int n = constraintEntry.getConstraintId();
                        return n;
                    }
                    catch (PropertyDoesNotExistException propertyDoesNotExistException) {
                        logger_.debug("tried to access non existing Property", (Throwable)propertyDoesNotExistException);
                    }
                    catch (EvaluationException evaluationException) {
                        logger_.fatalError("Error evaluating filter", (Throwable)evaluationException);
                        throw new UnsupportedFilterableData(evaluationException.getMessage());
                    }
                }
                int n = -2;
                return n;
            }
            finally {
                this.constraintsLock_.readLock().release();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return -2;
        }
    }

    public boolean match(Any any) throws UnsupportedFilterableData {
        ++this.matchCalled_;
        return this.match_internal(any) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_internal(Any any) throws UnsupportedFilterableData {
        int n;
        EvaluationContext evaluationContext = null;
        Disposable disposable = null;
        try {
            evaluationContext = this.applicationContext_.newEvaluationContext();
            disposable = this.messageFactory_.newMessage(any);
            n = this.match(evaluationContext, (Message)disposable);
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            try {
                disposable.dispose();
            }
            catch (Exception exception) {
                logger_.fatalError("Error disposing event", (Throwable)exception);
            }
            try {
                evaluationContext.dispose();
            }
            catch (Exception exception) {
                logger_.fatalError("Error disposing EvaluationContext", (Throwable)exception);
            }
            throw throwable;
        }
        try {
            disposable.dispose();
        }
        catch (Exception exception) {
            logger_.fatalError("Error disposing event", (Throwable)exception);
        }
        try {
            evaluationContext.dispose();
        }
        catch (Exception exception) {
            logger_.fatalError("Error disposing EvaluationContext", (Throwable)exception);
        }
        return n;
    }

    public boolean match_structured(StructuredEvent structuredEvent) throws UnsupportedFilterableData {
        ++this.matchStructuredCalled_;
        return this.match_structured_internal(structuredEvent) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_structured_internal(StructuredEvent structuredEvent) throws UnsupportedFilterableData {
        int n;
        EvaluationContext evaluationContext = null;
        Disposable disposable = null;
        try {
            evaluationContext = this.applicationContext_.newEvaluationContext();
            disposable = this.messageFactory_.newMessage(structuredEvent);
            n = this.match(evaluationContext, (Message)disposable);
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            try {
                disposable.dispose();
            }
            catch (Exception exception) {
                logger_.fatalError("Error disposing event", (Throwable)exception);
            }
            try {
                evaluationContext.dispose();
            }
            catch (Exception exception) {
                logger_.fatalError("Error releasing EvaluationContext", (Throwable)exception);
            }
            throw throwable;
        }
        try {
            disposable.dispose();
        }
        catch (Exception exception) {
            logger_.fatalError("Error disposing event", (Throwable)exception);
        }
        try {
            evaluationContext.dispose();
        }
        catch (Exception exception) {
            logger_.fatalError("Error releasing EvaluationContext", (Throwable)exception);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_typed_internal(Property[] propertyArray) throws UnsupportedFilterableData {
        int n;
        EvaluationContext evaluationContext = null;
        Disposable disposable = null;
        try {
            evaluationContext = this.applicationContext_.newEvaluationContext();
            disposable = this.messageFactory_.newMessage(propertyArray);
            n = this.match(evaluationContext, (Message)disposable);
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            try {
                disposable.dispose();
            }
            catch (Exception exception) {
                logger_.fatalError("Error disposing event", (Throwable)exception);
            }
            try {
                evaluationContext.dispose();
            }
            catch (Exception exception) {
                logger_.fatalError("Error releasing EvaluationContext", (Throwable)exception);
            }
            throw throwable;
        }
        try {
            disposable.dispose();
        }
        catch (Exception exception) {
            logger_.fatalError("Error disposing event", (Throwable)exception);
        }
        try {
            evaluationContext.dispose();
        }
        catch (Exception exception) {
            logger_.fatalError("Error releasing EvaluationContext", (Throwable)exception);
        }
        return n;
    }

    public boolean match_typed(Property[] propertyArray) throws UnsupportedFilterableData {
        return this.match_typed_internal(propertyArray) >= 0;
    }

    public int attach_callback(NotifySubscribe notifySubscribe) {
        throw new NO_IMPLEMENT();
    }

    public void detach_callback(int n) {
        throw new NO_IMPLEMENT();
    }

    public int[] get_callbacks() {
        throw new NO_IMPLEMENT();
    }

    public POA _default_POA() {
        return this.applicationContext_.getPoa();
    }

    public void dispose() {
        this.deactivate();
        if (this.disposeHook_ != null) {
            this.disposeHook_.run();
        }
    }

    public void setDisposeHook(Runnable runnable) {
        this.disposeHook_ = runnable;
    }

    private static class ConstraintIterator
    implements Iterator {
        java.lang.Object[] arrayOfLists_;
        Iterator current_;
        int currentListIdx_ = 0;

        ConstraintIterator(java.lang.Object[] objectArray) {
            this.arrayOfLists_ = objectArray;
            if (logger_ != null && logger_.isDebugEnabled()) {
                for (int i = 0; i < this.arrayOfLists_.length; ++i) {
                    logger_.debug(i + ": " + this.arrayOfLists_[i]);
                }
            }
            this.current_ = this.arrayOfLists_.length == 0 ? null : ((List)this.arrayOfLists_[this.currentListIdx_]).iterator();
        }

        public boolean hasNext() {
            return this.current_ != null && this.current_.hasNext();
        }

        public java.lang.Object next() {
            if (this.current_ == null) {
                throw new NoSuchElementException();
            }
            java.lang.Object e = this.current_.next();
            if (!this.current_.hasNext() && this.currentListIdx_ < this.arrayOfLists_.length - 1) {
                this.current_ = ((List)this.arrayOfLists_[++this.currentListIdx_]).iterator();
            }
            return e;
        }

        public void remove() {
            throw NOT_SUPPORTED;
        }
    }
}

