/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.concurrency;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.concurrency.LockSetFactoryImpl;
import org.jacorb.concurrency.Request;
import org.jacorb.concurrency.TransactionCoordinator;
import org.jacorb.concurrency.TransactionLocks;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosConcurrencyControl.LockCoordinator;
import org.omg.CosConcurrencyControl.LockNotHeld;
import org.omg.CosConcurrencyControl.TransactionalLockSet;
import org.omg.CosConcurrencyControl.TransactionalLockSetPOA;
import org.omg.CosConcurrencyControl.lock_mode;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Status;

class TransactionalLockSetImpl
extends TransactionalLockSetPOA {
    private Hashtable locks = new Hashtable();
    private Vector queue = new Vector();
    private Vector related = new Vector();
    private LockSetFactoryImpl factory;
    private boolean is_active = true;

    TransactionalLockSetImpl(LockSetFactoryImpl lockSetFactoryImpl) {
        this.factory = lockSetFactoryImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Coordinator coordinator, lock_mode lock_mode2) {
        Vector vector = this.queue;
        synchronized (vector) {
            this.check_active();
            TransactionCoordinator transactionCoordinator = this.factory.get_transaction_coordinator(coordinator);
            Request request = null;
            TransactionCoordinator transactionCoordinator2 = transactionCoordinator;
            synchronized (transactionCoordinator2) {
                this.check_status(transactionCoordinator);
                if (this.attempt_lock(transactionCoordinator, lock_mode2)) {
                    return;
                }
                request = new Request();
                request.state = 1;
                request.current = transactionCoordinator;
                request.to_do = 1;
                request.set_mode = lock_mode2;
                request.reset_mode = null;
                this.queue.addElement(request);
                transactionCoordinator.set_lock_coordinator(this);
            }
            while (request.state == 1) {
                try {
                    this.queue.wait();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    throw new INTERNAL();
                }
            }
            switch (request.state) {
                case 3: 
                case 5: {
                    throw new INVALID_TRANSACTION();
                }
                case 4: {
                    throw new TRANSACTION_ROLLEDBACK();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean try_lock(Coordinator coordinator, lock_mode lock_mode2) {
        Vector vector = this.queue;
        synchronized (vector) {
            TransactionCoordinator transactionCoordinator;
            this.check_active();
            TransactionCoordinator transactionCoordinator2 = transactionCoordinator = this.factory.get_transaction_coordinator(coordinator);
            synchronized (transactionCoordinator2) {
                this.check_status(transactionCoordinator);
                return this.attempt_lock(transactionCoordinator, lock_mode2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Coordinator coordinator, lock_mode lock_mode2) throws LockNotHeld {
        Vector vector = this.queue;
        synchronized (vector) {
            TransactionCoordinator transactionCoordinator;
            this.check_active();
            TransactionCoordinator transactionCoordinator2 = transactionCoordinator = this.factory.get_transaction_coordinator(coordinator);
            synchronized (transactionCoordinator2) {
                this.check_status(transactionCoordinator);
                TransactionLocks transactionLocks = (TransactionLocks)this.locks.get(transactionCoordinator);
                if (transactionLocks == null) {
                    throw new LockNotHeld();
                }
                transactionLocks.unlock(lock_mode2);
            }
            if (this.attempt_lock_from_queue()) {
                this.queue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change_mode(Coordinator coordinator, lock_mode lock_mode2, lock_mode lock_mode3) throws LockNotHeld {
        Vector vector = this.queue;
        synchronized (vector) {
            this.check_active();
            TransactionCoordinator transactionCoordinator = this.factory.get_transaction_coordinator(coordinator);
            Request request = null;
            TransactionCoordinator transactionCoordinator2 = transactionCoordinator;
            synchronized (transactionCoordinator2) {
                this.check_status(transactionCoordinator);
                if (this.attempt_change(transactionCoordinator, lock_mode3, lock_mode2)) {
                    return;
                }
                request = new Request();
                request.state = 1;
                request.current = transactionCoordinator;
                request.to_do = 3;
                request.set_mode = lock_mode3;
                request.reset_mode = lock_mode2;
                this.queue.addElement(request);
                transactionCoordinator.get_lock_coordinator(this);
            }
            while (request.state == 1) {
                try {
                    this.queue.wait();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    throw new INTERNAL();
                }
            }
            switch (request.state) {
                case 3: 
                case 5: {
                    throw new INVALID_TRANSACTION();
                }
                case 4: {
                    throw new TRANSACTION_ROLLEDBACK();
                }
                case 6: {
                    throw new LockNotHeld();
                }
            }
            if (this.attempt_lock_from_queue()) {
                this.queue.notifyAll();
            }
        }
    }

    public LockCoordinator get_coordinator(Coordinator coordinator) {
        TransactionCoordinator transactionCoordinator = this.factory.get_transaction_coordinator(coordinator);
        return transactionCoordinator.get_lock_coordinator(this);
    }

    synchronized void add_related(TransactionalLockSet transactionalLockSet) {
        this.related.addElement(transactionalLockSet);
    }

    synchronized boolean attempt_lock(TransactionCoordinator transactionCoordinator, lock_mode lock_mode2) {
        Enumeration enumeration = this.locks.elements();
        TransactionLocks transactionLocks = null;
        while (enumeration.hasMoreElements()) {
            TransactionLocks transactionLocks2 = (TransactionLocks)enumeration.nextElement();
            if (transactionLocks2.current == transactionCoordinator) {
                transactionLocks = transactionLocks2;
                continue;
            }
            if (transactionLocks2.no_conflict(lock_mode2)) continue;
            return false;
        }
        if (transactionLocks == null) {
            transactionLocks = new TransactionLocks(transactionCoordinator);
            transactionCoordinator.get_lock_coordinator(this);
            this.locks.put(transactionCoordinator, transactionLocks);
        }
        transactionLocks.lock(lock_mode2);
        return true;
    }

    private void check_status(TransactionCoordinator transactionCoordinator) {
        Status status = transactionCoordinator.get_state();
        if (status.equals(Status.StatusActive)) {
            return;
        }
        if (status.equals(Status.StatusPrepared) || status.equals(Status.StatusCommitted) || status.equals(Status.StatusUnknown) || status.equals(Status.StatusNoTransaction) || status.equals(Status.StatusPreparing) || status.equals(Status.StatusCommitting)) {
            throw new INVALID_TRANSACTION();
        }
        if (status.equals(Status.StatusRollingBack) || status.equals(Status.StatusMarkedRollback) || status.equals(Status.StatusRolledBack)) {
            throw new TRANSACTION_ROLLEDBACK();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean attempt_lock_from_queue() {
        boolean bl = false;
        boolean bl2 = false;
        Vector<Request> vector = new Vector<Request>();
        Enumeration enumeration = this.queue.elements();
        block12: while (enumeration.hasMoreElements()) {
            Request request = (Request)enumeration.nextElement();
            TransactionCoordinator transactionCoordinator = request.current;
            synchronized (transactionCoordinator) {
                try {
                    this.check_status(request.current);
                }
                catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
                    request.state = 5;
                    vector.addElement(request);
                    bl = true;
                    continue;
                }
                catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
                    request.state = 4;
                    vector.addElement(request);
                    bl = true;
                    continue;
                }
                switch (request.to_do) {
                    case 1: {
                        if (!this.attempt_lock(request.current, request.set_mode)) {
                            continue block12;
                        }
                        request.state = 2;
                        break;
                    }
                    case 3: {
                        try {
                            if (!this.attempt_change(request.current, request.set_mode, request.reset_mode)) {
                                continue block12;
                            }
                            request.state = 2;
                            bl2 = true;
                            break;
                        }
                        catch (LockNotHeld lockNotHeld) {
                            request.state = 6;
                        }
                    }
                }
                vector.addElement(request);
                bl = true;
            }
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.queue.removeElement(enumeration.nextElement());
        }
        if (bl2) {
            this.attempt_lock_from_queue();
        }
        return vector.size() > 0;
    }

    private synchronized boolean attempt_change(TransactionCoordinator transactionCoordinator, lock_mode lock_mode2, lock_mode lock_mode3) throws LockNotHeld {
        TransactionLocks transactionLocks = (TransactionLocks)this.locks.get(transactionCoordinator);
        if (transactionLocks == null || !transactionLocks.is_held(lock_mode3)) {
            throw new LockNotHeld();
        }
        if (this.attempt_lock(transactionCoordinator, lock_mode2)) {
            transactionLocks.unlock(lock_mode3);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void transaction_finished(TransactionCoordinator transactionCoordinator) {
        Enumeration enumeration;
        Vector<Request> vector = new Vector<Request>();
        boolean bl = false;
        Serializable serializable = this.queue;
        synchronized (serializable) {
            enumeration = this.queue.elements();
            while (enumeration.hasMoreElements()) {
                Request request = (Request)enumeration.nextElement();
                if (request.current != transactionCoordinator) continue;
                request.state = 4;
                vector.addElement(request);
            }
            if (vector.size() > 0) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.queue.removeElement(enumeration.nextElement());
                }
                bl = true;
            }
            if (this.locks.remove(transactionCoordinator) != null) {
                boolean bl2 = bl = this.attempt_lock_from_queue() ? true : bl;
            }
            if (bl) {
                this.queue.notifyAll();
            }
        }
        if (this.related.size() > 0) {
            enumeration = this.related.elements();
            while (enumeration.hasMoreElements()) {
                serializable = (TransactionalLockSet)enumeration.nextElement();
                serializable.get_coordinator(transactionCoordinator.get_coordinator()).drop_locks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        System.out.println("\n=============================================================================");
        System.out.println(" LOCKS" + this.locks.size());
        System.out.println("-----------------------------------------------------------------------------");
        Vector vector = this.queue;
        synchronized (vector) {
            Object object;
            Enumeration<Object> enumeration = this.locks.elements();
            while (enumeration.hasMoreElements()) {
                object = (TransactionLocks)enumeration.nextElement();
                System.out.println(((TransactionLocks)object).toString());
            }
            System.out.println("\n-----------------------------------------------------------------------------");
            System.out.println(" QUEUE" + this.queue.size());
            System.out.println("-----------------------------------------------------------------------------");
            enumeration = this.queue.elements();
            while (enumeration.hasMoreElements()) {
                object = (Request)enumeration.nextElement();
                System.out.println(((Request)object).toString());
            }
        }
        System.out.println("=============================================================================\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Vector vector = this.queue;
        synchronized (vector) {
            this.check_active();
            this.is_active = false;
            if (this.locks.size() > 0) {
                Enumeration enumeration = this.locks.elements();
                while (enumeration.hasMoreElements()) {
                    TransactionLocks transactionLocks = (TransactionLocks)enumeration.nextElement();
                    if (!transactionLocks.any_locks()) continue;
                    throw new RuntimeException("LockExists");
                }
            }
            this.factory.remove_me(this);
        }
    }

    private void check_active() {
        if (!this.is_active) {
            throw new OBJECT_NOT_EXIST();
        }
    }
}

