/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.system.InterceptorServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public abstract class InterceptorServiceMBeanSupport
extends ServiceMBeanSupport
implements InterceptorServiceMBean {
    private List interceptables;
    private Interceptor interceptor;

    public InterceptorServiceMBeanSupport() {
    }

    public InterceptorServiceMBeanSupport(Class type) {
        super(type);
    }

    public InterceptorServiceMBeanSupport(String category) {
        super(category);
    }

    public InterceptorServiceMBeanSupport(Logger log) {
        super(log);
    }

    public void setInterceptables(List interceptables) {
        if (interceptables != null) {
            this.interceptables = new ArrayList(interceptables);
        }
    }

    public List getInterceptables() {
        if (this.interceptables != null) {
            return new ArrayList(this.interceptables);
        }
        return null;
    }

    protected void attach() throws Exception {
        if (this.interceptor == null) {
            this.attach((Interceptor)new XMBeanInterceptor());
        }
    }

    protected void attach(Interceptor interceptor) throws Exception {
        if (interceptor == null) {
            throw new IllegalArgumentException("Null interceptor");
        }
        if (this.interceptor != null) {
            throw new IllegalStateException("Interceptor already attached");
        }
        this.log.debug((Object)("Attaching interceptor: " + interceptor.getName()));
        this.interceptor = interceptor;
        if (this.interceptables != null) {
            Object[] params = new Object[]{interceptor};
            String[] signature = new String[]{Interceptor.class.getName()};
            Iterator i = this.interceptables.iterator();
            while (i.hasNext()) {
                ObjectName target = (ObjectName)i.next();
                this.server.invoke(target, "addOperationInterceptor", params, signature);
                this.log.debug((Object)("Interceptor attached to: '" + target + "'"));
            }
        }
    }

    protected void detach() {
        if (this.interceptor != null) {
            this.log.debug((Object)("Detaching interceptor: " + this.interceptor.getName()));
            if (this.interceptables != null) {
                Object[] params = new Object[]{this.interceptor};
                String[] signature = new String[]{Interceptor.class.getName()};
                Iterator i = this.interceptables.iterator();
                while (i.hasNext()) {
                    ObjectName target = (ObjectName)i.next();
                    try {
                        this.server.invoke(target, "removeOperationInterceptor", params, signature);
                        this.log.debug((Object)("Interceptor detached from: '" + target + "'"));
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("Caught exception while removing interceptor from '" + target + "'"), (Throwable)e);
                    }
                }
            }
            this.interceptor = null;
        }
    }

    protected Object invokeNext(Invocation invocation) throws Throwable {
        AbstractInterceptor next = invocation.nextInterceptor();
        if (next != null) {
            return next.invoke(invocation);
        }
        return invocation.dispatch();
    }

    protected void startService() throws Exception {
        this.attach();
    }

    protected void stopService() {
        this.detach();
    }

    protected Object invoke(Invocation invocation) throws Throwable {
        return this.invokeNext(invocation);
    }

    private class XMBeanInterceptor
    extends AbstractInterceptor {
        public XMBeanInterceptor() {
            super("XMBeanInterceptor('" + InterceptorServiceMBeanSupport.this.getServiceName() + "')");
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return InterceptorServiceMBeanSupport.this.invoke(invocation);
        }
    }
}

