/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.jboss.logging.Logger;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.LoginConfigObjectModelFactory;
import org.jboss.security.auth.login.PolicyConfig;
import org.jboss.security.auth.login.SunConfigParser;
import org.jboss.security.auth.spi.UsersObjectModelFactory;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class XMLLoginConfigImpl
extends Configuration {
    private static final String DEFAULT_APP_CONFIG_NAME = "other";
    private static final AuthPermission REFRESH_PERM = new AuthPermission("refreshLoginConfiguration");
    private static Logger log = Logger.getLogger((Class)XMLLoginConfigImpl.class);
    PolicyConfig appConfigs = new PolicyConfig();
    protected URL loginConfigURL;
    protected Configuration parentConfig;
    private boolean validateDTD = true;

    public void refresh() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Begin refresh");
        }
        this.appConfigs.clear();
        this.loadConfig();
        if (log.isTraceEnabled()) {
            log.trace((Object)"End refresh");
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Begin getAppConfigurationEntry(" + appName + "), size=" + this.appConfigs.size()));
        }
        if (this.loginConfigURL == null) {
            this.loadConfig();
        }
        AppConfigurationEntry[] entry = null;
        AuthenticationInfo authInfo = this.appConfigs.get(appName);
        if (authInfo == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("getAppConfigurationEntry(" + appName + "), no entry in appConfigs, tyring parentCont: " + this.parentConfig));
            }
            if (this.parentConfig != null) {
                entry = this.parentConfig.getAppConfigurationEntry(appName);
            }
            if (entry == null && log.isTraceEnabled()) {
                log.trace((Object)("getAppConfigurationEntry(" + appName + "), no entry in parentConfig, trying: " + DEFAULT_APP_CONFIG_NAME));
            }
            authInfo = this.appConfigs.get(DEFAULT_APP_CONFIG_NAME);
        }
        if (authInfo != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("End getAppConfigurationEntry(" + appName + "), authInfo=" + authInfo));
            }
            final AuthenticationInfo theAuthInfo = authInfo;
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    return theAuthInfo.copyAppConfigurationEntry();
                }
            };
            entry = (AppConfigurationEntry[])AccessController.doPrivileged(action);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("End getAppConfigurationEntry(" + appName + "), failed to find entry"));
        }
        return entry;
    }

    public URL getConfigURL() {
        return this.loginConfigURL;
    }

    public void setConfigURL(URL loginConfigURL) {
        this.loginConfigURL = loginConfigURL;
    }

    public void setConfigResource(String resourceName) throws IOException {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        this.loginConfigURL = tcl.getResource(resourceName);
        if (this.loginConfigURL == null) {
            throw new IOException("Failed to find resource: " + resourceName);
        }
    }

    public void setParentConfig(Configuration parentConfig) {
        this.parentConfig = parentConfig;
    }

    public boolean getValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateDTD(boolean flag) {
        this.validateDTD = flag;
    }

    public void addAppConfig(String appName, AppConfigurationEntry[] entries) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        AuthenticationInfo authInfo = new AuthenticationInfo(appName);
        authInfo.setAppConfigurationEntry(entries);
        if (log.isTraceEnabled()) {
            log.trace((Object)("addAppConfig(" + appName + "), authInfo=" + authInfo));
        }
        this.appConfigs.add(authInfo);
    }

    public void removeAppConfig(String appName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("removeAppConfig, appName=" + appName));
        }
        this.appConfigs.remove(appName);
    }

    public void clear() {
    }

    public void loadConfig() {
        String loginConfig = System.getProperty("java.security.auth.login.config");
        if (loginConfig == null) {
            loginConfig = "login-config.xml";
        }
        if (this.loginConfigURL == null) {
            try {
                this.loginConfigURL = new URL(loginConfig);
            }
            catch (MalformedURLException e) {
                try {
                    this.setConfigResource(loginConfig);
                }
                catch (IOException ignore) {
                    File configFile = new File(loginConfig);
                    try {
                        this.setConfigURL(configFile.toURL());
                    }
                    catch (MalformedURLException ignore2) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.loginConfigURL == null) {
            log.warn((Object)("Failed to find config: " + loginConfig));
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Begin loadConfig, loginConfigURL=" + this.loginConfigURL));
        }
        try {
            this.loadConfig(this.loginConfigURL);
            if (log.isTraceEnabled()) {
                log.trace((Object)("End loadConfig, loginConfigURL=" + this.loginConfigURL));
            }
        }
        catch (Exception e) {
            log.warn((Object)("End loadConfig, failed to load config: " + this.loginConfigURL), (Throwable)e);
        }
    }

    protected String[] loadConfig(URL config) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        ArrayList configNames = new ArrayList();
        log.debug((Object)("Try loading config as XML, url=" + config));
        try {
            this.loadXMLConfig(config, configNames);
        }
        catch (Throwable e) {
            log.debug((Object)"Failed to load config as XML", e);
            log.debug((Object)("Try loading config as Sun format, url=" + config));
            this.loadSunConfig(config, configNames);
        }
        String[] names = new String[configNames.size()];
        configNames.toArray(names);
        return names;
    }

    private void loadSunConfig(URL sunConfig, ArrayList configNames) throws Exception {
        InputStream is = sunConfig.openStream();
        if (is == null) {
            throw new IOException("InputStream is null for: " + sunConfig);
        }
        InputStreamReader configFile = new InputStreamReader(is);
        boolean trace = log.isTraceEnabled();
        SunConfigParser.doParse(configFile, this, trace);
    }

    private void loadXMLConfig(URL loginConfigURL, ArrayList configNames) throws IOException, JBossXBException {
        LoginConfigObjectModelFactory lcomf = new LoginConfigObjectModelFactory();
        UsersObjectModelFactory uomf = new UsersObjectModelFactory();
        InputStreamReader xmlReader = this.loadURL(loginConfigURL);
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        unmarshaller.mapFactoryToNamespace((ObjectModelFactory)uomf, "http://www.jboss.org/j2ee/schemas/XMLLoginModule");
        PolicyConfig config = (PolicyConfig)unmarshaller.unmarshal((Reader)xmlReader, (ObjectModelFactory)lcomf, null);
        configNames.addAll(config.getConfigNames());
        this.appConfigs.copy(config);
    }

    private InputStreamReader loadURL(URL configURL) throws IOException {
        InputStream is = configURL.openStream();
        if (is == null) {
            throw new IOException("Failed to obtain InputStream from url: " + configURL);
        }
        InputStreamReader xmlReader = new InputStreamReader(is);
        return xmlReader;
    }
}

