/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoUtil;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddSystemNotify {
    protected static Log m_log = LogFactory.getLog(AddSystemNotify.class);

    public boolean add(NotifyInfo info) throws CreateException, NamingException, JMSException {
        AccessLock.lock((String)"NOTIFY");
        try {
            Timestamp now = new Timestamp(new Date().getTime());
            SystemNotifyInfoLocal notify = SystemNotifyInfoUtil.getLocalHome().create(info.getNotifyId(), info.getDescription(), info.getStatusFlg(), info.getStatusValidPeriod(), info.getStatusInvalidFlg(), info.getStatusUpdatePriority(), info.getEventFlg(), info.getInhibitionFlg(), info.getInhibitionFrequency(), info.getInhibitionPeriod(), now, now, info.getMailTemplateId());
            Collection ct = notify.getSystemNotifyEventInfo();
            ArrayList eventList = info.getNotifyEventInfo();
            ArrayList<SystemNotifyEventInfoLocal> eventLocalList = new ArrayList<SystemNotifyEventInfoLocal>();
            NotifyEventInfo event = null;
            for (int index = 0; index < eventList.size(); ++index) {
                event = (NotifyEventInfo)eventList.get(index);
                if (event == null) continue;
                SystemNotifyEventInfoLocal local = SystemNotifyEventInfoUtil.getLocalHome().create(info.getNotifyId(), event.getPriority(), event.getEventNormalFlg(), event.getEventNormalState(), event.getEventInhibitionFlg(), event.getEventInhibitionState(), event.getMailFlg(), event.getMailAddress());
                eventLocalList.add(local);
            }
            if (eventLocalList != null) {
                ct.addAll(eventLocalList);
                notify.setSystemNotifyEventInfo(ct);
            }
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        return true;
    }
}

