/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.Invoker;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXService;
import org.jboss.mq.il.oil.OILServerIL;
import org.jboss.mq.il.oil.OILServerILServiceMBean;
import org.jboss.security.SecurityDomain;
import org.jboss.system.server.ServerConfigUtil;

public final class OILServerILService
extends ServerILJMXService
implements Runnable,
OILServerILServiceMBean {
    private static final Logger log = Logger.getLogger((Class)OILServerILService.class);
    private static final int SO_TIMEOUT = 5000;
    private Invoker server;
    private boolean enableTcpNoDelay = false;
    private int readTimeout = 0;
    private String securityDomain;
    private String clientSocketFactoryName;
    private ServerSocketFactory serverSocketFactory;
    private ServerSocket serverSocket;
    private OILServerIL serverIL;
    private volatile boolean running;
    private int serverBindPort = 0;
    private InetAddress bindAddress = null;
    private int threadNumber = 0;
    private Properties connectionProperties;

    public Properties getClientConnectionProperties() {
        return this.connectionProperties;
    }

    public String getName() {
        return "JBossMQ-OILServerIL";
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    public void run() {
        block12: while (true) {
            try {
                while (this.running) {
                    Socket socket = null;
                    try {
                        socket = this.serverSocket.accept();
                    }
                    catch (InterruptedIOException e) {
                        continue;
                    }
                    if (!this.running) {
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    try {
                        socket.setSoTimeout(this.readTimeout);
                        new Thread((Runnable)new Client(socket), "OIL Worker-" + this.threadNumber++).start();
                        continue block12;
                    }
                    catch (IOException ie) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"IOException processing client connection", (Throwable)ie);
                        log.debug((Object)"Dropping client connection, server will not terminate");
                    }
                }
                break;
            }
            catch (SocketException e) {
                if (!this.running) break;
                log.warn((Object)"SocketException occured (Connection reset by peer?). Cannot initialize the OILServerILService.");
                break;
            }
            catch (IOException e) {
                if (!this.running) break;
                log.warn((Object)"IOException occured. Cannot initialize the OILServerILService.", (Throwable)e);
                break;
            }
            catch (Throwable t) {
                log.warn((Object)"Unexpected error occured. Cannot initialize the OILServerILService.", t);
                break;
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            log.debug((Object)"error closing server socket", (Throwable)e);
        }
    }

    public void startService() throws Exception {
        super.startService();
        this.running = true;
        this.server = this.lookupJMSServer();
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        if (this.securityDomain != null) {
            try {
                InitialContext ctx = new InitialContext();
                Class<?> ssfClass = this.serverSocketFactory.getClass();
                SecurityDomain domain = (SecurityDomain)ctx.lookup(this.securityDomain);
                Class[] parameterTypes = new Class[]{SecurityDomain.class};
                Method m = ssfClass.getMethod("setSecurityDomain", parameterTypes);
                Object[] args = new Object[]{domain};
                m.invoke((Object)this.serverSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)"Socket factory does not support setSecurityDomain(SecurityDomain)");
            }
            catch (Exception e) {
                log.error((Object)("Failed to setSecurityDomain=" + this.securityDomain + " on socket factory"));
            }
        }
        this.serverSocket = this.serverSocketFactory.createServerSocket(this.serverBindPort, 50, this.bindAddress);
        this.serverSocket.setSoTimeout(5000);
        InetAddress socketAddress = this.serverSocket.getInetAddress();
        if (log.isInfoEnabled()) {
            log.info((Object)("JBossMQ OIL service available at : " + socketAddress + ":" + this.serverSocket.getLocalPort()));
        }
        new Thread(this.server.getThreadGroup(), this, "OIL Worker Server").start();
        socketAddress = ServerConfigUtil.fixRemoteAddress((InetAddress)socketAddress);
        this.serverIL = new OILServerIL(socketAddress, this.serverSocket.getLocalPort(), this.clientSocketFactoryName, this.enableTcpNoDelay);
        this.connectionProperties = super.getClientConnectionProperties();
        this.connectionProperties.setProperty("ClientILService", "org.jboss.mq.il.oil.OILClientILService");
        this.connectionProperties.setProperty("OIL_PORT_KEY", "" + this.serverSocket.getLocalPort());
        this.connectionProperties.setProperty("OIL_ADDRESS_KEY", "" + socketAddress.getHostAddress());
        this.connectionProperties.setProperty("OIL_TCPNODELAY_KEY", this.enableTcpNoDelay ? "yes" : "no");
        this.bindJNDIReferences();
    }

    public void stopService() {
        try {
            this.unbindJNDIReferences();
        }
        catch (Exception e) {
            log.error((Object)"Exception unbinding from JNDI", (Throwable)e);
        }
        try {
            this.running = false;
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception e) {
            log.debug((Object)"Exception stopping server thread", (Throwable)e);
        }
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public void setServerBindPort(int serverBindPort) {
        this.serverBindPort = serverBindPort;
    }

    public String getBindAddress() {
        String addr = "0.0.0.0";
        if (this.bindAddress != null) {
            addr = this.bindAddress.getHostName();
        }
        return addr;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = host == null || host.length() == 0 ? null : InetAddress.getByName(host);
    }

    public boolean getEnableTcpNoDelay() {
        return this.enableTcpNoDelay;
    }

    public void setEnableTcpNoDelay(boolean enableTcpNoDelay) {
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public String getClientSocketFactory() {
        return this.clientSocketFactoryName;
    }

    public void setClientSocketFactory(String name) {
        this.clientSocketFactoryName = name;
    }

    public void setServerSocketFactory(String name) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> ssfClass = loader.loadClass(name);
        this.serverSocketFactory = (ServerSocketFactory)ssfClass.newInstance();
    }

    public String getServerSocketFactory() {
        String name = null;
        if (this.serverSocketFactory != null) {
            name = this.serverSocketFactory.getClass().getName();
        }
        return name;
    }

    public void setSecurityDomain(String domainName) {
        this.securityDomain = domainName;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    private final class Client
    implements Runnable {
        private Socket sock;
        private ObjectOutputStream out;
        private ObjectInputStream in;

        Client(Socket s) throws IOException {
            this.sock = s;
            this.out = new ObjectOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            this.out.flush();
            this.in = new ObjectInputStream(new BufferedInputStream(this.sock.getInputStream()));
            this.sock.setTcpNoDelay(OILServerILService.this.enableTcpNoDelay);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Setting TcpNoDelay Option to:" + OILServerILService.this.enableTcpNoDelay));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block46: {
                byte code = 0;
                boolean closed = false;
                ConnectionToken connectionToken = null;
                while (!closed && OILServerILService.this.running) {
                    try {
                        code = this.in.readByte();
                    }
                    catch (EOFException e) {
                        break;
                    }
                    catch (IOException e) {
                        if (closed || !OILServerILService.this.running) break;
                        log.warn((Object)"Connection failure (1).", (Throwable)e);
                        break;
                    }
                    try {
                        SpyMessage[] result = null;
                        switch (code) {
                            case 21: {
                                connectionToken = (ConnectionToken)this.in.readObject();
                                break;
                            }
                            case 8: {
                                AcknowledgementRequest ack = new AcknowledgementRequest();
                                ack.readExternal(this.in);
                                OILServerILService.this.server.acknowledge(connectionToken, ack);
                                break;
                            }
                            case 9: {
                                OILServerILService.this.server.addMessage(connectionToken, SpyMessage.readMessage(this.in));
                                break;
                            }
                            case 10: {
                                result = OILServerILService.this.server.browse(connectionToken, (Destination)this.in.readObject(), (String)this.in.readObject());
                                break;
                            }
                            case 11: {
                                String ID = (String)this.in.readObject();
                                OILServerILService.this.server.checkID(ID);
                                if (connectionToken == null) break;
                                connectionToken.setClientID(ID);
                                break;
                            }
                            case 12: {
                                OILServerILService.this.server.connectionClosing(connectionToken);
                                closed = true;
                                break;
                            }
                            case 13: {
                                result = OILServerILService.this.server.createQueue(connectionToken, (String)this.in.readObject());
                                break;
                            }
                            case 14: {
                                result = OILServerILService.this.server.createTopic(connectionToken, (String)this.in.readObject());
                                break;
                            }
                            case 15: {
                                OILServerILService.this.server.deleteTemporaryDestination(connectionToken, (SpyDestination)this.in.readObject());
                                break;
                            }
                            case 16: {
                                result = OILServerILService.this.server.getID();
                                if (connectionToken == null) break;
                                connectionToken.setClientID((String)result);
                                break;
                            }
                            case 17: {
                                result = OILServerILService.this.server.getTemporaryQueue(connectionToken);
                                break;
                            }
                            case 18: {
                                result = OILServerILService.this.server.getTemporaryTopic(connectionToken);
                                break;
                            }
                            case 19: {
                                result = OILServerILService.this.server.receive(connectionToken, this.in.readInt(), this.in.readLong());
                                break;
                            }
                            case 20: {
                                OILServerILService.this.server.setEnabled(connectionToken, this.in.readBoolean());
                                break;
                            }
                            case 22: {
                                OILServerILService.this.server.subscribe(connectionToken, (Subscription)this.in.readObject());
                                break;
                            }
                            case 23: {
                                TransactionRequest trans = new TransactionRequest();
                                trans.readExternal(this.in);
                                OILServerILService.this.server.transact(connectionToken, trans);
                                break;
                            }
                            case 24: {
                                OILServerILService.this.server.unsubscribe(connectionToken, this.in.readInt());
                                break;
                            }
                            case 25: {
                                OILServerILService.this.server.destroySubscription(connectionToken, (DurableSubscriptionID)this.in.readObject());
                                break;
                            }
                            case 26: {
                                result = OILServerILService.this.server.checkUser((String)this.in.readObject(), (String)this.in.readObject());
                                break;
                            }
                            case 27: {
                                OILServerILService.this.server.ping(connectionToken, this.in.readLong());
                                break;
                            }
                            case 30: {
                                result = OILServerILService.this.server.authenticate((String)this.in.readObject(), (String)this.in.readObject());
                                break;
                            }
                            default: {
                                throw new RemoteException("Bad method code !");
                            }
                        }
                        try {
                            if (result == null) {
                                this.out.writeByte(0);
                            } else {
                                this.out.writeByte(1);
                                this.out.writeObject(result);
                                this.out.reset();
                            }
                            this.out.flush();
                            continue;
                        }
                        catch (IOException e) {
                            if (closed) break;
                            log.warn((Object)"Connection failure (2).", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        if (closed) break;
                        log.warn((Object)"Client request resulted in a server exception: ", (Throwable)e);
                        try {
                            this.out.writeByte(2);
                            this.out.writeObject(e);
                            this.out.reset();
                            this.out.flush();
                            continue;
                        }
                        catch (IOException e2) {
                            if (closed) break;
                            log.warn((Object)"Connection failure (3).", (Throwable)e);
                        }
                    }
                    break;
                }
                if (!closed) {
                    try {
                        OILServerILService.this.server.connectionClosing(connectionToken);
                    }
                    catch (JMSException e) {
                        // empty catch block
                    }
                }
                this.in.close();
                this.out.close();
                Object var9_15 = null;
                try {
                    this.sock.close();
                }
                catch (IOException e2) {
                    log.warn((Object)"Connection failure during connection close.", (Throwable)e2);
                }
                break block46;
                {
                    catch (IOException e) {
                        log.warn((Object)"Connection failure during connection close.", (Throwable)e);
                        Object var9_16 = null;
                        try {
                            this.sock.close();
                        }
                        catch (IOException e2) {
                            log.warn((Object)"Connection failure during connection close.", (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_17 = null;
                    try {
                        this.sock.close();
                    }
                    catch (IOException e2) {
                        log.warn((Object)"Connection failure during connection close.", (Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }
    }
}

