/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.plugins.SubjectActions;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

public class JaasSecurityManager
extends ServiceMBeanSupport
implements SubjectSecurityManager,
RealmMapping {
    private String securityDomain;
    private CachePolicy domainCache;
    private CallbackHandler handler;
    private Method setSecurityInfo;
    protected Logger log;
    protected boolean trace;
    static /* synthetic */ Class class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo;

    public JaasSecurityManager() {
        this("other", new SecurityAssociationHandler());
    }

    public JaasSecurityManager(String securityDomain, CallbackHandler handler) {
        this.securityDomain = securityDomain;
        this.handler = handler;
        String categoryName = this.getClass().getName() + '.' + securityDomain;
        this.log = Logger.getLogger((String)categoryName);
        this.trace = this.log.isTraceEnabled();
        Class[] sig = new Class[]{Principal.class, Object.class};
        try {
            this.setSecurityInfo = handler.getClass().getMethod("setSecurityInfo", sig);
        }
        catch (Exception e) {
            String msg = "Failed to find setSecurityInfo(Princpal, Object) method in handler";
            throw new UndeclaredThrowableException(e, msg);
        }
        this.log.debug((Object)("CallbackHandler: " + handler));
    }

    public void setCachePolicy(CachePolicy domainCache) {
        this.domainCache = domainCache;
        this.log.debug((Object)("CachePolicy set to: " + domainCache));
    }

    public void flushCache() {
        if (this.domainCache != null) {
            this.domainCache.flush();
        }
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public Subject getActiveSubject() {
        return SecurityAssociation.getSubject();
    }

    public boolean isValid(Principal principal, Object credential) {
        return this.isValid(principal, credential, null);
    }

    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        DomainInfo cacheInfo = this.getCacheInfo(principal, true);
        if (this.trace) {
            this.log.trace((Object)("Begin isValid, principal:" + principal + ", cache info: " + cacheInfo));
        }
        boolean isValid = false;
        if (cacheInfo != null) {
            isValid = this.validateCache(cacheInfo, credential, activeSubject);
            if (cacheInfo != null) {
                cacheInfo.release();
            }
        }
        if (!isValid) {
            isValid = this.authenticate(principal, credential, activeSubject);
        }
        if (this.trace) {
            this.log.trace((Object)("End isValid, " + isValid));
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getPrincipal(Principal principal) {
        Principal result = principal;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            DomainInfo info = this.getCacheInfo(principal, false);
            if (this.trace) {
                this.log.trace((Object)("getPrincipal, cache info: " + info));
            }
            if (info != null) {
                result = info.callerPrincipal;
                if (result == null) {
                    result = principal;
                }
                info.release();
            }
        }
        return result;
    }

    public boolean doesUserHaveRole(Principal principal, Set rolePrincipals) {
        boolean hasRole = false;
        Subject subject = SubjectActions.getActiveSubject();
        if (subject != null) {
            if (this.trace) {
                this.log.trace((Object)("doesUserHaveRole(Set), subject: " + subject));
            }
            Group roles = this.getSubjectRoles(subject);
            if (this.trace) {
                this.log.trace((Object)("roles=" + roles));
            }
            if (roles != null) {
                Iterator iter = rolePrincipals.iterator();
                while (!hasRole && iter.hasNext()) {
                    Principal role = (Principal)iter.next();
                    hasRole = this.doesRoleGroupHaveRole(role, roles);
                    if (!this.trace) continue;
                    this.log.trace((Object)("hasRole(" + role + ")=" + hasRole));
                }
            }
            if (this.trace) {
                this.log.trace((Object)("hasRole=" + hasRole));
            }
        }
        return hasRole;
    }

    public boolean doesUserHaveRole(Principal principal, Principal role) {
        boolean hasRole = false;
        Subject subject = SubjectActions.getActiveSubject();
        if (subject != null) {
            Group roles;
            if (this.trace) {
                this.log.trace((Object)("doesUserHaveRole(Principal), subject: " + subject));
            }
            if ((roles = this.getSubjectRoles(subject)) != null) {
                hasRole = this.doesRoleGroupHaveRole(role, roles);
            }
        }
        return hasRole;
    }

    public Set getUserRoles(Principal principal) {
        HashSet<Principal> userRoles = null;
        Subject subject = SubjectActions.getActiveSubject();
        if (subject != null) {
            Group roles;
            if (this.trace) {
                this.log.trace((Object)("getUserRoles, subject: " + subject));
            }
            if ((roles = this.getSubjectRoles(subject)) != null) {
                userRoles = new HashSet<Principal>();
                Enumeration members = roles.members();
                while (members.hasMoreElements()) {
                    Principal role = (Principal)members.nextElement();
                    userRoles.add(role);
                }
            }
        }
        return userRoles;
    }

    protected boolean doesRoleGroupHaveRole(Principal role, Group userRoles) {
        if (role instanceof NobodyPrincipal) {
            return false;
        }
        boolean isMember = userRoles.isMember(role);
        if (!isMember) {
            isMember = role instanceof AnybodyPrincipal;
        }
        return isMember;
    }

    private boolean authenticate(Principal principal, Object credential, Subject theSubject) {
        Subject subject = null;
        boolean authenticated = false;
        LoginException authException = null;
        try {
            LoginContext lc = this.defaultLogin(principal, credential);
            subject = lc.getSubject();
            if (subject != null) {
                if (theSubject != null) {
                    SubjectActions.copySubject(subject, theSubject);
                } else {
                    theSubject = subject;
                }
                authenticated = true;
                this.updateCache(lc, subject, principal, credential);
            }
        }
        catch (LoginException e) {
            if (principal != null && principal.getName() != null || this.trace) {
                this.log.trace((Object)"Login failure", (Throwable)e);
            }
            authException = e;
        }
        SubjectActions.setContextInfo("org.jboss.security.exception", authException);
        return authenticated;
    }

    private LoginContext defaultLogin(Principal principal, Object credential) throws LoginException {
        Object[] securityInfo = new Object[]{principal, credential};
        CallbackHandler theHandler = null;
        try {
            theHandler = (CallbackHandler)this.handler.getClass().newInstance();
            this.setSecurityInfo.invoke((Object)theHandler, securityInfo);
        }
        catch (Throwable e) {
            if (this.trace) {
                this.log.trace((Object)"Failed to create/setSecurityInfo on handler", e);
            }
            LoginException le = new LoginException("Failed to setSecurityInfo on handler");
            le.initCause(e);
            throw le;
        }
        Subject subject = new Subject();
        LoginContext lc = null;
        if (this.trace) {
            this.log.trace((Object)("defaultLogin, principal=" + principal));
        }
        lc = SubjectActions.createLoginContext(this.securityDomain, subject, theHandler);
        lc.login();
        if (this.trace) {
            this.log.trace((Object)("defaultLogin, lc=" + lc + ", subject=" + SubjectActions.toString(subject)));
        }
        return lc;
    }

    private boolean validateCache(DomainInfo info, Object credential, Subject theSubject) {
        if (this.trace) {
            StringBuffer tmp = new StringBuffer("Begin validateCache, info=");
            tmp.append(info.toString());
            tmp.append(";credential.class=");
            if (credential != null) {
                Class<?> c = credential.getClass();
                tmp.append(c.getName());
                tmp.append('@');
                tmp.append(System.identityHashCode(c));
            } else {
                tmp.append("null");
            }
            this.log.trace((Object)tmp.toString());
        }
        Object subjectCredential = info.credential;
        boolean isValid = false;
        if (credential == null || subjectCredential == null) {
            isValid = credential == null && subjectCredential == null;
        } else if (subjectCredential.getClass().isAssignableFrom(credential.getClass())) {
            if (subjectCredential instanceof Comparable) {
                Comparable c = (Comparable)subjectCredential;
                isValid = c.compareTo(credential) == 0;
            } else if (subjectCredential instanceof char[]) {
                char[] a1 = (char[])subjectCredential;
                char[] a2 = (char[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential instanceof byte[]) {
                byte[] a1 = (byte[])subjectCredential;
                byte[] a2 = (byte[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential.getClass().isArray()) {
                Object[] a1 = (Object[])subjectCredential;
                Object[] a2 = (Object[])credential;
                isValid = Arrays.equals(a1, a2);
            } else {
                isValid = subjectCredential.equals(credential);
            }
        }
        if (isValid && theSubject != null) {
            SubjectActions.copySubject(info.subject, theSubject);
        }
        if (this.trace) {
            this.log.trace((Object)("End validateCache, isValid=" + isValid));
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainInfo getCacheInfo(Principal principal, boolean allowRefresh) {
        if (this.domainCache == null) {
            return null;
        }
        DomainInfo cacheInfo = null;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            cacheInfo = allowRefresh ? (DomainInfo)this.domainCache.get((Object)principal) : (DomainInfo)this.domainCache.peek((Object)principal);
            if (cacheInfo != null) {
                cacheInfo.acquire();
            }
        }
        return cacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subject updateCache(LoginContext lc, Subject subject, Principal principal, Object credential) {
        if (this.domainCache == null) {
            return subject;
        }
        long lifetime = 0L;
        if (this.domainCache instanceof TimedCachePolicy) {
            TimedCachePolicy cache = (TimedCachePolicy)this.domainCache;
            lifetime = cache.getDefaultLifetime();
        }
        DomainInfo info = new DomainInfo(lifetime);
        info.loginCtx = lc;
        info.subject = new Subject();
        SubjectActions.copySubject(subject, info.subject, true);
        info.credential = credential;
        if (this.trace) {
            this.log.trace((Object)("updateCache, inputSubject=" + SubjectActions.toString(subject) + ", cacheSubject=" + SubjectActions.toString(info.subject)));
        }
        Set subjectGroups = subject.getPrincipals(Group.class);
        Iterator iter = subjectGroups.iterator();
        while (iter.hasNext()) {
            Enumeration members;
            Group grp = (Group)iter.next();
            String name = grp.getName();
            if (!name.equals("CallerPrincipal") || !(members = grp.members()).hasMoreElements()) continue;
            info.callerPrincipal = (Principal)members.nextElement();
        }
        if (principal == null && info.callerPrincipal == null) {
            Set subjectPrincipals = subject.getPrincipals(Principal.class);
            iter = subjectPrincipals.iterator();
            while (iter.hasNext()) {
                Principal p = (Principal)iter.next();
                if (p instanceof Group) continue;
                info.callerPrincipal = p;
            }
        }
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            if (this.domainCache.peek((Object)principal) != null) {
                this.domainCache.remove((Object)principal);
            }
            this.domainCache.insert((Object)principal, (Object)info);
            if (this.trace) {
                this.log.trace((Object)("Inserted cache info: " + info));
            }
        }
        return info.subject;
    }

    private Group getSubjectRoles(Subject theSubject) {
        Set subjectGroups = theSubject.getPrincipals(Group.class);
        Iterator iter = subjectGroups.iterator();
        Group roles = null;
        while (iter.hasNext()) {
            Group grp = (Group)iter.next();
            String name = grp.getName();
            if (!name.equals("Roles")) continue;
            roles = grp;
        }
        return roles;
    }

    public static class DomainInfo
    implements TimedCachePolicy.TimedEntry {
        private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo == null ? (class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo = JaasSecurityManager.class$("org.jboss.security.plugins.JaasSecurityManager$DomainInfo")) : class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo));
        private static boolean trace = log.isTraceEnabled();
        private LoginContext loginCtx;
        private Subject subject;
        private Object credential;
        private Principal callerPrincipal;
        private long expirationTime;
        private boolean needsDestroy;
        private int activeUsers;

        public DomainInfo(long lifetime) {
            this.expirationTime = lifetime;
            if (this.expirationTime != -1L) {
                this.expirationTime *= 1000L;
            }
        }

        synchronized int acquire() {
            return this.activeUsers++;
        }

        synchronized int release() {
            int users = this.activeUsers--;
            if (this.needsDestroy && users == 0) {
                if (trace) {
                    log.trace((Object)"needsDestroy is true, doing logout");
                }
                this.logout();
            }
            return users;
        }

        synchronized void logout() {
            block4: {
                if (trace) {
                    log.trace((Object)("logout, subject=" + this.subject + ", this=" + this));
                }
                try {
                    if (this.loginCtx != null) {
                        this.loginCtx.logout();
                    }
                }
                catch (Throwable e) {
                    if (!trace) break block4;
                    log.trace((Object)"Cache entry logout failed", e);
                }
            }
        }

        public void init(long now) {
            this.expirationTime += now;
        }

        public boolean isCurrent(long now) {
            boolean isCurrent;
            boolean bl = isCurrent = this.expirationTime == -1L;
            if (!isCurrent) {
                isCurrent = this.expirationTime > now;
            }
            return isCurrent;
        }

        public boolean refresh() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            if (trace) {
                log.trace((Object)("destroy, subject=" + this.subject + ", this=" + this + ", activeUsers=" + this.activeUsers));
            }
            DomainInfo domainInfo = this;
            synchronized (domainInfo) {
                if (this.activeUsers == 0) {
                    this.logout();
                } else {
                    if (trace) {
                        log.trace((Object)("destroy saw activeUsers=" + this.activeUsers));
                    }
                    this.needsDestroy = true;
                }
            }
        }

        public Object getValue() {
            return this;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append('[');
            tmp.append(SubjectActions.toString(this.subject));
            tmp.append(",credential.class=");
            if (this.credential != null) {
                Class<?> c = this.credential.getClass();
                tmp.append(c.getName());
                tmp.append('@');
                tmp.append(System.identityHashCode(c));
            } else {
                tmp.append("null");
            }
            tmp.append(",expirationTime=");
            tmp.append(this.expirationTime);
            tmp.append(']');
            return tmp.toString();
        }
    }
}

