/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmppoller.util;

import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import java.io.Serializable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiveRepositoryTopic
implements MessageListener,
ExceptionListener {
    private static long RETRY_INTERVAL = 10000L;
    private static final String TOPIC_CON_FACTORY = "java:/ConnectionFactory";
    private TopicConnectionFactory m_factory;
    private TopicConnection m_con;
    private Topic m_topic;
    private TopicSession m_session;
    private TopicSubscriber m_subscriber;
    private SnmpSharedTable m_sharedTable;
    private boolean m_errFlg = false;
    protected static Timer m_timer = new Timer(true);
    private static Log log = LogFactory.getLog(ReceiveRepositoryTopic.class);

    public ReceiveRepositoryTopic(SnmpSharedTable sharedTable) {
        this.m_sharedTable = sharedTable;
        this.initial();
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            Serializable obj;
            ObjectMessage objectMessage = (ObjectMessage)message;
            try {
                obj = objectMessage.getObject();
            }
            catch (JMSException e) {
                log.error((Object)"onMessage()\uff1aInvalid message type received.", (Throwable)e);
                return;
            }
            if (obj instanceof UpdateRepositoryInfo) {
                log.debug((Object)"onMessage()\uff1a get UpdateRepositoryInfo");
                UpdateRepositoryInfo info = (UpdateRepositoryInfo)obj;
                this.m_sharedTable.refreshTable();
            } else {
                log.debug((Object)("onMessage()\uff1aInvalid message type received. " + obj.toString()));
            }
        } else {
            log.error((Object)("onMessage()\uff1aInvalid message type received. " + message.getClass()));
        }
    }

    public void onException(JMSException arg0) {
        log.error((Object)arg0);
        this.setErrFlg(true);
    }

    private synchronized void setErrFlg(boolean errFlg) {
        if (!this.m_errFlg && errFlg) {
            m_timer.schedule((TimerTask)new ReSetupTask(), RETRY_INTERVAL, RETRY_INTERVAL);
        }
        this.m_errFlg = errFlg;
    }

    private synchronized boolean reInitial() {
        boolean ret = false;
        log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406!");
        this.terminate();
        if (this.initial()) {
            ret = true;
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u6210\u529f!");
            this.setErrFlg(false);
            this.m_sharedTable.refreshTable();
        } else {
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u5931\u6557!");
        }
        return ret;
    }

    public void terminate() {
        this.terminateSubscriber();
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private void terminateSubscriber() {
        try {
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initial() {
        log.info((Object)"EJB\u63a5\u7d9a\u521d\u671f\u5316");
        InitialContext context = null;
        try {
            String serverName = System.getProperty("jboss.server.name");
            if (serverName.equals("all")) {
                Properties properties = new Properties();
                properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                properties.put("java.naming.provider.url", "jnp://localhost:1100");
                context = new InitialContext(properties);
            } else {
                context = new InitialContext();
            }
            this.m_factory = (TopicConnectionFactory)context.lookup(TOPIC_CON_FACTORY);
            this.m_con = this.m_factory.createTopicConnection();
            this.m_session = this.m_con.createTopicSession(false, 1);
            this.m_topic = (Topic)context.lookup("topic/clustercontrol/Repository/update");
            this.m_con.setExceptionListener((ExceptionListener)this);
            this.m_con.start();
            this.initialTopic();
        }
        catch (Exception e) {
            log.error((Object)"initial", (Throwable)e);
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e1) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialTopic() {
        this.terminateSubscriber();
        try {
            this.m_subscriber = this.m_session.createSubscriber(this.m_topic);
            this.m_subscriber.setMessageListener((MessageListener)this);
        }
        catch (Exception e) {
            log.error((Object)"initialTopic", (Throwable)e);
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    protected class ReSetupTask
    extends TimerTask {
        protected ReSetupTask() {
        }

        public void run() {
            if (ReceiveRepositoryTopic.this.reInitial()) {
                this.cancel();
            }
        }
    }
}

