/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmppoller.jmx;

import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.snmppoller.jmx.SnmpPollerServiceMBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;

public class SnmpPollerService
extends ServiceMBeanSupport
implements SnmpPollerServiceMBean {
    private String jndiName = "SnmpPollerService";
    private String groupName = "SNMP";
    private String quartzJndiName = null;
    private int defaultPort = -1;
    private int defaultVersion = 1;
    private String defaultCommunity = "public";
    private int defaultRetries = -1;
    private int defaultTimeout = 1000;
    private boolean indexCheckFlg = false;
    private String checkInterval = "34 */1 * * * ? *";
    private List oidList = new ArrayList();
    private SnmpSharedTable snmpSharedTable;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) throws NamingException {
        this.log.info((Object)("setJndiName() SnmpService : " + jndiName));
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        if (super.getState() == 3) {
            NamingException ne;
            try {
                this.unbind(oldName);
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to unbind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
            try {
                this.rebind();
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to rebind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getQuartzJndiName() {
        return this.quartzJndiName;
    }

    public void setQuartzJndiName(String jndiName) {
        this.quartzJndiName = jndiName;
    }

    public String getName() {
        return "SnmpPollerService(" + this.jndiName + ")";
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public int getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(int defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String getDefaultCommunity() {
        return this.defaultCommunity;
    }

    public void setDefaultCommunity(String defaultCommunity) {
        this.defaultCommunity = defaultCommunity;
    }

    public int getDefaultRetries() {
        return this.defaultRetries;
    }

    public void setDefaultRetries(int defaultRetries) {
        this.defaultRetries = defaultRetries;
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public String getOids() {
        String oidSetString = null;
        for (String oid : this.oidList) {
            oidSetString = oidSetString + "\n" + oid;
        }
        return oidSetString;
    }

    public void setOids(String oids) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(oids.getBytes());
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            IOException ioe = new IOException("Failed to set OID list.");
            this.log.error((Object)ioe);
        }
        Enumeration<Object> enu = properties.elements();
        while (enu.hasMoreElements()) {
            this.oidList.add((String)enu.nextElement());
        }
    }

    public String getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(String checkInterval) {
        this.checkInterval = checkInterval;
    }

    public boolean getIndexCheckFlg() {
        return this.indexCheckFlg;
    }

    public void setIndexCheckFlg(boolean indexCheckFlg) {
        this.indexCheckFlg = indexCheckFlg;
    }

    public void createService() {
        this.log.info((Object)("Create SnmpPollerService(" + this.jndiName + ")"));
        this.snmpSharedTable = new SnmpSharedTable(this.jndiName, this.groupName);
        this.snmpSharedTable.setQuartzJndiName(this.quartzJndiName);
        this.snmpSharedTable.setCheckInterval(this.checkInterval);
        this.snmpSharedTable.setDefaultPort(this.defaultPort);
        this.snmpSharedTable.setDefaultVersion(this.defaultVersion);
        this.snmpSharedTable.setDefaultCommunity(this.defaultCommunity);
        this.snmpSharedTable.setDefaultRetries(this.defaultRetries);
        this.snmpSharedTable.setDdefaultTimeout(this.defaultTimeout);
        this.snmpSharedTable.setOidList(this.oidList);
        this.snmpSharedTable.setIndexCheckFlg(this.indexCheckFlg);
        this.log.info((Object)("Created SnmpPollerService(" + this.jndiName + ")"));
    }

    public void startService() throws NamingException {
        this.log.info((Object)("Start SnmpPollerService(" + this.jndiName + ")"));
        this.snmpSharedTable.scheduleCheckJob();
        this.rebind();
        this.log.info((Object)("Started SnmpPollerService(" + this.jndiName + ")"));
    }

    public void stopService() throws NamingException {
        this.log.info((Object)("Stop SnmpPollerService(" + this.jndiName + ")"));
        this.unbind(this.jndiName);
        this.snmpSharedTable.deleteCheckJob();
        this.snmpSharedTable.deleteTableAll();
        this.log.info((Object)("Stoped SnmpPollerService(" + this.jndiName + ")"));
    }

    public void destroyService() throws Exception {
        this.log.info((Object)("Destroy SnmpPollerService(" + this.jndiName + ")"));
        this.snmpSharedTable = null;
        this.log.info((Object)("Destroyed SnmpPollerService(" + this.jndiName + ")"));
    }

    private static Context createContext(Context rootCtx, Name name) throws NamingException {
        Context subctx = rootCtx;
        for (int n = 0; n < name.size(); ++n) {
            String atom = name.get(n);
            try {
                Object obj = subctx.lookup(atom);
                subctx = (Context)obj;
                continue;
            }
            catch (NamingException e) {
                subctx = subctx.createSubcontext(atom);
            }
        }
        return subctx;
    }

    private void rebind() throws NamingException {
        Name fullName;
        InitialContext rootCtx = new InitialContext();
        Name parentName = fullName = rootCtx.getNameParser("").parse(this.jndiName);
        parentName = fullName.size() > 1 ? fullName.getPrefix(fullName.size() - 1) : new CompositeName();
        Context parentCtx = SnmpPollerService.createContext(rootCtx, parentName);
        Name atomName = fullName.getSuffix(fullName.size() - 1);
        String atomStirng = atomName.get(0);
        NonSerializableFactory.rebind((Context)parentCtx, (String)atomStirng, (Object)this.snmpSharedTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind(String jndiName) throws NamingException {
        InitialContext rootCtx = null;
        try {
            rootCtx = new InitialContext();
            Name fullName = rootCtx.getNameParser("").parse(jndiName);
            Name atomName = fullName.getSuffix(fullName.size() - 1);
            String atom = atomName.get(0);
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)atom);
        }
        finally {
            if (rootCtx != null) {
                rootCtx.close();
            }
        }
    }
}

