/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmppoller.bean;

import com.clustercontrol.snmppoller.SnmpConfig;
import java.io.Serializable;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PollingConfig
implements Serializable {
    protected static Log m_log = LogFactory.getLog(PollingConfig.class);
    private static final String[] cronExpressionSet = new String[]{"*/1 * * * * ? *", "*/5 * * * * ? *", "*/15 * * * * ? *", "*/30 * * * * ? *", "0 */1 * * * ? *", "0 */5 * * * ? *", "0 */15 * * * ? *", "0 */30 * * * ? *", "0 0 */1 * * ? *"};
    private static final int[] intervalSet = new int[]{1, 5, 15, 30, 60, 300, 900, 1800, 3600};
    private boolean[] m_intervalFlag = new boolean[]{false, false, false, false, false, false, false, false, false};
    private SnmpConfig m_snmpConfig;
    private long m_repositoryModifyTime;

    public static int parseInterval(String cronExpression) {
        for (int i = 0; i < cronExpressionSet.length; ++i) {
            if (!cronExpressionSet[i].equals(cronExpression)) continue;
            return intervalSet[i];
        }
        return -1;
    }

    public static String parseCronExpression(int interval) {
        for (int i = 0; i < intervalSet.length; ++i) {
            if (intervalSet[i] != interval) continue;
            return cronExpressionSet[i];
        }
        return null;
    }

    public PollingConfig(InetAddress address, int port, int version, String community, int retries, int timeout, long modifyTime) {
        this.m_snmpConfig = new SnmpConfig(address);
        this.m_snmpConfig.setPort(port);
        this.m_snmpConfig.setVersion(version);
        this.m_snmpConfig.setComunity(community);
        this.m_snmpConfig.setRetries(retries);
        this.m_snmpConfig.setTimeout(timeout);
        this.m_repositoryModifyTime = modifyTime;
    }

    public boolean addInterval(int interval) {
        for (int i = intervalSet.length - 1; i >= 0; --i) {
            if (intervalSet[i] > interval) continue;
            if (this.m_intervalFlag[i]) {
                return false;
            }
            int minInterval = this.getMinInterval();
            if (minInterval == 0 || intervalSet[i] < minInterval) {
                this.m_intervalFlag[i] = true;
                return true;
            }
            this.m_intervalFlag[i] = true;
            return false;
        }
        return false;
    }

    public void removeInterval(int interval) {
        for (int i = 0; i < intervalSet.length; ++i) {
            if (intervalSet[i] != interval) continue;
            this.m_intervalFlag[i] = false;
        }
    }

    public int getMinInterval() {
        for (int i = 0; i < this.m_intervalFlag.length; ++i) {
            if (!this.m_intervalFlag[i]) continue;
            return intervalSet[i];
        }
        return 0;
    }

    public static int[] getAvailableIntervals() {
        return intervalSet;
    }

    public SnmpConfig getSnmpConfig() {
        return this.m_snmpConfig;
    }

    public long getRepositoryModifyTime() {
        return this.m_repositoryModifyTime;
    }
}

