/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.server;

import java.util.Map;
import org.jboss.axis.AxisEngine;
import org.jboss.axis.AxisFault;
import org.jboss.axis.AxisProperties;
import org.jboss.axis.Constants;
import org.jboss.axis.EngineConfiguration;
import org.jboss.axis.Handler;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.SimpleTargetedChain;
import org.jboss.axis.client.AxisClient;
import org.jboss.axis.configuration.EngineConfigurationFactoryFinder;
import org.jboss.axis.server.AxisServerFactory;
import org.jboss.axis.server.DefaultAxisServerFactory;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.ClassUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class AxisServer
extends AxisEngine {
    private static Logger log = Logger.getLogger((String)AxisServer.class.getName());
    private static Logger tlog = Logger.getLogger((String)"org.jboss.axis.TIME");
    private static AxisServerFactory factory = null;
    private AxisEngine clientEngine;
    private boolean running = true;

    public static AxisServer getServer(Map environment) throws AxisFault {
        if (factory == null) {
            String factoryClassName = AxisProperties.getProperty("axis.ServerFactory");
            if (factoryClassName != null) {
                try {
                    Class factoryClass = ClassUtils.forName(factoryClassName);
                    if (AxisServerFactory.class.isAssignableFrom(factoryClass)) {
                        factory = (AxisServerFactory)factoryClass.newInstance();
                    }
                }
                catch (Exception e) {
                    log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
                }
            }
            if (factory == null) {
                factory = new DefaultAxisServerFactory();
            }
        }
        return factory.getServer(environment);
    }

    public AxisServer() {
        this(EngineConfigurationFactoryFinder.newFactory().getServerEngineConfig());
    }

    public AxisServer(EngineConfiguration config) {
        super(config);
        this.setShouldSaveConfig(true);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.init();
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public synchronized AxisEngine getClientEngine() {
        if (this.clientEngine == null) {
            this.clientEngine = new AxisClient();
        }
        return this.clientEngine;
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        block31: {
            long t0 = 0L;
            long t1 = 0L;
            long t2 = 0L;
            long t3 = 0L;
            long t4 = 0L;
            long t5 = 0L;
            if (tlog.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enter: AxisServer::invoke");
            }
            if (!this.isRunning()) {
                throw new AxisFault("Server.disabled", Messages.getMessage("serverDisabled00"), null, null);
            }
            String hName = null;
            Handler h = null;
            MessageContext previousContext = AxisServer.getCurrentMessageContext();
            try {
                AxisServer.setCurrentMessageContext(msgContext);
                hName = msgContext.getStrProp("engine.handler");
                if (hName != null) {
                    h = this.getHandler(hName);
                    if (h == null) {
                        ClassLoader cl = msgContext.getClassLoader();
                        try {
                            log.debug((Object)Messages.getMessage("tryingLoad00", hName));
                            Class cls = ClassUtils.forName(hName, true, cl);
                            h = (Handler)cls.newInstance();
                        }
                        catch (Exception e) {
                            h = null;
                        }
                    }
                    if (tlog.isDebugEnabled()) {
                        t1 = System.currentTimeMillis();
                    }
                    if (h == null) {
                        throw new AxisFault("Server.error", Messages.getMessage("noHandler00", hName), null, null);
                    }
                    h.invoke(msgContext);
                    if (tlog.isDebugEnabled()) {
                        t2 = System.currentTimeMillis();
                        tlog.debug((Object)("AxisServer.invoke " + hName + " invoke=" + (t2 - t1) + " pre=" + (t1 - t0)));
                    }
                    break block31;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage("defaultLogic00"));
                }
                hName = msgContext.getTransportName();
                SimpleTargetedChain transportChain = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage("transport01", "AxisServer.invoke", hName));
                }
                if (tlog.isDebugEnabled()) {
                    t1 = System.currentTimeMillis();
                }
                if (hName != null && (h = this.getTransport(hName)) != null && h instanceof SimpleTargetedChain && (h = (transportChain = (SimpleTargetedChain)h).getRequestHandler()) != null) {
                    h.invoke(msgContext);
                }
                if (tlog.isDebugEnabled()) {
                    t2 = System.currentTimeMillis();
                }
                if ((h = this.getGlobalRequest()) != null) {
                    h.invoke(msgContext);
                }
                if ((h = msgContext.getService()) == null) {
                    Message rm = msgContext.getRequestMessage();
                    rm.getSOAPEnvelope().getFirstBody();
                    h = msgContext.getService();
                    if (h == null) {
                        throw new AxisFault("Server.NoService", Messages.getMessage("noService05", "" + msgContext.getTargetService()), null, null);
                    }
                }
                if (tlog.isDebugEnabled()) {
                    t3 = System.currentTimeMillis();
                }
                if (msgContext.getRequestMessage().getSOAPEnvelope().getSOAPConstants() != null) {
                    SOAPConstants soapConstants = msgContext.getRequestMessage().getSOAPEnvelope().getSOAPConstants();
                    msgContext.setSOAPConstants(soapConstants);
                }
                h.invoke(msgContext);
                if (tlog.isDebugEnabled()) {
                    t4 = System.currentTimeMillis();
                }
                if ((h = this.getGlobalResponse()) != null) {
                    h.invoke(msgContext);
                }
                if (transportChain != null && (h = transportChain.getResponseHandler()) != null) {
                    h.invoke(msgContext);
                }
                if (tlog.isDebugEnabled()) {
                    t5 = System.currentTimeMillis();
                    tlog.debug((Object)("AxisServer.invoke2  preTr=" + (t1 - t0) + " tr=" + (t2 - t1) + " preInvoke=" + (t3 - t2) + " invoke=" + (t4 - t3) + " postInvoke=" + (t5 - t4) + " " + msgContext.getTargetService() + "." + (msgContext.getOperation() == null ? "" : msgContext.getOperation().getName())));
                }
            }
            catch (AxisFault e) {
                throw e;
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
            finally {
                AxisServer.setCurrentMessageContext(previousContext);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AxisServer::invoke");
        }
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        block21: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enter: AxisServer::generateWSDL");
            }
            if (!this.isRunning()) {
                throw new AxisFault("Server.disabled", Messages.getMessage("serverDisabled00"), null, null);
            }
            String hName = null;
            Handler h = null;
            MessageContext previousContext = AxisServer.getCurrentMessageContext();
            try {
                AxisServer.setCurrentMessageContext(msgContext);
                hName = msgContext.getStrProp("engine.handler");
                if (hName != null) {
                    h = this.getHandler(hName);
                    if (h == null) {
                        ClassLoader cl = msgContext.getClassLoader();
                        try {
                            log.debug((Object)Messages.getMessage("tryingLoad00", hName));
                            Class cls = ClassUtils.forName(hName, true, cl);
                            h = (Handler)cls.newInstance();
                        }
                        catch (Exception e) {
                            throw new AxisFault("Server.error", Messages.getMessage("noHandler00", hName), null, null);
                        }
                    }
                    h.generateWSDL(msgContext);
                    break block21;
                }
                log.debug((Object)Messages.getMessage("defaultLogic00"));
                hName = msgContext.getTransportName();
                SimpleTargetedChain transportChain = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage("transport01", "AxisServer.generateWSDL", hName));
                }
                if (hName != null && (h = this.getTransport(hName)) != null && h instanceof SimpleTargetedChain && (h = (transportChain = (SimpleTargetedChain)h).getRequestHandler()) != null) {
                    h.generateWSDL(msgContext);
                }
                if ((h = this.getGlobalRequest()) != null) {
                    h.generateWSDL(msgContext);
                }
                if ((h = msgContext.getService()) == null) {
                    Message rm = msgContext.getRequestMessage();
                    if (rm != null) {
                        rm.getSOAPEnvelope().getFirstBody();
                        h = msgContext.getService();
                    }
                    if (h == null) {
                        throw new AxisFault(Constants.QNAME_NO_SERVICE_FAULT_CODE, Messages.getMessage("noService05", "" + msgContext.getTargetService()), null, null);
                    }
                }
                h.generateWSDL(msgContext);
                h = this.getGlobalResponse();
                if (h != null) {
                    h.generateWSDL(msgContext);
                }
                if (transportChain != null && (h = transportChain.getResponseHandler()) != null) {
                    h.generateWSDL(msgContext);
                }
            }
            catch (AxisFault e) {
                throw e;
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
            finally {
                AxisServer.setCurrentMessageContext(previousContext);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AxisServer::generateWSDL");
        }
    }
}

