/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.handlers;

import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.message.SOAPHeaderElementAxisImpl;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class DebugHandler
extends BasicHandler {
    private static Logger log = Logger.getLogger((String)DebugHandler.class.getName());
    public static final String NS_URI_DEBUG = "http://xml.apache.org/axis/debug";

    public void invoke(MessageContext msgContext) throws AxisFault {
        log.debug((Object)"Enter: DebugHandler::invoke");
        try {
            Message msg = msgContext.getRequestMessage();
            SOAPEnvelopeAxisImpl message = msg.getSOAPEnvelope();
            SOAPHeaderElementAxisImpl header = message.getHeaderByName(NS_URI_DEBUG, "Debug");
            if (header != null) {
                Integer i = (Integer)header.getValueAsType(Constants.XSD_INT);
                if (i == null) {
                    throw new AxisFault(Messages.getMessage("cantConvert03"));
                }
                int debugVal = i;
                log.debug((Object)Messages.getMessage("debugLevel00", "" + debugVal));
                header.setProcessed(true);
            }
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        log.debug((Object)"Exit: DebugHandler::invoke");
    }

    public void onFault(MessageContext msgContext) {
        log.debug((Object)"Enter: DebugHandler::onFault");
        log.debug((Object)"Exit: DebugHandler::onFault");
    }
}

