/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.jboss.metadata.WebMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.util.NestedRuntimeException;
import org.jboss.web.tomcat.tc5.session.AttributeBasedClusteredSession;
import org.jboss.web.tomcat.tc5.session.ClusteredSession;
import org.jboss.web.tomcat.tc5.session.ClusteredSessionValve;
import org.jboss.web.tomcat.tc5.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.tc5.session.InstantSnapshotManager;
import org.jboss.web.tomcat.tc5.session.IntervalSnapshotManager;
import org.jboss.web.tomcat.tc5.session.JBossCacheCluster;
import org.jboss.web.tomcat.tc5.session.JBossCacheService;
import org.jboss.web.tomcat.tc5.session.JBossManager;
import org.jboss.web.tomcat.tc5.session.JvmRouteValve;
import org.jboss.web.tomcat.tc5.session.SessionBasedClusteredSession;
import org.jboss.web.tomcat.tc5.session.SnapshotManager;

public class JBossCacheManager
extends JBossManager {
    private static final String info_ = "JBossCacheManager/1.0";
    private JBossCacheService proxy_;
    private String cacheObjectNameString_ = "jboss.cache:service=TomcatClusteringCache";
    private boolean useJK_ = false;
    private boolean embedded_ = false;
    private MBeanServer mserver_ = null;
    private String snapshotMode_ = null;
    private int snapshotInterval_ = 0;
    private String replTriggerString_ = null;
    private String replGranularityString_ = null;
    protected TransactionManager tm;

    public void init(String name, WebMetaData webMetaData, boolean useJK, boolean useLocalCache) throws ClusteringNotSupportedException {
        super.init(name, webMetaData, useJK, useLocalCache);
        this.useJK_ = useJK;
        try {
            this.proxy_ = new JBossCacheService();
        }
        catch (Throwable t) {
            String str = "JBossCacheService to Tomcat clustering not found";
            this.log_.error((Object)str);
            throw new ClusteringNotSupportedException(str);
        }
        this.embedded_ = true;
    }

    public JBossCacheService getCacheService() {
        return this.proxy_;
    }

    public String getCacheObjectNameString() {
        return this.cacheObjectNameString_;
    }

    public void setCacheObjectNameString(String treeCacheObjectName) {
        this.cacheObjectNameString_ = treeCacheObjectName;
    }

    public String getSnapshotMode() {
        return this.snapshotMode_;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode_ = snapshotMode;
    }

    public int getSnapshotInterval() {
        return this.snapshotInterval_;
    }

    public void setSnapshotInterval(int snapshotInterval) {
        this.snapshotInterval_ = snapshotInterval;
    }

    public boolean getUseJK() {
        return this.useJK_;
    }

    public void setUseJK(boolean useJK) {
        this.useJK_ = useJK;
    }

    public String getReplicationGranularityString() {
        return this.replGranularityString_;
    }

    public void setReplicationGranularityString(String granularity) {
        this.replGranularityString_ = granularity;
    }

    public String getReplicationTriggerString() {
        return this.replTriggerString_;
    }

    public void setReplicationTriggerString(String trigger) {
        this.replTriggerString_ = trigger;
    }

    public void setUseLocalCache(boolean useLocalCache) {
        this.useLocalCache_ = useLocalCache;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public void setTransactionManager(TransactionManager manager) {
        this.tm = manager;
    }

    public void start() throws LifecycleException {
        if (this.embedded_) {
            this.startEmbedded();
        } else {
            this.startUnembedded();
        }
    }

    public void stop() throws LifecycleException {
        this.clearSessions();
        if (this.embedded_) {
            this.stopEmbedded();
        } else {
            this.stopUnembedded();
        }
    }

    protected void clearSessions() {
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Session ses = sessions[i];
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("clearSessions(): clear session by expiring: " + ses));
            }
            ses.expire();
        }
    }

    public Session createSession() {
        return this.createSession(null);
    }

    public Session createSession(String sessionId) {
        ClusteredSession session = null;
        if (this.replicationGranularity_ == 1) {
            session = new AttributeBasedClusteredSession(this);
        } else if (this.replicationGranularity_ == 0) {
            session = new SessionBasedClusteredSession(this);
        }
        session.setNew(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval_);
        if (sessionId == null) {
            sessionId = this.getNextId();
            if (this.useJK_) {
                if (this.log_.isDebugEnabled()) {
                    this.log_.debug((Object)("createSession(): useJK is true. Will append JvmRoute: " + this.getJvmRoute()));
                }
                sessionId = sessionId + "." + this.getJvmRoute();
            }
        }
        session.setValid(true);
        session.setId(sessionId);
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Creating an ClusteredSession with id: " + session.getId()));
        }
        ++this.createdCounter_;
        return session;
    }

    public boolean storeSession(Session baseSession) {
        if (baseSession == null) {
            throw new IllegalArgumentException("storeSession(): session is null");
        }
        if (!(baseSession instanceof ClusteredSession)) {
            throw new IllegalArgumentException("You can only add ClusteredSessions to this Manager. Session class name: " + baseSession.getClass().getName());
        }
        ClusteredSession session = (ClusteredSession)baseSession;
        if (session == null) {
            return false;
        }
        if (session.isValid()) {
            this.sessions_.put(this.getRealId(session.getId()), session);
            String id = session.getId();
            long beginPassivate = System.currentTimeMillis();
            session.passivate();
            long endPassivate = System.currentTimeMillis();
            this.stats_.updatePassivationStats(id, endPassivate - beginPassivate);
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("check to see if needs to store and replicate session with id " + id));
            }
            long beginReplication = System.currentTimeMillis();
            this.processSessionRepl(session);
            long endReplication = System.currentTimeMillis();
            this.stats_.updateReplicationStats(id, endReplication - beginReplication);
            return true;
        }
        return false;
    }

    public void add(Session session) {
        if (session == null) {
            return;
        }
        if (!session.isValid()) {
            this.log_.error((Object)("Cannot add session with id=" + session.getId() + " because it is invalid"));
            return;
        }
        if (this.maxActive_ != -1 && this.activeCounter_ >= this.maxActive_) {
            ++this.rejectedCounter_;
            throw new IllegalStateException("JBossCacheManager.add(): number of active sessions exceeds the maximum limit: " + this.maxActive_ + " when trying to add session id " + session.getId());
        }
        if (this.storeSession(session)) {
            ++this.activeCounter_;
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Session with id=" + session.getId() + " added. Current active sessions " + this.activeCounter_));
            }
        }
    }

    public Session createEmptySession() {
        ClusteredSession session = null;
        if (this.replicationGranularity_ == 1) {
            session = new AttributeBasedClusteredSession(this);
        } else if (this.replicationGranularity_ == 0) {
            session = new SessionBasedClusteredSession(this);
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Creating an empty ClusteredSession: " + session));
        }
        ++this.createdCounter_;
        return session;
    }

    public Session findSession(String id) {
        String realId = this.getRealId(id);
        ClusteredSession session = this.findLocalSession(realId);
        if (session != null && !session.isOutdated()) {
            return session;
        }
        return this.loadSession(realId);
    }

    public Session[] findSessions() {
        List ids = this.proxy_.getNewSessionsInStore();
        if (ids.size() == 0) {
            Session[] sess = new Session[]{};
            sess = this.sessions_.values().toArray(sess);
            return sess;
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("findSessions: find ids from cache store: " + ids));
        }
        for (int i = 0; i < ids.size(); ++i) {
            Session session = this.loadSession((String)ids.get(i));
            if (session == null) continue;
            this.sessions_.put(ids.get(i), session);
        }
        Session[] sess = new Session[]{};
        sess = this.sessions_.values().toArray(sess);
        return sess;
    }

    public ClusteredSession[] findLocalSessions() {
        ClusteredSession[] sess = new ClusteredSession[]{};
        sess = this.sessions_.values().toArray(sess);
        return sess;
    }

    public ClusteredSession findLocalSession(String realId) {
        ClusteredSession session = (ClusteredSession)this.sessions_.get(realId);
        return session;
    }

    public void remove(Session session) {
        String id = session.getId();
        if (id == null) {
            return;
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Removing session from store with id: " + id));
        }
        ((ClusteredSession)session).removeMyself();
        this.sessions_.remove(this.getRealId(session.getId()));
        --this.activeCounter_;
    }

    public void removeLocal(Session session) {
        String id = session.getId();
        if (id == null) {
            return;
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Removing session from local store with id: " + id));
        }
        ((ClusteredSession)session).removeMyselfLocal();
        this.sessions_.remove(this.getRealId(session.getId()));
        ++this.expiredCounter_;
        --this.activeCounter_;
    }

    protected Session loadSession(String realId) {
        ClusteredSession session = null;
        if (realId == null) {
            return null;
        }
        session = (ClusteredSession)this.sessions_.get(realId);
        if (session == null) {
            session = (ClusteredSession)this.createEmptySession();
        }
        if ((session = this.proxy_.loadSession(realId, session)) != null) {
            session.initAfterLoad(this);
            this.sessions_.put(this.getRealId(session.getId()), session);
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("loadSession(): id= " + realId + ", session=" + session));
        }
        return session;
    }

    protected void processSessionRepl(ClusteredSession session) {
        boolean doTx = false;
        try {
            if (this.tm.getTransaction() == null) {
                doTx = true;
            }
            if (doTx) {
                this.tm.begin();
            }
            session.processSessionRepl();
        }
        catch (Exception ex) {
            this.log_.error((Object)("processSessionRepl: failed with exception: " + ex));
            try {
                this.tm.setRollbackOnly();
            }
            catch (Exception exn) {
                exn.printStackTrace();
            }
            throw new NestedRuntimeException("JBossCacheManager.processSessionRepl(): failed to replicate session.", (Throwable)ex);
        }
        finally {
            if (doTx) {
                this.endTransaction();
            }
        }
    }

    protected void endTransaction() {
        try {
            if (this.tm.getTransaction().getStatus() != 1) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NestedRuntimeException("TreeCacheAop.endTransaction(): ", (Throwable)e);
        }
    }

    protected void processExpires() {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)"Looking for sessions that have expired ...");
        }
        try {
            Session[] sessions = this.findSessions();
            for (int i = 0; i < sessions.length; ++i) {
                ClusteredSession session = (ClusteredSession)sessions[i];
                if (session == null) {
                    this.log_.warn((Object)("processExpires(): processing null session at index " + i));
                    continue;
                }
                boolean doTx = false;
                try {
                    if (this.tm.getTransaction() == null) {
                        doTx = true;
                    }
                    if (doTx) {
                        this.tm.begin();
                    }
                    if (session.isValid()) continue;
                    continue;
                }
                catch (Exception ex) {
                    this.log_.error((Object)("processSessionExpire: failed with exception: " + ex));
                    try {
                        this.tm.setRollbackOnly();
                    }
                    catch (Exception exn) {
                        exn.printStackTrace();
                    }
                    throw new NestedRuntimeException("JBossCacheManager.processSessionExpire(): failed to expire session.", (Throwable)ex);
                }
                finally {
                    if (doTx) {
                        this.endTransaction();
                    }
                }
            }
        }
        catch (Exception ex) {
            this.log_.error((Object)("processExpires: failed with exception: " + ex));
            ex.printStackTrace();
        }
    }

    private String getRealId(String id) {
        if (!this.useJK_) {
            return id;
        }
        int index = id.indexOf(".");
        if (index > 0) {
            return id.substring(0, id.indexOf("."));
        }
        return id;
    }

    private void installJvmRouteValve() throws Exception {
        this.log_.info((Object)"We are using mod_jk(2) for load-balancing. Will add JvmRouteValve.");
        JvmRouteValve valve = new JvmRouteValve(this);
        if (this.embedded_ && this.getContextObjectName() != null) {
            this.getMBeanServer().invoke(this.getContextObjectName(), "addValve", new Object[]{valve}, new String[]{"org.apache.catalina.Valve"});
        } else if (this.container_ instanceof ContainerBase) {
            ((ContainerBase)this.container_).addValve((Valve)valve);
        } else {
            this.container_.getPipeline().addValve((Valve)valve);
        }
    }

    private void startEmbedded() throws LifecycleException {
        super.start();
        try {
            this.tm = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
        }
        catch (Exception e) {
            this.log_.error((Object)"Cannot get a reference to the transaction manager", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
        try {
            if (this.useJK_) {
                this.installJvmRouteValve();
            }
            this.installSnapshotValve();
            ClassLoader tcl = super.getContainer().getLoader().getClassLoader();
            this.proxy_.start(tcl, this);
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)"start(): JBossCacheService started");
            }
        }
        catch (Exception e) {
            this.log_.error((Object)"Exception starting JBossCacheManager", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
    }

    private void stopEmbedded() throws LifecycleException {
        super.stop();
        this.proxy_.stop();
        this.tm = null;
    }

    private void startUnembedded() throws LifecycleException {
        if (this.started_) {
            return;
        }
        if (this.log_.isInfoEnabled()) {
            this.log_.info((Object)"Manager is about to start");
        }
        this.lifecycle_.fireLifecycleEvent("before_start", (Object)this);
        if (this.tm == null) {
            try {
                JBossCacheCluster cluster = (JBossCacheCluster)this.container_.getCluster();
                cluster.configureManager(this);
            }
            catch (ClassCastException e) {
                String msg = "Cluster is not an instance of JBossCacheCluster";
                this.log_.error((Object)msg, (Throwable)e);
                throw new LifecycleException(msg, (Throwable)e);
            }
        }
        if ("SET_AND_GET".equalsIgnoreCase(this.replTriggerString_)) {
            this.invalidateSessionPolicy_ = 1;
        } else if ("SET_AND_NON_PRIMITIVE_GET".equalsIgnoreCase(this.replTriggerString_)) {
            this.invalidateSessionPolicy_ = 2;
        } else if ("SET".equalsIgnoreCase(this.replTriggerString_)) {
            this.invalidateSessionPolicy_ = 3;
        } else {
            throw new LifecycleException("replication-trigger value set to a non-valid value: '" + this.replTriggerString_ + "' (should be ['SET_AND_GET', " + "'SET_AND_NON_PRIMITIVE_GET', 'SET'])");
        }
        if ("SESSION".equalsIgnoreCase(this.replGranularityString_)) {
            this.replicationGranularity_ = 0;
        } else if ("ATTRIBUTE".equalsIgnoreCase(this.replGranularityString_)) {
            this.replicationGranularity_ = 1;
        } else {
            throw new LifecycleException("replication-granularity value set to a non-valid value: '" + this.replGranularityString_ + "' (should be ['SESSION', " + "'ATTRIBUTE'])");
        }
        try {
            this.proxy_ = new JBossCacheService(this.cacheObjectNameString_);
            ClassLoader cl = this.container_.getLoader().getClassLoader();
            this.proxy_.start(cl, this);
        }
        catch (Throwable t) {
            String str = "JBossCacheService to Tomcat clustering not found";
            this.log_.error((Object)str);
            throw new LifecycleException(str, t);
        }
        try {
            if (this.useJK_) {
                this.installJvmRouteValve();
            }
            this.installSnapshotValve();
            this.started_ = true;
            this.lifecycle_.fireLifecycleEvent("after_start", (Object)this);
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)"start(): JBossCacheService started");
            }
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
        try {
            this.registerMBeans();
        }
        catch (Exception e) {
            this.log_.error((Object)"Could not register ManagerMBean with MBeanServer", (Throwable)e);
        }
    }

    private void stopUnembedded() {
        this.resetStats();
        if (!this.started_) {
            throw new IllegalStateException("Manager not started");
        }
        this.lifecycle_.fireLifecycleEvent("before_stop", (Object)this);
        this.proxy_.stop();
        this.tm = null;
        this.started_ = false;
        this.lifecycle_.fireLifecycleEvent("after_stop", (Object)this);
        try {
            this.unregisterMBeans();
        }
        catch (Exception e) {
            this.log_.error((Object)"Could not unregister ManagerMBean from MBeanServer", (Throwable)e);
        }
    }

    private void registerMBeans() {
        try {
            MBeanServer server = this.getMBeanServer();
            String domain = this.container_ instanceof ContainerBase ? ((ContainerBase)this.container_).getDomain() : server.getDefaultDomain();
            String hostName = ((Host)this.container_.getParent()).getName();
            hostName = hostName == null ? "localhost" : hostName;
            ObjectName clusterName = new ObjectName(domain + ":service=ClusterManager,WebModule=//" + hostName + ((Context)this.container_).getPath());
            if (server.isRegistered(clusterName)) {
                this.log_.warn((Object)("MBean " + clusterName + " already registered"));
                return;
            }
            this.objectName_ = clusterName;
            server.registerMBean(this, clusterName);
        }
        catch (Exception ex) {
            this.log_.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void unregisterMBeans() {
        if (this.mserver_ != null) {
            try {
                this.mserver_.unregisterMBean(this.objectName_);
            }
            catch (Exception e) {
                this.log_.error((Object)e);
            }
        }
    }

    private MBeanServer getMBeanServer() throws Exception {
        if (this.mserver_ == null) {
            this.mserver_ = MBeanServerLocator.locateJBoss();
        }
        return this.mserver_;
    }

    private void installSnapshotValve() throws Exception {
        String ctxPath = ((Context)this.container_).getPath();
        SnapshotManager snap = null;
        if ("instant".equals(this.snapshotMode_)) {
            snap = new InstantSnapshotManager(this, ctxPath);
        } else if ("interval".equals(this.snapshotMode_)) {
            snap = new IntervalSnapshotManager(this, ctxPath, this.snapshotInterval_);
        } else {
            this.log_.error((Object)"Snapshot mode must be 'instant' or 'interval' - using 'instant'");
            snap = new InstantSnapshotManager(this, ctxPath);
        }
        ClusteredSessionValve valve = new ClusteredSessionValve(snap);
        if (this.embedded_ && this.getContextObjectName() != null) {
            this.getMBeanServer().invoke(this.getContextObjectName(), "addValve", new Object[]{valve}, new String[]{"org.apache.catalina.Valve"});
        } else if (this.container_ instanceof ContainerBase) {
            ((ContainerBase)this.container_).addValve((Valve)valve);
        } else {
            this.container_.getPipeline().addValve((Valve)valve);
        }
    }

    private ObjectName getContextObjectName() {
        String oname = this.container_.getObjectName();
        try {
            return oname == null ? null : new ObjectName(oname);
        }
        catch (MalformedObjectNameException e) {
            this.log_.warn((Object)("Error creating object name from string " + oname), (Throwable)e);
            return null;
        }
    }
}

