/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.standalone;

import gnu.trove.TLongObjectHashMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jboss.aop.AspectManager;
import org.jboss.aop.CallerConstructorInfo;
import org.jboss.aop.CallerMethodInfo;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AbstractAdvice;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.CFlowInterceptor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.metadata.ConstructorMetaData;
import org.jboss.aop.metadata.FieldMetaData;
import org.jboss.aop.metadata.MethodMetaData;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.standalone.Package;

public class XmlReport {
    public static String toXml() {
        Package root = Package.aopClassMap();
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<aop-report>");
        XmlReport.outputPackage(1, pw, root);
        XmlReport.outputUnboundBindings(1, pw);
        pw.println("</aop-report>");
        pw.flush();
        return writer.toString();
    }

    private static String getIndent(int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void indenter(Writer w, int indent) {
        try {
            w.write(XmlReport.getIndent(indent));
        }
        catch (IOException e) {
            throw new RuntimeException("IOException in indent", e);
        }
    }

    protected static String simpleType(Class type) {
        Class<?> ret = type;
        if (ret.isArray()) {
            Class<?> arr = ret;
            String array = "";
            while (arr.isArray()) {
                array = array + "[]";
                arr = arr.getComponentType();
            }
            return arr.getName();
        }
        return ret.getName();
    }

    public static void outputPackage(int indent, PrintWriter pw, Package root) {
        Map.Entry entry;
        Iterator it = root.packages.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            String pkgName = (String)entry.getKey();
            XmlReport.indenter(pw, indent);
            pw.println("<package name=\"" + pkgName + "\">");
            Package p = (Package)entry.getValue();
            XmlReport.outputPackage(indent + 1, pw, p);
            XmlReport.indenter(pw, indent);
            pw.println("</package>");
        }
        it = root.advisors.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            String classname = (String)entry.getKey();
            XmlReport.indenter(pw, indent);
            pw.println("<class name=\"" + classname + "\">");
            ClassAdvisor advisor = (ClassAdvisor)entry.getValue();
            XmlReport.outputAdvisor(indent + 1, pw, advisor, classname);
            XmlReport.indenter(pw, indent);
            pw.println("</class>");
        }
    }

    public static void outputAdvisor(int indent, PrintWriter pw, ClassAdvisor advisor, String baseName) {
        Field f;
        Interceptor[] chain;
        int i;
        ArrayList introductions = advisor.getInterfaceIntroductions();
        if (introductions != null && introductions.size() > 0) {
            XmlReport.indenter(pw, indent);
            pw.println("<introductions>");
            ++indent;
            for (i = 0; i < introductions.size(); ++i) {
                int j;
                InterfaceIntroduction pointcut = (InterfaceIntroduction)introductions.get(i);
                XmlReport.indenter(pw, indent);
                pw.println("<introduction classExpr=\"" + pointcut.getClassExpr() + "\">");
                ++indent;
                String[] intfs = pointcut.getInterfaces();
                ArrayList mixins = pointcut.getMixins();
                if (intfs != null && intfs.length > 0) {
                    for (j = 0; j < intfs.length; ++j) {
                        XmlReport.indenter(pw, indent);
                        pw.println("<interface class=\"" + intfs[j] + "\"/>");
                    }
                } else if (mixins != null && mixins.size() > 0) {
                    for (j = 0; j < mixins.size(); ++j) {
                        InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mixins.get(j);
                        String[] mixifs = mixin.getInterfaces();
                        for (int k = 0; k < mixifs.length; ++k) {
                            XmlReport.indenter(pw, indent);
                            pw.println("<interface class=\"" + mixifs[j] + "\"/>");
                        }
                        XmlReport.indenter(pw, indent);
                        pw.println("<mixin class=\"" + mixin.getClassName() + "\"/>");
                    }
                }
                XmlReport.indenter(pw, --indent);
                pw.println("</introduction>");
            }
            XmlReport.indenter(pw, --indent);
            pw.println("</introductions>");
        }
        XmlReport.indenter(pw, indent);
        pw.println("<constructors>");
        ++indent;
        for (i = 0; i < advisor.getConstructors().length; ++i) {
            Constructor con = advisor.getConstructors()[i];
            chain = advisor.getConstructorInterceptors()[i];
            HashMap methodCallers = advisor.getMethodCalledByConInterceptors()[i];
            HashMap conCallers = advisor.getConCalledByConInterceptors()[i];
            if ((chain == null || chain.length <= 0) && methodCallers == null && conCallers == null) continue;
            XmlReport.indenter(pw, indent);
            pw.println("<constructor signature=\"" + con.toString() + "\">");
            if (chain != null && chain.length > 0) {
                XmlReport.outputChain(indent + 1, pw, chain);
            }
            if (methodCallers != null) {
                XmlReport.outputMethodCallers(indent + 1, pw, methodCallers);
            }
            if (conCallers != null) {
                XmlReport.outputConCallers(indent + 1, pw, conCallers);
            }
            XmlReport.indenter(pw, indent);
            pw.println("</constructor>");
        }
        XmlReport.indenter(pw, --indent);
        pw.println("</constructors>");
        XmlReport.indenter(pw, indent);
        pw.println("<fields-read>");
        ++indent;
        for (i = 0; i < advisor.getAdvisedFields().length; ++i) {
            f = advisor.getAdvisedFields()[i];
            chain = advisor.getFieldReadInterceptors()[i];
            if (chain == null || chain.length <= 0) continue;
            XmlReport.indenter(pw, indent);
            pw.println("<field name=\"" + f.getName() + "\">");
            XmlReport.outputChain(indent + 1, pw, chain);
            XmlReport.indenter(pw, indent);
            pw.println("</field>");
        }
        XmlReport.indenter(pw, --indent);
        pw.println("</fields-read>");
        XmlReport.indenter(pw, indent);
        pw.println("<fields-write>");
        ++indent;
        for (i = 0; i < advisor.getAdvisedFields().length; ++i) {
            f = advisor.getAdvisedFields()[i];
            chain = advisor.getFieldWriteInterceptors()[i];
            if (chain == null || chain.length <= 0) continue;
            XmlReport.indenter(pw, indent);
            pw.println("<field name=\"" + f.getName() + "\">");
            XmlReport.outputChain(indent + 1, pw, chain);
            XmlReport.indenter(pw, indent);
            pw.println("</field>");
        }
        XmlReport.indenter(pw, --indent);
        pw.println("</fields-write>");
        XmlReport.indenter(pw, indent);
        pw.println("<methods>");
        ++indent;
        long[] keys = advisor.getMethodInterceptors().keys();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            Interceptor[] chain2;
            long key = keys[i2];
            MethodInfo method = (MethodInfo)advisor.getMethodInterceptors().get(key);
            HashMap methodCallers = (HashMap)advisor.getMethodCalledByMethodInterceptors().get(key);
            HashMap conCallers = (HashMap)advisor.getConCalledByMethodInterceptors().get(key);
            if (method == null && methodCallers == null || method != null && methodCallers == null && (method.interceptors == null || method.interceptors.length < 1)) continue;
            XmlReport.indenter(pw, indent);
            pw.println("<method signature=\"" + method.advisedMethod.toString() + "\">");
            if (method != null && (chain2 = method.interceptors) != null && chain2.length > 0) {
                XmlReport.outputChain(indent + 1, pw, chain2);
            }
            if (methodCallers != null) {
                XmlReport.outputMethodCallers(indent + 1, pw, methodCallers);
            }
            if (conCallers != null) {
                XmlReport.outputConCallers(indent + 1, pw, conCallers);
            }
            XmlReport.indenter(pw, indent);
            pw.println("</method>");
        }
        XmlReport.indenter(pw, --indent);
        pw.println("</methods>");
        XmlReport.outputMetadata(indent, pw, advisor);
    }

    public static void outputMethodCallers(int indent, PrintWriter pw, HashMap called) {
        XmlReport.indenter(pw, indent);
        pw.println("<method-callers>");
        ++indent;
        Iterator it = called.values().iterator();
        while (it.hasNext()) {
            TLongObjectHashMap map = (TLongObjectHashMap)it.next();
            Object[] values = map.getValues();
            for (int i = 0; i < values.length; ++i) {
                CallerMethodInfo caller = (CallerMethodInfo)values[i];
                XmlReport.indenter(pw, indent);
                if (caller.interceptors != null) {
                    pw.println("<called-method signature=\"" + caller.method + "\">");
                    XmlReport.outputChain(indent + 1, pw, caller.interceptors);
                    XmlReport.indenter(pw, indent);
                    pw.println("</called-method>");
                    continue;
                }
                pw.println("<called-method signature=\"" + caller.method + "\"/>");
            }
        }
        XmlReport.indenter(pw, --indent);
        pw.println("</method-callers>");
    }

    public static void outputConCallers(int indent, PrintWriter pw, HashMap called) {
        XmlReport.indenter(pw, indent);
        pw.println("<constructor-callers>");
        ++indent;
        Iterator it = called.values().iterator();
        while (it.hasNext()) {
            TLongObjectHashMap map = (TLongObjectHashMap)it.next();
            Object[] values = map.getValues();
            for (int i = 0; i < values.length; ++i) {
                CallerConstructorInfo caller = (CallerConstructorInfo)values[i];
                XmlReport.indenter(pw, indent);
                if (caller.interceptors != null) {
                    pw.println("<called-constructor signature=\"" + caller.constructor + "\">");
                    XmlReport.outputChain(indent + 1, pw, caller.interceptors);
                    XmlReport.indenter(pw, indent);
                    pw.println("</called-constructor>");
                    continue;
                }
                pw.println("<called-constructor signature=\"" + caller.constructor + "\"/>");
            }
        }
        XmlReport.indenter(pw, --indent);
        pw.println("</constructor-callers>");
    }

    public static void outputChain(int indent, PrintWriter pw, Interceptor[] chain) {
        XmlReport.indenter(pw, indent);
        pw.println("<interceptors>");
        ++indent;
        for (int i = 0; i < chain.length; ++i) {
            if (chain[i] instanceof AbstractAdvice) {
                XmlReport.indenter(pw, indent);
                pw.println("<advice name=\"" + chain[i].getName() + "\"/>");
                continue;
            }
            if (chain[i] instanceof CFlowInterceptor) {
                XmlReport.indenter(pw, indent);
                pw.println("<cflow expr=\"" + ((CFlowInterceptor)chain[i]).getCFlowString() + "\"/>");
                continue;
            }
            XmlReport.indenter(pw, indent);
            pw.println("<interceptor class=\"" + chain[i].getClass().getName() + "\"/>");
        }
        XmlReport.indenter(pw, --indent);
        pw.println("</interceptors>");
    }

    public static void outputUnboundBindings(int indent, PrintWriter pw) {
        boolean first = true;
        Iterator it = AspectManager.instance().getBindings().values().iterator();
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (binding.hasAdvisors()) continue;
            if (first) {
                first = false;
                XmlReport.indenter(pw, indent);
                pw.println("<unbound-bindings>");
                ++indent;
            }
            XmlReport.indenter(pw, indent);
            pw.print("<binding pointcut=\"" + binding.getPointcut().getExpr() + "\"");
            if (binding.getCFlowString() != null) {
                pw.print(" cflow=\"" + binding.getCFlowString() + "\"");
            }
            pw.println(" />");
        }
        if (!first) {
            XmlReport.indenter(pw, --indent);
            pw.println("</unbound-bindings>");
        }
    }

    public static void outputMetadata(int indent, PrintWriter pw, ClassAdvisor advisor) {
        StringWriter sw = new StringWriter();
        PrintWriter metaWriter = new PrintWriter(sw);
        StringBuffer sb = new StringBuffer();
        sb.append(XmlReport.getDefaultMetadataXml(indent, metaWriter, advisor));
        sb.append(XmlReport.getClassMetadataXml(indent, metaWriter, advisor));
        sb.append(XmlReport.getConstructorMetadataXml(indent, pw, advisor));
        sb.append(XmlReport.getMethodMetadataXml(indent, pw, advisor));
        sb.append(XmlReport.getFieldMetadataXml(indent, pw, advisor));
        if (sb.length() > 0) {
            XmlReport.indenter(pw, indent);
            pw.println("<metadata>");
            pw.print(sb.toString());
            XmlReport.indenter(pw, indent);
            pw.println("</metadata>");
        }
    }

    public static String getDefaultMetadataXml(int indent, PrintWriter pw, ClassAdvisor advisor) {
        StringBuffer xml;
        SimpleMetaData metadata = advisor.getDefaultMetaData();
        if ((xml = XmlReport.getMetadataXml(++indent, advisor, metadata)) != null) {
            xml.insert(0, XmlReport.getIndent(indent) + "<default>\r\n");
            xml.append(XmlReport.getIndent(indent) + "</default>\r\n");
            return xml.toString();
        }
        --indent;
        return "";
    }

    public static String getClassMetadataXml(int indent, PrintWriter pw, ClassAdvisor advisor) {
        StringBuffer xml;
        SimpleMetaData metadata = advisor.getClassMetaData();
        if ((xml = XmlReport.getMetadataXml(++indent, advisor, metadata)) != null) {
            xml.insert(0, XmlReport.getIndent(indent) + "<class>\r\n");
            xml.append(XmlReport.getIndent(indent) + "</class>\r\n");
            return xml.toString();
        }
        --indent;
        return "";
    }

    public static String getFieldMetadataXml(int indent, PrintWriter pw, ClassAdvisor advisor) {
        FieldMetaData fieldMetaData = advisor.getFieldMetaData();
        StringBuffer xml = new StringBuffer();
        ++indent;
        Iterator it = fieldMetaData.getFields();
        while (it.hasNext()) {
            String field = (String)it.next();
            SimpleMetaData fieldData = fieldMetaData.getFieldMetaData(field);
            ++indent;
            StringBuffer sb = XmlReport.getMetadataXml(++indent, advisor, fieldData);
            --indent;
            --indent;
            if (sb == null) continue;
            xml.append(XmlReport.getIndent(++indent) + "<field name=\"" + field + "\">" + "\r\n");
            xml.append(sb);
            xml.append(XmlReport.getIndent(indent) + "</field>" + "\r\n");
            --indent;
        }
        if (xml.length() > 0) {
            xml.insert(0, XmlReport.getIndent(indent) + "<fields>" + "\r\n");
            xml.append(XmlReport.getIndent(indent) + "</fields>" + "\r\n");
        }
        --indent;
        return xml.toString();
    }

    public static String getConstructorMetadataXml(int indent, PrintWriter pw, ClassAdvisor advisor) {
        ConstructorMetaData constructorMetaData = advisor.getConstructorMetaData();
        StringBuffer xml = new StringBuffer();
        ++indent;
        Iterator it = constructorMetaData.getConstructors();
        while (it.hasNext()) {
            String constructor = (String)it.next();
            SimpleMetaData constructorData = constructorMetaData.getConstructorMetaData(constructor);
            ++indent;
            StringBuffer sb = XmlReport.getMetadataXml(++indent, advisor, constructorData);
            --indent;
            --indent;
            if (sb == null) continue;
            xml.append(XmlReport.getIndent(++indent) + "<constructor name=\"" + constructor + "\">" + "\r\n");
            xml.append(sb);
            xml.append(XmlReport.getIndent(indent) + "</constructor>" + "\r\n");
            --indent;
        }
        if (xml.length() > 0) {
            xml.insert(0, XmlReport.getIndent(indent) + "<constructors>" + "\r\n");
            xml.append(XmlReport.getIndent(indent) + "</constructors>" + "\r\n");
        }
        --indent;
        return xml.toString();
    }

    public static String getMethodMetadataXml(int indent, PrintWriter pw, ClassAdvisor advisor) {
        MethodMetaData methodMetaData = advisor.getMethodMetaData();
        StringBuffer xml = new StringBuffer();
        ++indent;
        Iterator it = methodMetaData.getMethods();
        while (it.hasNext()) {
            String method = (String)it.next();
            SimpleMetaData methodData = methodMetaData.getMethodMetaData(method);
            ++indent;
            StringBuffer sb = XmlReport.getMetadataXml(++indent, advisor, methodData);
            --indent;
            --indent;
            if (sb == null) continue;
            xml.append(XmlReport.getIndent(++indent) + "<method name=\"" + method + "\">" + "\r\n");
            xml.append(sb);
            xml.append(XmlReport.getIndent(indent) + "</method>" + "\r\n");
            --indent;
        }
        if (xml.length() > 0) {
            xml.insert(0, XmlReport.getIndent(indent) + "<methods>" + "\r\n");
            xml.append(XmlReport.getIndent(indent) + "</methods>" + "\r\n");
        }
        --indent;
        return xml.toString();
    }

    public static StringBuffer getMetadataXml(int indent, ClassAdvisor advisor, SimpleMetaData metadata) {
        StringWriter sw = new StringWriter();
        HashSet tags = metadata.tags();
        if (tags.size() == 0) {
            return null;
        }
        Iterator tagsIt = tags.iterator();
        while (tagsIt.hasNext()) {
            String tag = (String)tagsIt.next();
            HashMap groupAttrs = metadata.tag(tag);
            XmlReport.indenter(sw, ++indent);
            sw.write("<tag name=\"" + tag + "\">" + "\r\n");
            ++indent;
            if (groupAttrs == null) continue;
            boolean hasValues = false;
            Iterator attrsIt = groupAttrs.entrySet().iterator();
            while (attrsIt.hasNext()) {
                Map.Entry entry = attrsIt.next();
                String attr = (String)entry.getKey();
                if (attr.equals("$tagged$")) continue;
                hasValues = true;
                SimpleMetaData.MetaDataValue value = (SimpleMetaData.MetaDataValue)entry.getValue();
                XmlReport.indenter(sw, indent);
                sw.write("<attribute name=\"" + attr + "\">" + "\r\n");
                XmlReport.indenter(sw, ++indent);
                sw.write("<type>" + value.value.getClass().getName() + "</type>" + "\r\n");
                XmlReport.indenter(sw, indent);
                sw.write("<value-as-string>" + value.value.toString() + "</value-as-string>" + "\r\n");
                XmlReport.indenter(sw, indent);
                sw.write("<serialization>" + value.type + "</serialization>" + "\r\n");
                XmlReport.indenter(sw, --indent);
                sw.write("</attribute>\r\n");
            }
            if (!hasValues) {
                XmlReport.indenter(sw, indent);
                sw.write("<empty/>\r\n");
            }
            XmlReport.indenter(sw, --indent);
            sw.write("</tag>\r\n");
            --indent;
        }
        return sw.getBuffer();
    }
}

