/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import org.jboss.aop.annotation.PortableAnnotationElement;
import org.jboss.aop.util.ReflectToJavassist;

public class AnnotationElement
extends PortableAnnotationElement {
    public static Object getVisibleAnnotation(Method method, Class annotation) {
        try {
            CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
            if (ctMethod == null) {
                return null;
            }
            MethodInfo mi = ctMethod.getMethodInfo2();
            AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) {
                return null;
            }
            return AnnotationElement.create(visible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getVisibleAnnotation(Constructor con, Class annotation) {
        try {
            CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
            if (ctMethod == null) {
                return null;
            }
            MethodInfo mi = ctMethod.getMethodInfo2();
            AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) {
                return null;
            }
            return AnnotationElement.create(visible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getVisibleAnnotation(Field field, Class annotation) {
        try {
            CtField ctField = ReflectToJavassist.fieldToJavassist(field);
            FieldInfo mi = ctField.getFieldInfo2();
            AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) {
                return null;
            }
            return AnnotationElement.create(visible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getVisibleAnnotation(Class clazz, Class annotation) {
        try {
            ClassFile cf = AnnotationElement.getClassFile(clazz);
            AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) {
                return null;
            }
            return AnnotationElement.create(visible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isVisibleAnnotationPresent(Field field, Class annotation) throws Exception {
        CtField ctMethod = ReflectToJavassist.fieldToJavassist(field);
        return AnnotationElement.isVisibleAnnotationPresent(ctMethod, annotation.getName());
    }

    public static boolean isVisibleAnnotationPresent(Class clazz, Class annotation) throws Exception {
        ClassFile cf = AnnotationElement.getClassFile(clazz);
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return false;
        }
        return visible.getAnnotation(annotation.getName()) != null;
    }

    public static boolean isVisibleAnnotationPresent(Constructor con, Class annotation) throws Exception {
        CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
        return AnnotationElement.isVisibleAnnotationPresent(ctMethod, annotation.getName());
    }

    public static boolean isVisibleAnnotationPresent(Method method, Class annotation) throws Exception {
        CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
        if (ctMethod == null) {
            return false;
        }
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return false;
        }
        return visible.getAnnotation(annotation.getName()) != null;
    }
}

