/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.pointcut.AnnotationMatcher;

public class ReflectiveAspectBinder {
    protected Class clazz;
    protected HashSet aspects = new HashSet();
    protected HashMap methodAdvices = new HashMap();
    protected HashMap constructorAdvices = new HashMap();
    protected HashMap fieldReadAdvices = new HashMap();
    protected HashMap fieldWriteAdvices = new HashMap();
    protected Advisor advisor;

    public ReflectiveAspectBinder(Class clazz, Advisor advisor) {
        this.clazz = clazz;
        this.advisor = advisor;
        this.bindMethodAdvices();
        this.bindConstructorAdvices();
        this.bindFieldAdvices();
    }

    public Class getClazz() {
        return this.clazz;
    }

    public HashSet getAspects() {
        return this.aspects;
    }

    public HashMap getMethodAdvices() {
        return this.methodAdvices;
    }

    public HashMap getConstructorAdvices() {
        return this.constructorAdvices;
    }

    public HashMap getFieldReadAdvices() {
        return this.fieldReadAdvices;
    }

    public HashMap getFieldWriteAdvices() {
        return this.fieldWriteAdvices;
    }

    protected void bindMethodAdvices() {
        Method[] methods = this.clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.bindMethodAdvice(methods[i]);
        }
    }

    protected void bindConstructorAdvices() {
        Constructor<?>[] cons = this.clazz.getDeclaredConstructors();
        for (int i = 0; i < cons.length; ++i) {
            this.bindConstructorAdvice(cons[i]);
        }
    }

    protected void bindFieldAdvices() {
        Field[] fields = this.clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            this.bindFieldGetAdvice(fields[i]);
            this.bindFieldSetAdvice(fields[i]);
        }
    }

    protected boolean matches(AnnotationIntroduction ai, Object element) {
        AnnotationMatcher matcher = new AnnotationMatcher(this.advisor, element);
        return (Boolean)ai.getTarget().jjtAccept(matcher, null);
    }

    protected void bindMethodAdvice(Method mi) {
        LinkedHashMap repositoryBindings = this.advisor.getManager().getBindings();
        Iterator it = repositoryBindings.values().iterator();
        ArrayList<InterceptorFactory> advices = (ArrayList<InterceptorFactory>)this.methodAdvices.get(mi);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (!binding.getPointcut().matchesExecution(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList<InterceptorFactory>();
                this.methodAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindConstructorAdvice(Constructor mi) {
        LinkedHashMap repositoryBindings = this.advisor.getManager().getBindings();
        Iterator it = repositoryBindings.values().iterator();
        ArrayList<InterceptorFactory> advices = (ArrayList<InterceptorFactory>)this.constructorAdvices.get(mi);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (!binding.getPointcut().matchesExecution(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList<InterceptorFactory>();
                this.constructorAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindFieldGetAdvice(Field mi) {
        LinkedHashMap repositoryBindings = this.advisor.getManager().getBindings();
        Iterator it = repositoryBindings.values().iterator();
        ArrayList<InterceptorFactory> advices = (ArrayList<InterceptorFactory>)this.fieldReadAdvices.get(mi);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (!binding.getPointcut().matchesGet(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList<InterceptorFactory>();
                this.fieldReadAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindFieldSetAdvice(Field mi) {
        LinkedHashMap repositoryBindings = this.advisor.getManager().getBindings();
        Iterator it = repositoryBindings.values().iterator();
        ArrayList<InterceptorFactory> advices = (ArrayList<InterceptorFactory>)this.fieldWriteAdvices.get(mi);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (!binding.getPointcut().matchesSet(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList<InterceptorFactory>();
                this.fieldWriteAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }
}

