/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.aop.AspectManager;
import org.jboss.aop.DomainDefinition;
import org.jboss.aop.XmlLoader;
import org.jboss.aop.XmlLoaderFactory;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.AspectFactoryDelegator;
import org.jboss.aop.advice.DynamicCFlowDefinition;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PrecedenceDef;
import org.jboss.aop.advice.PrecedenceDefEntry;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopeUtil;
import org.jboss.aop.advice.ScopedInterceptorFactory;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.pointcut.CFlow;
import org.jboss.aop.pointcut.CFlowStack;
import org.jboss.aop.pointcut.DeclareDef;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.TypedefExpression;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.pointcut.ast.TypeExpressionParser;
import org.jboss.aop.util.XmlHelper;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AspectXmlLoader
implements XmlLoader {
    protected int counter;
    protected String defaultBaseName;
    protected AspectManager manager;
    protected ArrayList bindings = new ArrayList();
    protected ArrayList factories = new ArrayList();
    protected ArrayList aspects = new ArrayList();
    public static XmlLoaderFactory factory = null;

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    private String getName(Element element, String errorHeader) {
        String name = element.getAttribute("name");
        if (name != null && !name.equals("")) {
            return name;
        }
        return this.getName(errorHeader);
    }

    private String getName(String errorHeader) {
        return this.defaultBaseName + this.counter++;
    }

    public void undeployInterceptor(Element element) throws Exception {
        String factory;
        String clazz;
        String name = element.getAttribute("name");
        if (name != null && name.trim().equals("")) {
            name = null;
        }
        if ((clazz = element.getAttribute("class")) != null && clazz.trim().equals("")) {
            clazz = null;
        }
        if ((factory = element.getAttribute("factory")) != null && factory.trim().equals("")) {
            factory = null;
        }
        if (name == null) {
            name = clazz == null ? factory : clazz;
        }
        this.aspects.add(name);
        String factoryName = name + ".invoke";
        this.factories.add(factoryName);
    }

    public InterceptorFactory deployInterceptor(Element element) throws Exception {
        String s;
        String factory1;
        String clazz;
        String name = element.getAttribute("name");
        if (name != null && name.trim().equals("")) {
            name = null;
        }
        if ((clazz = element.getAttribute("class")) != null && clazz.trim().equals("")) {
            clazz = null;
        }
        if ((factory1 = element.getAttribute("factory")) != null && factory1.trim().equals("")) {
            factory1 = null;
        }
        if (clazz == null && factory1 == null) {
            throw new RuntimeException("Interceptor " + name + " must have a class or factory associated with it.");
        }
        if (clazz != null && factory1 != null) {
            throw new RuntimeException("Interceptor " + name + " cannot have both the class and factory attribute set.");
        }
        if (name == null) {
            String string = name = clazz == null ? factory1 : clazz;
        }
        if ((s = element.getAttribute("scope")) != null && s.trim().equals("")) {
            s = null;
        }
        Scope scope = null;
        if (s != null && (scope = ScopeUtil.parse(s)) == null) {
            throw new RuntimeException("Illegal scope attribute value: " + s);
        }
        AspectDefinition def = (AspectDefinition)this.manager.getAspectDefinitions().get(name);
        if (def != null) {
            if (scope == null) {
                scope = Scope.PER_VM;
            }
            if (scope != def.getScope()) {
                throw new RuntimeException("multiple definitions of <interceptor> " + name + " with different scopes is illegal");
            }
        } else {
            AspectFactory aspectFactory = clazz != null ? new GenericAspectFactory(clazz, element) : new AspectFactoryDelegator(factory1, element);
            def = new AspectDefinition(name, scope, aspectFactory);
            this.manager.addAspectDefinition(def);
        }
        ScopedInterceptorFactory factory = new ScopedInterceptorFactory(def);
        this.manager.addInterceptorFactory(factory.getName(), factory);
        return factory;
    }

    public void undeployAdvice(Element element) throws Exception {
        String name = element.getAttribute("name");
        String aspect = element.getAttribute("aspect");
        String factory = aspect + "." + name;
        this.factories.add(factory);
    }

    public InterceptorFactory deployAdvice(Element element) throws Exception {
        String name = element.getAttribute("name");
        String aspect = element.getAttribute("aspect");
        AspectDefinition def = this.manager.getAspectDefinition(aspect);
        if (def == null) {
            throw new RuntimeException("advice " + name + " cannot find aspect " + aspect);
        }
        AdviceFactory factory = new AdviceFactory(def, name);
        this.manager.addInterceptorFactory(factory.getName(), factory);
        return factory;
    }

    public void deployBinding(Element element) throws Exception {
        String name = this.getName(element, "binding");
        String pointcut = element.getAttribute("pointcut");
        if (pointcut == null || pointcut.trim().equals("")) {
            throw new RuntimeException("Binding must have a pointcut element associated with it.");
        }
        String cflow = element.getAttribute("cflow");
        if (cflow != null && cflow.trim().equals("")) {
            cflow = null;
        }
        ASTCFlowExpression cflowExpression = null;
        if (cflow != null) {
            try {
                cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
            }
            catch (ParseException e) {
                throw new RuntimeException(cflow, e);
            }
        }
        ArrayList interceptors = this.loadInterceptors(element);
        InterceptorFactory[] inters = interceptors.toArray(new InterceptorFactory[interceptors.size()]);
        PointcutExpression p = null;
        try {
            p = new PointcutExpression(this.getName("binding pointcut "), pointcut);
        }
        catch (ParseException ex) {
            throw new RuntimeException("<bind> pointcut expression failed: " + pointcut, ex);
        }
        AdviceBinding binding = new AdviceBinding(name, p, cflowExpression, cflow, inters);
        this.manager.addBinding(binding);
    }

    public void undeployBinding(Element element) throws Exception {
        String binding = this.getName(element, "binding");
        if (binding == null) {
            throw new RuntimeException("undeploying Binding that is null!");
        }
        this.bindings.add(binding);
        this.unloadInterceptors(element);
        String pointcut = this.getName("pointcut");
        this.manager.removePointcut(pointcut);
    }

    private void deployPrecedence(Element element) throws Exception {
        String name = this.getName(element, "precedence");
        ArrayList<PrecedenceDefEntry> precedenceEntries = new ArrayList<PrecedenceDefEntry>();
        NodeList children2 = element.getChildNodes();
        for (int j = 0; j < children2.getLength(); ++j) {
            if (children2.item(j).getNodeType() != 1) continue;
            Element interceptorElement = (Element)children2.item(j);
            String tag2 = interceptorElement.getTagName();
            if (tag2.equals("interceptor-ref")) {
                String iname = interceptorElement.getAttribute("name");
                if (iname == null || iname.length() == 0) {
                    throw new RuntimeException("name must be specified for interceptor-ref in precedence declaration");
                }
                precedenceEntries.add(new PrecedenceDefEntry(iname, null));
                continue;
            }
            if (tag2.equals("advice")) {
                String method = interceptorElement.getAttribute("name");
                String aspect = interceptorElement.getAttribute("aspect");
                if (method == null || method.length() == 0) {
                    throw new RuntimeException("name must be specified for advice in precedence declaration");
                }
                if (aspect == null || aspect.length() == 0) {
                    throw new RuntimeException("aspect must be specified for advice in precedence declaration");
                }
                precedenceEntries.add(new PrecedenceDefEntry(aspect, method));
                continue;
            }
            throw new RuntimeException("Invalid child element of precedence : " + tag2);
        }
        PrecedenceDefEntry[] entries = precedenceEntries.toArray(new PrecedenceDefEntry[precedenceEntries.size()]);
        this.manager.addPrecedence(new PrecedenceDef(name, entries));
    }

    private ArrayList loadInterceptors(Element element) throws Exception {
        ArrayList<InterceptorFactory> interceptors = new ArrayList<InterceptorFactory>();
        NodeList children2 = element.getChildNodes();
        for (int j = 0; j < children2.getLength(); ++j) {
            InterceptorFactory factory;
            if (children2.item(j).getNodeType() != 1) continue;
            Element interceptorElement = (Element)children2.item(j);
            String tag2 = interceptorElement.getTagName();
            if (tag2.equals("interceptor")) {
                factory = this.deployInterceptor(interceptorElement);
                interceptors.add(factory);
                continue;
            }
            if (tag2.equals("interceptor-ref")) {
                String iname = interceptorElement.getAttribute("name");
                if (iname == null) {
                    throw new RuntimeException("interceptor-ref has null name attribute");
                }
                InterceptorFactory factory2 = this.manager.getInterceptorFactory(iname);
                if (factory2 == null) {
                    throw new RuntimeException("unable to resolve interceptor-ref: " + iname);
                }
                interceptors.add(factory2);
                continue;
            }
            if (tag2.equals("stack-ref")) {
                String name = interceptorElement.getAttribute("name");
                AdviceStack stack = this.manager.getAdviceStack(name);
                if (stack == null) {
                    throw new Exception("there is no <stack> defined for name: " + name);
                }
                interceptors.addAll(stack.getInterceptorFactories());
                continue;
            }
            if (!tag2.equals("advice")) continue;
            factory = this.deployAdvice(interceptorElement);
            interceptors.add(factory);
        }
        return interceptors;
    }

    private void unloadInterceptors(Element element) throws Exception {
        NodeList children2 = element.getChildNodes();
        for (int j = 0; j < children2.getLength(); ++j) {
            if (children2.item(j).getNodeType() != 1) continue;
            Element interceptorElement = (Element)children2.item(j);
            String tag2 = interceptorElement.getTagName();
            if (tag2.equals("interceptor")) {
                this.undeployInterceptor(interceptorElement);
            }
            if (!tag2.equals("advice")) continue;
            this.undeployAdvice(interceptorElement);
        }
    }

    public void undeployAspect(Element pointcut) throws Exception {
        String name;
        String clazz = pointcut.getAttribute("class");
        if (clazz == null || clazz.trim().equals("")) {
            clazz = null;
        }
        if ((name = pointcut.getAttribute("name")) == null || name.trim().equals("")) {
            name = clazz;
        }
        if (name == null) {
            return;
        }
        this.aspects.add(name);
    }

    public AspectDefinition deployAspect(Element element, String type) throws Exception {
        String s;
        String factory;
        String clazz;
        String name = element.getAttribute("name");
        if (name != null && name.trim().equals("")) {
            name = null;
        }
        if ((clazz = element.getAttribute("class")) != null && clazz.trim().equals("")) {
            clazz = null;
        }
        if ((factory = element.getAttribute("factory")) != null && factory.trim().equals("")) {
            factory = null;
        }
        if (clazz == null && factory == null) {
            throw new RuntimeException(type + " " + name + " must have a class or factory associated with it.");
        }
        if (clazz != null && factory != null) {
            throw new RuntimeException(type + " " + name + " cannot have both the class and factory attribute set.");
        }
        if (name == null) {
            String string = name = clazz == null ? factory : clazz;
        }
        if ((s = element.getAttribute("scope")) != null && s.trim().equals("")) {
            s = null;
        }
        Scope scope = null;
        if (s != null && (scope = ScopeUtil.parse(s)) == null) {
            throw new RuntimeException("Illegal scope attribute value: " + s);
        }
        AspectFactory aspectFactory = clazz != null ? new GenericAspectFactory(clazz, element) : new AspectFactoryDelegator(factory, element);
        AspectDefinition def = new AspectDefinition(name, scope, aspectFactory);
        this.manager.addAspectDefinition(def);
        return def;
    }

    public void undeployCFlowStack(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        this.manager.removeCFlowStack(name);
    }

    public void deployCFlowStack(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        if (name != null && name.trim().equals("")) {
            name = null;
        }
        if (name == null) {
            throw new RuntimeException("name required for a cflow-stack");
        }
        CFlowStack stack = new CFlowStack(name);
        NodeList children2 = pointcut.getChildNodes();
        for (int j = 0; j < children2.getLength(); ++j) {
            if (children2.item(j).getNodeType() != 1) continue;
            Element cflowElement = (Element)children2.item(j);
            String tag2 = cflowElement.getTagName();
            String expr = cflowElement.getAttribute("expr");
            if (expr != null && expr.trim().equals("")) {
                throw new RuntimeException(tag2 + " requires an expr attribute to be defined");
            }
            if (tag2.equals("called")) {
                stack.addCFlow(new CFlow(expr, false));
            }
            if (!tag2.equals("not-called")) continue;
            stack.addCFlow(new CFlow(expr, true));
        }
        this.manager.addCFlowStack(stack);
    }

    public void undeployInterceptorStack(Element element) throws Exception {
        String name = element.getAttribute("name");
        this.unloadInterceptors(element);
        this.manager.removeInterceptorStack(name);
    }

    public void deployInterceptorStack(Element element) throws Exception {
        ArrayList interceptors = this.loadInterceptors(element);
        String name = element.getAttribute("name");
        AdviceStack stack = new AdviceStack(name, interceptors);
        this.manager.addAdviceStack(stack);
    }

    private ClassMetaDataBinding loadMetaData(Element element) throws Exception {
        String classExpr = element.getAttribute("class");
        String tag = element.getAttribute("tag");
        String name = this.getName(element, "metadata: " + tag + " " + classExpr);
        ClassMetaDataLoader loader = this.manager.findClassMetaDataLoader(tag);
        return loader.importMetaData(element, name, tag, classExpr);
    }

    public void undeployMetaDataLoader(Element element) throws Exception {
        String tag = element.getAttribute("tag");
        this.manager.removeClassMetaDataLoader(tag);
    }

    public void deployMetaDataLoader(Element element) throws Exception {
        String tag = element.getAttribute("tag");
        String classname = element.getAttribute("class");
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
        ClassMetaDataLoader loader = (ClassMetaDataLoader)clazz.newInstance();
        if (loader instanceof XmlLoadable) {
            ((XmlLoadable)loader).importXml(element);
        }
        this.manager.addClassMetaDataLoader(tag, loader);
    }

    public void deployClassMetaData(Element element) throws Exception {
        ClassMetaDataBinding data = this.loadMetaData(element);
        this.manager.addClassMetaData(data);
    }

    public void undeployClassMetaData(Element element) throws Exception {
        String classExpr = element.getAttribute("class");
        String tag = element.getAttribute("tag");
        String name = this.getName(element, "metadata: " + tag + " " + classExpr);
        this.manager.removeClassMetaData(name);
    }

    public void undeployPointcut(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        this.manager.removePointcut(name);
    }

    public void undeployPluggablePointcut(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        this.manager.removePointcut(name);
    }

    public void deployPluggablePointcut(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("pluggable pointcut declaration must have a name associated with it");
        }
        String clazz = pointcut.getAttribute("class");
        if (clazz != null && clazz.trim().equals("")) {
            throw new RuntimeException("pluggable pointcut declaration must have an expr associated with it");
        }
        Pointcut p = null;
        Class<?> pClass = null;
        try {
            pClass = Thread.currentThread().getContextClassLoader().loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("pluggable pointcut class not found: " + clazz);
        }
        p = (Pointcut)pClass.newInstance();
        if (p instanceof XmlLoadable) {
            ((XmlLoadable)p).importXml(pointcut);
        }
        this.manager.addPointcut(p);
    }

    public void undeployDynamicCFlow(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        this.manager.removeDynamicCFlow(name);
    }

    public void deployDynamicCFlow(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("dynamic cflow declaration must have a name associated with it");
        }
        String clazz = pointcut.getAttribute("class");
        if (clazz != null && clazz.trim().equals("")) {
            throw new RuntimeException("dynamic cflow declaration must have an expr associated with it");
        }
        this.manager.addDynamicCFlow(name, new DynamicCFlowDefinition(pointcut, clazz, name));
    }

    public void deployPointcut(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("pointcut declaration must have a name associated with it");
        }
        String expr = pointcut.getAttribute("expr");
        if (expr == null || expr.trim().equals("")) {
            throw new RuntimeException("pointcut declaration must have an expr associated with it");
        }
        PointcutExpression p = null;
        try {
            p = new PointcutExpression(name, expr);
        }
        catch (ParseException ex) {
            throw new RuntimeException("<pointcut name='" + name + "' expr='" + expr + "'/> failed", ex);
        }
        this.manager.addPointcut(p);
    }

    public void undeployPrepare(Element pointcut) throws Exception {
        String name = this.getName(pointcut, "prepare");
        this.manager.removePointcut(name);
    }

    public void deployPrepare(Element pointcut) throws Exception {
        String name = this.getName(pointcut, "prepare");
        String expr = pointcut.getAttribute("expr");
        if (expr != null && expr.trim().equals("")) {
            throw new RuntimeException("pointcut declaration must have an expr associated with it");
        }
        PointcutExpression p = null;
        try {
            p = new PointcutExpression(name, expr);
        }
        catch (ParseException ex) {
            throw new RuntimeException("<prepare> failed: " + expr, ex);
        }
        this.manager.addPointcut(p);
    }

    public void deployAnnotationIntroduction(Element pointcut) throws Exception {
        this.manager.addAnnotationIntroduction(this.loadAnnotationIntroduction(pointcut));
    }

    public void deployAnnotationOverride(Element pointcut) throws Exception {
        this.manager.addAnnotationOverride(this.loadAnnotationIntroduction(pointcut));
    }

    public void undeployAnnotationIntroduction(Element pointcut) throws Exception {
        this.manager.removeAnnotationIntroduction(this.loadAnnotationIntroduction(pointcut));
    }

    public void undeployAnnotationOverride(Element pointcut) throws Exception {
        this.manager.removeAnnotationOverride(this.loadAnnotationIntroduction(pointcut));
    }

    public AnnotationIntroduction loadAnnotationIntroduction(Element pointcut) throws Exception {
        String expr = pointcut.getAttribute("expr");
        if (expr != null && expr.trim().equals("")) {
            throw new RuntimeException("annotation introduction must have an expr attribute");
        }
        String invisible = pointcut.getAttribute("invisible");
        if (invisible != null && expr.trim().equals("")) {
            throw new RuntimeException("annotation introduction must have an invisible attribute");
        }
        boolean isInvisble = new Boolean(invisible);
        String annotation = XmlHelper.getElementContent(pointcut);
        return AnnotationIntroduction.createComplexAnnotationIntroduction(expr, annotation, isInvisble);
    }

    public void undeployIntroductionPointcut(Element pointcut) throws Exception {
        String name = this.getName(pointcut, "introduction-pointcut");
        this.manager.removeInterfaceIntroduction(name);
    }

    public void deployIntroductionPointcut(Element pointcut) throws Exception {
        String ast;
        String name = this.getName(pointcut, "introduction");
        String classExpr = pointcut.getAttribute("class");
        if (classExpr != null && classExpr.trim().equals("")) {
            classExpr = null;
        }
        if ((ast = pointcut.getAttribute("expr")) != null && ast.trim().equals("")) {
            ast = null;
        }
        if (classExpr == null && ast == null) {
            throw new RuntimeException("A class nor a expr attribute is defined for this <introduction>");
        }
        if (classExpr != null && ast != null) {
            throw new RuntimeException("You cannot define both a class and expr attribute in the same <introduction>");
        }
        String intfs = XmlHelper.getOptionalChildContent(pointcut, "interfaces");
        String[] ifaces = null;
        if (intfs != null) {
            StringTokenizer tokenizer = new StringTokenizer(intfs, ",");
            ArrayList<String> interfaces = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String intf = tokenizer.nextToken().trim();
                if (intf.equals("")) continue;
                interfaces.add(intf);
            }
            ifaces = interfaces.toArray(new String[interfaces.size()]);
        }
        InterfaceIntroduction pcut = null;
        if (classExpr != null) {
            pcut = new InterfaceIntroduction(name, classExpr, ifaces);
        } else {
            ASTStart start = new TypeExpressionParser(new StringReader(ast)).Start();
            pcut = new InterfaceIntroduction(name, start, ifaces);
        }
        Iterator it = XmlHelper.getChildrenByTagName(pointcut, "mixin");
        while (it.hasNext()) {
            Element mixin = (Element)it.next();
            if (mixin == null) continue;
            String construction = XmlHelper.getOptionalChildContent(mixin, "construction");
            String classname = XmlHelper.getUniqueChildContent(mixin, "class");
            String isTransientString = mixin.getAttribute("transient");
            boolean isTransient = true;
            isTransient = isTransientString == null || isTransientString.trim().equals("") ? true : new Boolean(isTransientString);
            intfs = XmlHelper.getUniqueChildContent(mixin, "interfaces");
            StringTokenizer tokenizer = new StringTokenizer(intfs, ",");
            ArrayList<String> interfaces = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String intf = tokenizer.nextToken().trim();
                if (intf.equals("")) continue;
                interfaces.add(intf);
            }
            ifaces = interfaces.toArray(new String[interfaces.size()]);
            pcut.getMixins().add(new InterfaceIntroduction.Mixin(classname, ifaces, construction, isTransient));
        }
        this.manager.addInterfaceIntroduction(pcut);
    }

    public void deployTypedef(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("typedef declaration must have a name associated with it");
        }
        String expr = pointcut.getAttribute("expr");
        if (expr == null || expr.trim().equals("")) {
            throw new RuntimeException("typedef declaration must have an expr associated with it");
        }
        try {
            TypedefExpression typedef = new TypedefExpression(name, expr);
            this.manager.addTypedef(typedef);
        }
        catch (ParseException ex) {
            throw new RuntimeException("<typedef name='" + name + "' expr='" + expr + "'/> failed", ex);
        }
    }

    public void undeployTypedef(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        this.manager.removeTypedef(name);
    }

    public void deployDeclare(Element pointcut, String tagName) throws Exception {
        String name = this.getName(pointcut, "declare");
        String expr = pointcut.getAttribute("expr");
        if (expr == null || expr.trim().equals("")) {
            throw new RuntimeException("declare declaration must have an expr associated with it");
        }
        boolean warning = tagName.equals("declare-warning");
        String msg = XmlHelper.getElementContent(pointcut);
        try {
            DeclareDef declare = new DeclareDef(name, expr, warning, msg);
            this.manager.addDeclare(declare);
        }
        catch (ParseException ex) {
            throw new RuntimeException("<declare name='" + name + "' expr='" + expr + "'/> failed", ex);
        }
    }

    public void undeployDeclare(Element pointcut) throws Exception {
        String name = this.getName(pointcut, "declare");
        this.manager.removeDeclare(name);
    }

    private void setupDefaultName(URL url) throws Exception {
        if (url == null) {
            return;
        }
        this.counter = 0;
        this.defaultBaseName = url.toString();
    }

    public void deployXML(Document doc, URL url) throws Exception {
        this.setupDefaultName(url);
        Element top = doc.getDocumentElement();
        try {
            this.deployTopElements(top);
        }
        catch (Exception e) {
            System.err.println("[error] " + e.getMessage() + " " + url);
            if (AspectManager.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployDomain(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("domain declaration must have a name associated with it");
        }
        boolean parentFirst = false;
        String parentFirstString = element.getAttribute("parentFirst");
        parentFirst = parentFirstString == null || parentFirstString.trim().equals("") ? false : new Boolean(parentFirstString);
        boolean inheritDefs = true;
        String inheritDefsString = element.getAttribute("inheritDefinitions");
        inheritDefs = inheritDefsString == null || inheritDefsString.trim().equals("") ? true : new Boolean(inheritDefsString);
        boolean inheritBindings = false;
        String inheritBindingsString = element.getAttribute("inheritBindings");
        inheritBindings = inheritBindingsString == null || inheritBindingsString.trim().equals("") ? false : new Boolean(inheritBindingsString);
        AspectManager parent = this.manager;
        String extend = element.getAttribute("extends");
        if (extend != null && !extend.trim().equals("")) {
            DomainDefinition parentDef = this.manager.getContainer(extend = extend.trim());
            if (parentDef == null) {
                throw new RuntimeException("unable to find parent Domain: " + extend);
            }
            parent = parentDef.getManager();
        }
        DomainDefinition def = new DomainDefinition(name, parent, parentFirst, inheritDefs, inheritBindings);
        AspectManager push = this.manager;
        try {
            this.manager = def.getManager();
            this.deployTopElements(element);
        }
        finally {
            this.manager = push;
        }
        push.addContainer(def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployDomain(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("container declaration must have a name associated with it");
        }
        DomainDefinition def = this.manager.getContainer(name);
        if (def == null) {
            throw new RuntimeException("Unable to undeploy container: " + name);
        }
        AspectManager push = this.manager;
        ArrayList oldFactories = this.factories;
        ArrayList oldAspects = this.aspects;
        ArrayList oldBindings = this.bindings;
        try {
            this.factories = new ArrayList();
            this.aspects = new ArrayList();
            this.bindings = new ArrayList();
            this.manager = def.getManager();
            this.undeployTopElements(element);
            this.bulkUndeploy();
        }
        finally {
            this.manager = push;
        }
        push.removeContainer(name);
        this.factories = oldFactories;
        this.aspects = oldAspects;
        this.bindings = oldBindings;
    }

    private void deployTopElements(Element top) throws Exception {
        NodeList children = top.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element element = (Element)children.item(i);
            String tag = element.getTagName();
            if (tag.equals("interceptor")) {
                this.deployInterceptor(element);
                continue;
            }
            if (tag.equals("introduction")) {
                this.deployIntroductionPointcut(element);
                continue;
            }
            if (tag.equals("metadata-loader")) {
                this.deployMetaDataLoader(element);
                continue;
            }
            if (tag.equals("metadata")) {
                this.deployClassMetaData(element);
                continue;
            }
            if (tag.equals("stack")) {
                this.deployInterceptorStack(element);
                continue;
            }
            if (tag.equals("aspect")) {
                this.deployAspect(element, "Aspect");
                continue;
            }
            if (tag.equals("pointcut")) {
                this.deployPointcut(element);
                continue;
            }
            if (tag.equals("pluggable-pointcut")) {
                this.deployPluggablePointcut(element);
                continue;
            }
            if (tag.equals("bind")) {
                this.deployBinding(element);
                continue;
            }
            if (tag.equals("prepare")) {
                this.deployPrepare(element);
                continue;
            }
            if (tag.equals("cflow-stack")) {
                this.deployCFlowStack(element);
                continue;
            }
            if (tag.equals("dynamic-cflow")) {
                this.deployDynamicCFlow(element);
                continue;
            }
            if (tag.equals("annotation-introduction")) {
                this.deployAnnotationIntroduction(element);
                continue;
            }
            if (tag.equals("annotation")) {
                this.deployAnnotationOverride(element);
                continue;
            }
            if (tag.equals("typedef")) {
                this.deployTypedef(element);
                continue;
            }
            if (tag.equals("domain")) {
                this.deployDomain(element);
                continue;
            }
            if (tag.equals("precedence")) {
                this.deployPrecedence(element);
                continue;
            }
            if (tag.equals("declare-error") || tag.equals("declare-warning")) {
                this.deployDeclare(element, tag);
                continue;
            }
            throw new IllegalArgumentException("Unknown AOP tag: " + tag);
        }
    }

    public void undeployXML(Document doc, URL url) throws Exception {
        this.setupDefaultName(url);
        this.undeployTopElements(doc.getDocumentElement());
        this.bulkUndeploy();
    }

    private void bulkUndeploy() {
        int i;
        this.manager.removeBindings(this.bindings);
        for (i = 0; i < this.factories.size(); ++i) {
            String factory = (String)this.factories.get(i);
            this.manager.removeInterceptorFactory(factory);
        }
        for (i = 0; i < this.aspects.size(); ++i) {
            String aspect = (String)this.aspects.get(i);
            this.manager.removeAspectDefinition(aspect);
        }
    }

    private void undeployTopElements(Element top) throws Exception {
        NodeList children = top.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element element = (Element)children.item(i);
            String tag = element.getTagName();
            if (tag.equals("interceptor")) {
                this.undeployInterceptor(element);
                continue;
            }
            if (tag.equals("introduction")) {
                this.undeployIntroductionPointcut(element);
                continue;
            }
            if (tag.equals("metadata-loader")) {
                this.undeployMetaDataLoader(element);
                continue;
            }
            if (tag.equals("metadata")) {
                this.undeployClassMetaData(element);
                continue;
            }
            if (tag.equals("stack")) {
                this.undeployInterceptorStack(element);
                continue;
            }
            if (tag.equals("aspect")) {
                this.undeployAspect(element);
                continue;
            }
            if (tag.equals("pointcut")) {
                this.undeployPointcut(element);
                continue;
            }
            if (tag.equals("bind")) {
                this.undeployBinding(element);
                continue;
            }
            if (tag.equals("prepare")) {
                this.undeployPrepare(element);
                continue;
            }
            if (tag.equals("cflow-stack")) {
                this.undeployCFlowStack(element);
                continue;
            }
            if (tag.equals("pluggable-pointcut")) {
                this.undeployPluggablePointcut(element);
                continue;
            }
            if (tag.equals("dynamic-cflow")) {
                this.undeployDynamicCFlow(element);
                continue;
            }
            if (tag.equals("typedef")) {
                this.undeployTypedef(element);
                continue;
            }
            if (tag.equals("annotation-introduction")) {
                this.undeployAnnotationIntroduction(element);
                continue;
            }
            if (tag.equals("annotation")) {
                this.undeployAnnotationOverride(element);
                continue;
            }
            if (tag.equals("domain")) {
                this.undeployDomain(element);
                continue;
            }
            if (!tag.equals("declare-error") && !tag.equals("declare-warning")) continue;
            this.undeployDeclare(element);
        }
    }

    public void deploy(URL url, AspectManager manager) throws Exception {
        this.setManager(manager);
        this.deployXML(AspectXmlLoader.loadURL(url), url);
    }

    public void undeploy(URL url, AspectManager manager) throws Exception {
        this.setManager(manager);
        this.undeployXML(AspectXmlLoader.loadURL(url), url);
    }

    public static void deployXML(URL url) throws Exception {
        XmlLoader loader = null;
        loader = factory == null ? new AspectXmlLoader() : factory.create();
        loader.deploy(url, AspectManager.instance());
    }

    public static void undeployXML(URL url) throws Exception {
        XmlLoader loader = null;
        loader = factory == null ? new AspectXmlLoader() : factory.create();
        loader.undeploy(url, AspectManager.instance());
    }

    private static Document loadURL(URL configURL) throws Exception {
        InputStream is;
        InputStream inputStream = is = configURL != null ? configURL.openStream() : null;
        if (is == null) {
            throw new IOException("Failed to obtain InputStream from url: " + configURL);
        }
        DocumentBuilderFactory docBuilderFactory = null;
        docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(false);
        InputSource source = new InputSource(is);
        URL url = AspectXmlLoader.class.getResource("/jboss-aop_1_0.dtd");
        source.setSystemId(url.toString());
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        docBuilder.setEntityResolver(new Resolver());
        Document doc = docBuilder.parse(source);
        return doc;
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.endsWith("jboss-aop_1_0.dtd")) {
                try {
                    URL url = (class$org$jboss$aop$AspectXmlLoader == null ? (class$org$jboss$aop$AspectXmlLoader = AspectXmlLoader.class$("org.jboss.aop.AspectXmlLoader")) : class$org$jboss$aop$AspectXmlLoader).getResource("/jboss-aop_1_0.dtd");
                    InputStream is = url.openStream();
                    return new InputSource(is);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
    }
}

