/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.util.apllog.AplLogger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteOidMaster {
    protected static Log m_log = LogFactory.getLog(DeleteOidMaster.class);
    protected SnmpTrapMasterPK m_OidPk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delete(SnmpTrapMasterInfo oidData) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, FinderException {
        AccessLock.lock((String)"MONITOR_SNMPTRAP");
        this.m_OidPk = new SnmpTrapMasterPK(oidData.getMib(), oidData.getTrapOid(), oidData.getGenericId(), oidData.getSpecificId());
        TransactionManager tm = null;
        Transaction tx = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            if (tm.getTransaction() != null) {
                oldTx = tm.suspend();
            }
            try {
                if (tm.getTransaction() == null) {
                    tm.begin();
                    tx = tm.getTransaction();
                }
                if (result = this.deleteOIDMaster()) {
                    tx.commit();
                }
            }
            catch (NotSupportedException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (RollbackException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (HeuristicMixedException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (HeuristicRollbackException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            finally {
                if (tx != null) {
                    if (!result) {
                        tx.rollback();
                    }
                    tx = null;
                }
            }
            if (oldTx == null) return result;
        }
        catch (Throwable throwable) {
            if (oldTx == null) throw throwable;
            try {
                tm.resume(oldTx);
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (IllegalStateException e) {
                this.outputLog(e, "delete()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
        }
        try {
            tm.resume(oldTx);
            return result;
        }
        catch (InvalidTransactionException e) {
            this.outputLog((Exception)((Object)e), "delete()");
            throw e;
        }
        catch (IllegalStateException e) {
            this.outputLog(e, "delete()");
            throw e;
        }
        catch (SystemException e) {
            this.outputLog((Exception)((Object)e), "delete()");
            throw e;
        }
    }

    public boolean deleteOIDMaster() throws NamingException, FinderException {
        boolean result = false;
        try {
            SnmpTrapMasterLocal OIDMaster = SnmpTrapMasterUtil.getLocalHome().findByPrimaryKey(this.m_OidPk);
            OIDMaster.remove();
            result = true;
        }
        catch (NamingException e) {
            this.outputLog(e, "deleteOIDMaster()");
            throw e;
        }
        catch (EJBException e) {
            this.outputLog((Exception)((Object)e), "deleteOIDMaster()");
            throw e;
        }
        catch (RemoveException e) {
            this.outputLog((Exception)((Object)e), "deleteOIDMaster()");
            try {
                throw e;
            }
            catch (RemoveException e1) {
                this.outputLog((Exception)((Object)e1), "deleteOIDMaster()");
            }
        }
        return result;
    }

    private void outputLog(Exception e, String method) {
        AplLogger apllog = new AplLogger("TRAP", "trap");
        Object[] args = new String[]{this.m_OidPk.getMib(), this.m_OidPk.getTrapOid(), Integer.toString(this.m_OidPk.getGenericId()), Integer.toString(this.m_OidPk.getSpecificId())};
        apllog.put("SYS", "001", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

