/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class SinglePortVirtualServerSocket
extends ServerSocket {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$SinglePortVirtualServerSocket == null ? (class$org$jboss$remoting$transport$multiplex$SinglePortVirtualServerSocket = SinglePortVirtualServerSocket.class$("org.jboss.remoting.transport.multiplex.SinglePortVirtualServerSocket")) : class$org$jboss$remoting$transport$multiplex$SinglePortVirtualServerSocket);
    private MultiplexingManager manager;
    private Protocol protocol;
    private Socket actualSocket;
    private boolean bound = false;
    private boolean connected = false;
    private boolean closed = false;
    private boolean startedIndependently = false;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$SinglePortVirtualServerSocket;

    public SinglePortVirtualServerSocket() throws IOException {
    }

    public SinglePortVirtualServerSocket(int port) throws IOException {
        log.info("entering SinglePortVirtualServerSocket(int port)");
        this.bind(new InetSocketAddress(port));
    }

    public SinglePortVirtualServerSocket(InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws IOException {
        log.info("entering SinglePortVirtualServerSocket(InetSocketAddress remoteAddress, InetSocketAddress localAddress)");
        this.bind(localAddress);
        if (!this.connected) {
            try {
                this.connect(remoteAddress);
            }
            catch (IOException e) {
                if (this.manager != null && this.manager.getServerSocket() == this) {
                    this.manager.unRegisterServerSocket(this);
                }
                log.error(e);
                throw e;
            }
        }
    }

    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        SocketId clientPort = this.protocol.acceptConnect();
        log.debug("clientPort:  " + clientPort.getPort());
        VirtualSocket virtualSocket = new VirtualSocket(this.manager, clientPort);
        int localPort = virtualSocket.getLocalVirtualPort();
        this.protocol.answerConnect(localPort);
        return virtualSocket;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 0);
    }

    public void bind(SocketAddress socketAddress, int backlog) throws IOException {
        if (backlog != 0) {
            throw new SocketException("bind(): backlog not implemented");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkListen(inetSocketAddress.getPort());
        }
        this.manager = MultiplexingManager.getaManagerByLocalAddress(inetSocketAddress);
        this.actualSocket = this.manager.getSocket();
        this.bound = true;
        this.manager.registerServerSocket(this);
        if (this.manager.isConnected()) {
            this.protocol = this.manager.getProtocol();
            this.protocol.registerRemoteServerSocket();
            this.connected = true;
        }
        log.info(this.toString());
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.manager.unRegisterServerSocket(this);
        this.protocol.unregisterRemoteServerSocket();
    }

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        return this.actualSocket.getLocalAddress();
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.actualSocket.getLocalPort();
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return this.actualSocket.getLocalSocketAddress();
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        StringBuffer answer = new StringBuffer().append("SinglePortVirtualServerSocket[");
        if (!this.isBound()) {
            return answer.append("unbound]").toString();
        }
        answer.append("local address=" + this.getInetAddress() + ":" + this.getLocalPort());
        if (!this.isConnected()) {
            return answer.append("]").toString();
        }
        return answer.append(", remote address=" + this.actualSocket.getInetAddress() + ":" + this.actualSocket.getPort() + "]").toString();
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    public synchronized void connect(SocketAddress socketAddress, int timeout) throws IOException {
        if (timeout > 0) {
            throw new SocketException("timeout not yet implemented");
        }
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (this.isConnected()) {
            if (this.getRemoteAddress().equals(inetSocketAddress.getAddress())) {
                return;
            }
            throw new SocketException("already connected");
        }
        if (this.manager == null) {
            this.manager = MultiplexingManager.getaManagerByRemoteAddress(inetSocketAddress);
        }
        this.actualSocket = this.manager.getSocket();
        this.protocol = this.manager.getProtocol();
        if (!this.manager.isConnected()) {
            this.manager.connect(inetSocketAddress);
            this.protocol = this.manager.getProtocol();
            this.protocol.connect(SocketId.SERVER_SOCKET_ID);
        }
        this.protocol.registerRemoteServerSocket();
        if (!this.isBound()) {
            log.info("calling registerServerSocket()");
            this.manager.registerServerSocket(this);
            this.bound = true;
        }
        this.connected = true;
        log.info(this.toString());
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public InetAddress getRemoteAddress() {
        return this.actualSocket.getInetAddress();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

