/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.invocation;

import java.lang.reflect.Method;
import org.jboss.remoting.invocation.RemoteInvocation;

public class NameBasedInvocation
extends RemoteInvocation {
    static final long serialVersionUID = -6507163932605308471L;
    private final String[] sig;

    public NameBasedInvocation(Method method, Object[] params) {
        super(method.getName(), params);
        this.sig = this.generateSignatureFromMethod(method);
    }

    private String[] generateSignatureFromMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] signature = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            signature[i] = parameterType.getName();
        }
        return signature;
    }

    public NameBasedInvocation(String methodName, Object[] params, String[] sig) {
        super(methodName, params);
        this.sig = sig;
    }

    public String[] getSignature() {
        return this.sig;
    }

    public String toString() {
        return "NameBasedInvocation [" + this.methodName + "]";
    }
}

