#!/bin/sh

#Copyright (C) 2006, 2007 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み
export EXEC_PATH=${0%/*}

. ${EXEC_PATH}/install.cfg

EXEC_USER=`/usr/bin/whoami`

# check for incorrect user
if [ $EXEC_USER != "root" ]; then
    echo "Please execute by a root user."
    exit
fi



echo ""
echo "Initialization for Hinemos installation will be started."
echo ""


# カーネルリソースの変更
if [ "${CURRENT_SHMMAX}" -lt "${SHMMAX}" ] ;then
    echo "Current SHMMAX size is "\
    `echo $CURRENT_SHMMAX`"."
    echo " May I change SHMMAX size $SHMMAX (512MB) ? (Y/N default:Y)"
    read ANS
    ANS=${ANS:-Y}
    case ${ANS} in
        y|Y)
            echo $SHMMAX > /proc/sys/kernel/shmmax
            echo "" >> /etc/sysctl.conf
            echo "#add for Hinemos Manager" >> /etc/sysctl.conf
            echo "kernel.shmmax=${SHMMAX}" >> /etc/sysctl.conf
            ;;
        n|N)
            echo "Exit Installer"
            exit 0
            ;;
        *)
            ;;
    esac
fi

# カーネルリソースの変更
if [ "${CURRENT_SHMALL}" -lt "${SHMALL}" ] ;then
    echo " Current SHMALL size is "\
    `echo $CURRENT_SHMALL`"."
    echo "May I change SHMALL size $SHMALL (512MB) ? (Y/N default:Y)"
    read ANS
    ANS=${ANS:-Y}
    case ${ANS} in
        y|Y)
            echo $SHMALL > /proc/sys/kernel/shmall
            echo "" >> /etc/sysctl.conf
            echo "#add for Hinemos Manager" >> /etc/sysctl.conf
            echo "kernel.shmall=${SHMALL}" >> /etc/sysctl.conf
            ;;
        n|N)
            echo "Exit Installer."
            exit 0
            ;;
        *)
            ;;
    esac
fi

# Hinemosユーザの作成
grep $HINEMOS_USER:x /etc/passwd && TMP=1
if [  "${TMP}" -a  -d $HINEMOS_HOME ] ; then
    while [ 1 ] ;
      do
      echo "$HINEMOS_HOME exists."
      echo "Do you change the access permission and the owner?(Y/N default:Y) "
      read ANS
      ANS=${ANS:-Y}
      case ${ANS} in 
	  y|Y)	
	      chown -R  $HINEMOS_USER:$HINEMOS_USER $HINEMOS_HOME 
	      chmod 700 $HINEMOS_HOME
	      echo "The access permission and the owner were changed."
	      break
	      ;;
	  n|N)
	      echo "Make sure that user hinemos enables to write to $HINEMOS_HOME ."
	      echo "Installation will fail when it doesn't have writable authority."
	      break
	      ;;
	  *)	
	      ;;
      esac
    done
elif [ -d $HINEMOS_HOME ]; then
    echo ""
    mv $HINEMOS_HOME /opt/hinemos.org
    echo "Create user $HINEMOS_USER ."
    #/usr/sbin/useradd -d $HINEMOS_HOME  $HINEMOS_USER
    /usr/sbin/useradd $HINEMOS_USER
    /usr/bin/passwd $HINEMOS_USER
    
elif [ "${TMP}" ]; then
    mkdir -p $HINEMOS_HOME
    chown -R  $HINEMOS_USER:$HINEMOS_USER $HINEMOS_HOME
    echo "The installation Directory was created."
else
    echo "Create user $HINEMOS_USER ."
    #/usr/sbin/useradd -d $HINEMOS_HOME  $HINEMOS_USER
    /usr/sbin/useradd $HINEMOS_USER
    /usr/bin/passwd $HINEMOS_USER	
fi

echo ""

#/opt/hinemos以下にコピー
echo "Start copying required files."
cp -pr $EXEC_PATH/hinemos /opt
#インストールディレクトリに応じて各ファイルを変更
REPLACE_PATH=`echo $HINEMOS_HOME | sed 's/\//\\\\\//g'`
sed "s/%%hinemos_install_dir%%/$REPLACE_PATH/" $EXEC_PATH/hinemos.cfg > $HINEMOS_HOME/hinemos.cfg
SCRIPTS=`ls $EXEC_PATH/bin`
for CURSCRIPT in $SCRIPTS
do
	     sed "s/%%hinemos_install_dir%%/$REPLACE_PATH/" $EXEC_PATH/bin/$CURSCRIPT > $HINEMOS_HOME/bin/$CURSCRIPT
	chmod 700 $HINEMOS_HOME/bin/$CURSCRIPT
done

#ftpサーバのIPアドレス
echo "Please input ftp server's IP address  for corrective run (default:127.0.0.1)"
read FTP_SERVER
FTP_SERVER=${FTP_SERVER:-"127.0.0.1"}
sed "s/%%hinemos_ftp_host%%/$FTP_SERVER/"  $EXEC_PATH/hinemos/lib/cr/cp.sh > $HINEMOS_HOME/lib/cr/cp.sh
sed "s/%%hinemos_ftp_host%%/$FTP_SERVER/"  $EXEC_PATH/hinemos/lib/cr/rpminstall.sh > $HINEMOS_HOME/lib/cr/rpminstall.sh
sed "s/%%jre_version%%/$JRE_NAME/"  $EXEC_PATH/hinemos/lib/cr/agent_install.sh > $HINEMOS_HOME/lib/cr/agent_install.sh

chown -R  $HINEMOS_USER:$HINEMOS_USER $HINEMOS_HOME

echo "Copying required files was completed."
echo ""

echo "Installing JRE"
sleep 2
echo ""
cp ${EXEC_PATH}/jre-1_5_0_09-linux-i586.bin ${HINEMOS_HOME}
CURRENT_DIR=`pwd`
cd ${HINEMOS_HOME}
${HINEMOS_HOME}/jre-1_5_0_09-linux-i586.bin
rm ${HINEMOS_HOME}/jre-1_5_0_09-linux-i586.bin
cd $CURRENT_DIR


#syslog-ngインストール
echo "Start the installation of syslog-ng."
	chmod 766 /dev/log

    # rpmインストール
    rpm -Uvh --force $SYSLOG_NG_RPM
                                                                                
    ## syslog-ng の編集
    if [ 0 -eq `grep -i hinemos /etc/syslog-ng/syslog-ng.conf 2> /dev/null | wc -l` ] ; then
        sed -e "s%__HINEMOS_HOME__%$HINEMOS_HOME%g" -e "s%__JRE__%$JRE_NAME%g" ./hinemos.conf >> /etc/syslog-ng/syslog-ng.conf

    else
        # ver2.1がインストールされていた場合、hinemos-commons.jarが追加されたパスと置き換える
        if [ 0 -eq `grep -i hinemos-commons.jar /etc/syslog-ng/syslog-hg.conf 2> /dev/null | wc -l` ] ; then

            OLD_PATH=$(grep -i clustercontrol /etc/syslog-ng/syslog-ng.conf)
            sed -e "s@$OLD_PATH@hinemos_path@g" /etc/syslog-ng/syslog-ng.conf | sed -e "/hinemos_path/d" >\ /etc/syslog-ng/syslog-ng_tmp.conf
            grep -i hinemos-commons.jar ./hinemos.conf | sed -e "s%__HINEMOS_HOME__%$HINEMOS_HOME%g" -e "s\%__JRE__%$JRE_NAME%g" >> /etc/syslog-ng/syslog-ng_tmp.conf
            mv /etc/syslog-ng/syslog-ng_tmp.conf /etc/syslog-ng/syslog-ng.conf

	else
            echo "/etc/syslog-ng/syslog-ng.conf setting is incomplete. Please check it."
            exit;
        fi

    fi
                                                                              
    # syslog-ng の再起動
    /etc/init.d/syslog stop
    /etc/init.d/syslog-ng start
    /sbin/chkconfig --level 2345 syslog off
    /sbin/chkconfig --level 2345 syslog-ng on


#/etc/hostsの設定
HOSTS_FILE=/etc/hosts
HOST=`hostname`

while [ 1 ];
do
    echo ""
    echo "${HOSTS_FILE} is changed."
    echo "May I change ${HOSTS_FILE}? (Y/N)"
    read ANS
    echo ""
    case ${ANS} in
        y|Y)
            #IPアドレスの入力
            while [ 1 ];
            do
                echo "Please input IP address of the server that installs the manager."
                read IPADDRESS
                echo "Is it good in ${IPADDRESS}? (Y/N default:Y)"
                read IP_ANS
                IP_ANS=${IP_ANS:-Y}
                echo ""
                case ${IP_ANS} in
                    y|Y)
                        break
                        ;;
                    n|N)
                        ;;
                    *)
                        echo "Please input Y or N."
                        ;;
                esac
            done

            #hostsファイルのバックアップを取る
            cp -pr ${HOSTS_FILE} ${HOSTS_FILE}.bk

            TMP_HOST=`cat ${HOSTS_FILE} | grep ${HOST}.*localhost | grep -v ^\#`
            _FLAG=0

            #TMP_HOSTが空ではなく、かつ、コメントアウトされていない場合
            if [ "${TMP_HOST}" != "" ] ; then
                TMP_INSERT=`echo ${TMP_HOST} | sed "s/ ${HOST} /\t/g"`
                sed "s/${TMP_HOST}/#${TMP_HOST}\n${TMP_INSERT}/g" ${HOSTS_FILE} > ${HOSTS_FILE}_tmp
                mv -f ${HOSTS_FILE}_tmp ${HOSTS_FILE}
                _FLAG=1
            fi


            #hostsファイルに、ホスト名に対するIPアドレスが振られていない場合
            if [ "`grep ${HOST} ${HOSTS_FILE} | grep -v ^\#`" = "" ]; then
                echo "${IPADDRESS}	${HOST}" >> ${HOSTS_FILE}
                _FLAG=1
            fi


            #ホスト名とIPアドレス対応の最終確認
            #ホスト名に対し、入力されたIPアドレス以外のアドレスが登録されていた場合
            if [ "${IPADDRESS}" != "`grep ${HOST} ${HOSTS_FILE} | grep -v ^\# | awk '{print $1}'`" ]; then
                echo "IP address different from input IP address is set to ${HOST}. "
                echo "Please change the setting according to the installation manual."
                mv -f ${HOSTS_FILE}.bk ${HOSTS_FILE} 
                break
            fi

            if [ "${_FLAG}" != "0" ]; then
                echo "${HOSTS_FILE} was changed."
                echo "Please confirm it after the installer ends."
            else
                echo "${HOSTS_FILE} need not be changed."
            fi
            rm -f ${HOSTS_FILE}.bk

            break
            ;;
        n|N)
            echo "${HOSTS_FILE} was not changed."
            echo "Please change the setting according to the installation manual."
            sleep 1
            break
            ;;
        *)
            echo "Please input Y or N."
            ;;
    esac
done

echo ""
sleep 1

#DB初期化
echo "The data base is initialized."

cd ${HINEMOS_HOME}
su -c ${HINEMOS_HOME}/sbin/db_init/pg_init.sh $HINEMOS_USER

#LDAP初期化

echo ""

cd ${HINEMOS_HOME}
su -c ${HINEMOS_HOME}/sbin/db_init/ldap_init.sh $HINEMOS_USER

REVAL=$?
if [ "$REVAL" -eq 0 ]; then
	echo "LDAP data is initialized."
	echo ""
fi

