#!/bin/sh

GREP_PROC="/bin/grep"
EXPECT_PROC="/usr/bin/expect"
SSH_PROC="/usr/bin/ssh"
SCP_PROC="/usr/bin/scp"
TAR_PROC="/bin/tar"
AWK_PROC="/bin/awk"
PWD_PROC="/bin/pwd"
LS_PROC="/bin/ls"
RM_PROC="/bin/rm -rf"

AGENT_HOME="/opt/hinemos_agent"
AGENT_DIR="Hinemos_Agent-2.2.1_rhel4"
AGENT_INSTALL_SH="agent_installer_JP.sh"
AGENT_ARC="hinemos_agent-2.2.1_rhel4.tar.gz"
JRE_VERSION="%%jre_version%%"

# 変数
ip_address=""
pass=""
agent=""
jre_ans=""
col=""
place=""

##
## 引数格納
##
while [ $# -gt 0 ] 
do
  case $1 in
    -i)
      shift
      ip_address=$1
      ;;
    -p)
      shift
      pass=$1 
      ;;
    -a)
      shift
      agent=$1
      archive=`echo ${agent} | ${AWK_PROC} -F\/ '{print $(NF)}'`
      ;;
    -j)
      shift
      jre_ans=$1
      ;;
    -c)
      shift
      col=$1
      ;;
    -w)
      shift
      ${LS_PROC} $1 > /dev/null
      if [ "$?" != 0 ];then
          echo "コピー先が存在しません。"
          exit -1
      fi
      place=$1
      ;;
    *)
      ;;
  esac

  shift 

done


##
## 確認
##

# 入力値の確認
if [ "${ip_address}" = "" ]; then
    echo "Hinemosエージェントインストーラが置いてあるサーバのIPアドレスを入力して下さい。"
    exit -1
elif [ "${pass}" = "" ]; then
    echo "Hinemosエージェントインストーラが置いてあるサーバのrootユーザのパスワードを入力して下さい。"
    exit -1
elif [ "${agent}" = "" ]; then
    echo "Hinemosエージェントインストーラのパスを入力して下さい。"
    exit -1
elif [ "${place}" = "" ]; then
    echo "エージェントインストーラをコピーする先を入力して下さい。"
    exit -1
elif [ "${AGENT_ARC}" != "${archive}" ]; then
	echo "入力されたエージェントパッケージには対応していません。"
	exit -1 
fi

## エージェントインストール配布マシンの設定確認
##
# IPアドレスの確認とパスワードの確認
$EXPECT_PROC -c "
    set timeout 1
    spawn -noecho $SSH_PROC -n ${ip_address} -l root \"
        ${LS_PROC} ${agent}
    \"
    expect {
        -re \".*Name or service not known\" { exit 1}
        \"Are you sure\" { send yes\r }
        timeout
    }
    expect root
    send ${pass}\r
    expect {
        -re \".*${agent}\" { exit 0 }
        -re \".*${LS_PROC}\" { exit 3 }
        timeout { exit 2 }
    }
" > /dev/null
case $? in
    1)
      echo "IP:${ip_address}  IPアドレスが存在しません。"
      exit -1
      ;;
    2)
      echo "IP:${ip_address}  rootユーザのパスワードが間違っています。"
      exit -1
      ;;
    3)
      echo "${agent}は存在しません。"
      exit -1
      ;;
    *)
      break
      ;;
esac


##
## Hinemosエージェントの処理
##

# Hinemosエージェントインストーラを入力されたIPアドレスのサーバからコピーする。
$EXPECT_PROC -c "
    set timeout -1
    spawn $SCP_PROC root@${ip_address}:${agent} ${place}
    expect root
    send ${pass}\r
    expect eof
" > /dev/null

if [ $? != 0 ];then
    echo "Hinemosエージェントインストーラのコピーに失敗しました。"
    exit 10
fi


# Hinemosエージェントの解凍
CURRENT_PLACE=`${PWD_PROC}`
cd ${place}
${TAR_PROC} zxf ${AGENT_ARC} > /dev/null 2>&1
if [ $? != 0 ];then
    echo "Hinemosエージェントの解凍に失敗しました。"
    exit -1
fi

cd ${CURRENT_PLACE}

# 古いjreの削除
[ -d ${AGENT_HOME} ] && ${RM_PROC} ${AGENT_HOME}/${JRE_VERSION}


AGENT_LOG="${place}/${AGENT_DIR}/agent_install.log"

# Hinemosエージェントのインストール
$EXPECT_PROC -c "
    set timeout -1
    spawn ${place}/${AGENT_DIR}/${AGENT_INSTALL_SH}
    expect {
        -re \".*===>\" { send \"1\r\" }
        eof { exit 1 }
    }
    send 1\r
    expect -re \".*\(Y\/N\)\"
    send Y\r
    expect -re \".*IP\"
    send ${ip_address}\r
    expect -re \".*--\"
    send q
    expect -re \".*Do you agree to the above license terms?\"
    send ${jre_ans}\r
    expect -re \".*===>\"
    send ${col}\r
    expect -re \".*===>\"
    send 9\r
    expect eof
" >${AGENT_LOG}

if [ $? = 0 ]; then
    echo "Hinemosエージェントのインストールが完了しました。 ${place}の${AGENT_DIR}/agent_install.log を確認して下さい。" 
else
    echo "Hinemosエージェントのインストールに失敗しました。 "
    echo "詳細は、${place}の${AGENT_DIR}/agent_install.log を確認して下さい。"
    exit -1
fi

exit
